/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;
import wile.rsgauges.libmc.detail.Auxiliaries;

public class Registries {
    private static String modid = null;
    private static String creative_tab_icon = "";
    private static CreativeModeTab creative_tab = null;
    private static final List<Tuple<String, Supplier<? extends Block>>> block_suppliers = new ArrayList<Tuple<String, Supplier<? extends Block>>>();
    private static final List<Tuple<String, Supplier<? extends Item>>> item_suppliers = new ArrayList<Tuple<String, Supplier<? extends Item>>>();
    private static final List<Tuple<String, Supplier<? extends BlockEntityType<?>>>> block_entity_type_suppliers = new ArrayList();
    private static final List<Tuple<String, Supplier<? extends EntityType<?>>>> entity_type_suppliers = new ArrayList();
    private static final List<Tuple<String, Supplier<? extends MenuType<?>>>> menu_type_suppliers = new ArrayList();
    private static final List<String> block_item_order = new ArrayList<String>();
    private static final Map<String, Block> registered_blocks = new HashMap<String, Block>();
    private static final Map<String, Item> registered_items = new HashMap<String, Item>();
    private static final Map<String, BlockEntityType<?>> registered_block_entity_types = new HashMap();
    private static final Map<String, EntityType<?>> registered_entity_types = new HashMap();
    private static final Map<String, MenuType<?>> registered_menu_types = new HashMap();
    private static final Map<String, TagKey<Block>> registered_block_tag_keys = new HashMap<String, TagKey<Block>>();
    private static final Map<String, TagKey<Item>> registered_item_tag_keys = new HashMap<String, TagKey<Item>>();

    public static void init(String mod_id, String creative_tab_icon_item_name) {
        modid = mod_id;
        creative_tab_icon = creative_tab_icon_item_name;
    }

    public static CreativeModeTab getCreativeModeTab() {
        if (creative_tab == null) {
            creative_tab = new CreativeModeTab("tab" + modid){

                public ItemStack m_6976_() {
                    return new ItemStack((ItemLike)registered_items.get(creative_tab_icon));
                }
            };
        }
        return creative_tab;
    }

    public static Block getBlock(String block_name) {
        return registered_blocks.get(block_name);
    }

    public static Item getItem(String name) {
        return registered_items.get(name);
    }

    public static EntityType<?> getEntityType(String name) {
        return registered_entity_types.get(name);
    }

    public static BlockEntityType<?> getBlockEntityType(String block_name) {
        return registered_block_entity_types.get(block_name);
    }

    public static MenuType<?> getMenuType(String name) {
        return registered_menu_types.get(name);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityType("tet_" + block_name);
    }

    public static MenuType<?> getMenuTypeOfBlock(String name) {
        return Registries.getMenuType("ct_" + name);
    }

    public static TagKey<Block> getBlockTagKey(String name) {
        return registered_block_tag_keys.get(name);
    }

    public static TagKey<Item> getItemTagKey(String name) {
        return registered_item_tag_keys.get(name);
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(registered_blocks.values().stream().toList());
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(registered_items.values().stream().toList());
    }

    @Nonnull
    public static List<BlockEntityType<?>> getRegisteredBlockEntityTypes() {
        return Collections.unmodifiableList(registered_block_entity_types.values().stream().toList());
    }

    @Nonnull
    public static List<EntityType<?>> getRegisteredEntityTypes() {
        return Collections.unmodifiableList(registered_entity_types.values().stream().toList());
    }

    public static <T extends Item> void addItem(String registry_name, Supplier<T> supplier) {
        item_suppliers.add((Tuple<String, Supplier<? extends Item>>)new Tuple((Object)registry_name, () -> {
            Item instance = (Item)supplier.get();
            instance.setRegistryName(new ResourceLocation(modid, registry_name));
            return instance;
        }));
    }

    public static <T extends Block> void addBlock(String registry_name, Supplier<T> block_supplier) {
        block_suppliers.add((Tuple<String, Supplier<? extends Block>>)new Tuple((Object)registry_name, () -> {
            Block instance = (Block)block_supplier.get();
            instance.setRegistryName(new ResourceLocation(modid, registry_name));
            return instance;
        }));
    }

    public static <T extends BlockEntity> void addBlockEntityType(String registry_name, BlockEntityType.BlockEntitySupplier<T> ctor, String ... block_names) {
        block_entity_type_suppliers.add(new Tuple((Object)registry_name, () -> {
            Block[] blocks = Arrays.stream(block_names).map(s -> {
                Block b = registered_blocks.get(s);
                if (b == null) {
                    Auxiliaries.logError("registered_blocks does not encompass '" + s + "'");
                }
                return b;
            }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new Block[0]);
            BlockEntityType instance = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)ctor, (Block[])blocks).m_58966_(null);
            instance.setRegistryName(modid, registry_name);
            return instance;
        }));
    }

    public static <T extends BlockEntity> void addBlockEntityType(String registry_name, BlockEntityType.BlockEntitySupplier<T> ctor, Class<? extends Block> block_clazz) {
        block_entity_type_suppliers.add(new Tuple((Object)registry_name, () -> {
            Block[] blocks = registered_blocks.values().stream().filter(block_clazz::isInstance).collect(Collectors.toList()).toArray(new Block[0]);
            BlockEntityType instance = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)ctor, (Block[])blocks).m_58966_(null);
            instance.setRegistryName(modid, registry_name);
            return instance;
        }));
    }

    public static <T extends EntityType<?>> void addEntityType(String registry_name, Supplier<EntityType<?>> supplier) {
        entity_type_suppliers.add(new Tuple((Object)registry_name, supplier));
    }

    public static <T extends MenuType<?>> void addMenuType(String registry_name, MenuType.MenuSupplier<?> supplier) {
        menu_type_suppliers.add(new Tuple((Object)registry_name, () -> {
            MenuType instance = new MenuType(supplier);
            instance.setRegistryName(modid, registry_name);
            return instance;
        }));
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor) {
        Registries.addBlock(registry_name, block_supplier);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor, MenuType.MenuSupplier<?> menu_type_supplier) {
        Registries.addBlock(registry_name, block_supplier);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }

    public static void addOptionalBlockTag(String tag_name, ResourceLocation ... default_blocks) {
        HashSet<Supplier<Block>> default_suppliers = new HashSet<Supplier<Block>>();
        for (ResourceLocation rl : default_blocks) {
            default_suppliers.add(() -> (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }
        TagKey key = ForgeRegistries.BLOCKS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_block_tag_keys.put(tag_name, (TagKey<Block>)key);
    }

    public static void addOptionalBlockTag(String tag_name, String ... default_blocks) {
        Registries.addOptionalBlockTag(tag_name, Arrays.stream(default_blocks).map(ResourceLocation::new).collect(Collectors.toList()).toArray(new ResourceLocation[0]));
    }

    public static void addOptionaItemTag(String tag_name, ResourceLocation ... default_items) {
        HashSet<Supplier<Item>> default_suppliers = new HashSet<Supplier<Item>>();
        for (ResourceLocation rl : default_items) {
            default_suppliers.add(() -> (Item)ForgeRegistries.ITEMS.getValue(rl));
        }
        TagKey key = ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_item_tag_keys.put(tag_name, (TagKey<Item>)key);
    }

    public static void onBlockRegistry(BiConsumer<ResourceLocation, Block> registration) {
        block_suppliers.forEach(e -> {
            Block block = (Block)((Supplier)e.m_14419_()).get();
            ResourceLocation rl = new ResourceLocation(modid, (String)e.m_14418_());
            registration.accept(rl, block);
            registered_blocks.put((String)e.m_14418_(), block);
            block_item_order.add((String)e.m_14418_());
        });
        block_suppliers.clear();
    }

    public static void onItemRegistry(BiConsumer<ResourceLocation, Item> registration) {
        block_item_order.forEach(regname -> {
            Block block = registered_blocks.get(regname);
            ResourceLocation rl = block.getRegistryName();
            BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(Registries.getCreativeModeTab()));
            item.setRegistryName(rl);
            registration.accept(rl, (Item)item);
            registered_items.put(rl.m_135815_(), (Item)item);
        });
        item_suppliers.forEach(e -> {
            Item item = (Item)((Supplier)e.m_14419_()).get();
            registration.accept(new ResourceLocation(modid, (String)e.m_14418_()), item);
            registered_items.put((String)e.m_14418_(), item);
        });
        item_suppliers.clear();
        block_item_order.clear();
    }

    public static void onBlockEntityRegistry(BiConsumer<ResourceLocation, BlockEntityType<?>> registration) {
        block_entity_type_suppliers.forEach(e -> {
            BlockEntityType tet = (BlockEntityType)((Supplier)e.m_14419_()).get();
            registration.accept(new ResourceLocation(modid, (String)e.m_14418_()), tet);
            registered_block_entity_types.put((String)e.m_14418_(), tet);
        });
        block_entity_type_suppliers.clear();
    }

    public static void onMenuTypeRegistry(BiConsumer<ResourceLocation, MenuType<?>> registration) {
        menu_type_suppliers.forEach(e -> {
            MenuType ct = (MenuType)((Supplier)e.m_14419_()).get();
            registration.accept(new ResourceLocation(modid, (String)e.m_14418_()), ct);
            registered_menu_types.put((String)e.m_14418_(), ct);
        });
        menu_type_suppliers.clear();
    }

    public static void onEntityRegistry(BiConsumer<ResourceLocation, EntityType<?>> registration) {
        entity_type_suppliers.forEach(e -> {
            ResourceLocation rl = new ResourceLocation(modid, (String)e.m_14418_());
            EntityType et = (EntityType)((Supplier)e.m_14419_()).get();
            et.setRegistryName(rl);
            registration.accept(rl, et);
            registered_entity_types.put((String)e.m_14418_(), et);
        });
        entity_type_suppliers.clear();
    }
}

