/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.Tags;

public final class ColorUtils {
    private static Supplier<List<Block>> blocks_supplier_ = Collections::emptyList;
    private static Supplier<List<Item>> items_supplier_ = Collections::emptyList;

    public static void init(Supplier<List<Block>> registeredBlocksSuplier, Supplier<List<Item>> registeredItemsSuplier) {
        blocks_supplier_ = registeredBlocksSuplier;
        items_supplier_ = registeredItemsSuplier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        if (!blocks_supplier_.get().isEmpty()) {
            event.getBlockColors().m_92589_((state, world, pos, tintIndex) -> ((IBlockColorTintSupport)state.m_60734_()).m_92566_(state, world, pos, tintIndex), blocks_supplier_.get().stream().filter(b -> b instanceof IBlockColorTintSupport && ((IBlockColorTintSupport)b).hasColorTint()).collect(Collectors.toList()).toArray(new Block[0]));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        if (!items_supplier_.get().isEmpty()) {
            event.getItemColors().m_92689_((stack, tintIndex) -> ((IItemColorTintSupport)stack.m_41720_()).m_92671_(stack, tintIndex), items_supplier_.get().stream().filter(e -> e instanceof IItemColorTintSupport && ((IItemColorTintSupport)e).hasColorTint()).collect(Collectors.toList()).toArray(new ItemLike[0]));
        }
    }

    public static boolean isDye(ItemStack stack) {
        return ColorUtils.getColorFromDyeItem(stack).isPresent();
    }

    public static Optional<DyeColor> getColorFromDyeItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            return Optional.of(((DyeItem)item).m_41089_());
        }
        if (stack.m_204117_(Tags.Items.DYES_BLACK)) {
            return Optional.of(DyeColor.BLACK);
        }
        if (stack.m_204117_(Tags.Items.DYES_RED)) {
            return Optional.of(DyeColor.RED);
        }
        if (stack.m_204117_(Tags.Items.DYES_GREEN)) {
            return Optional.of(DyeColor.GREEN);
        }
        if (stack.m_204117_(Tags.Items.DYES_BROWN)) {
            return Optional.of(DyeColor.BROWN);
        }
        if (stack.m_204117_(Tags.Items.DYES_BLUE)) {
            return Optional.of(DyeColor.BLUE);
        }
        if (stack.m_204117_(Tags.Items.DYES_PURPLE)) {
            return Optional.of(DyeColor.PURPLE);
        }
        if (stack.m_204117_(Tags.Items.DYES_CYAN)) {
            return Optional.of(DyeColor.CYAN);
        }
        if (stack.m_204117_(Tags.Items.DYES_LIGHT_GRAY)) {
            return Optional.of(DyeColor.LIGHT_GRAY);
        }
        if (stack.m_204117_(Tags.Items.DYES_GRAY)) {
            return Optional.of(DyeColor.GRAY);
        }
        if (stack.m_204117_(Tags.Items.DYES_PINK)) {
            return Optional.of(DyeColor.PINK);
        }
        if (stack.m_204117_(Tags.Items.DYES_LIME)) {
            return Optional.of(DyeColor.LIME);
        }
        if (stack.m_204117_(Tags.Items.DYES_YELLOW)) {
            return Optional.of(DyeColor.YELLOW);
        }
        if (stack.m_204117_(Tags.Items.DYES_LIGHT_BLUE)) {
            return Optional.of(DyeColor.LIGHT_BLUE);
        }
        if (stack.m_204117_(Tags.Items.DYES_MAGENTA)) {
            return Optional.of(DyeColor.MAGENTA);
        }
        if (stack.m_204117_(Tags.Items.DYES_ORANGE)) {
            return Optional.of(DyeColor.ORANGE);
        }
        if (stack.m_204117_(Tags.Items.DYES_WHITE)) {
            return Optional.of(DyeColor.WHITE);
        }
        return Optional.empty();
    }

    public static interface IItemColorTintSupport
    extends ItemColor {
        default public boolean hasColorTint() {
            return false;
        }

        default public int m_92671_(ItemStack stack, int tintIndex) {
            return -1;
        }
    }

    public static interface IBlockColorTintSupport
    extends BlockColor {
        default public boolean hasColorTint() {
            return false;
        }

        default public int m_92566_(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
            return -1;
        }
    }

    public static class DyeColorFilters {
        public static final int WHITE = 0xF3F3F3;
        public static final int ORANGE = 16351261;
        public static final int MAGENTA = 13061821;
        public static final int LIGHTBLUE = 3847130;
        public static final int YELLOW = 16701501;
        public static final int LIME = 8439583;
        public static final int PINK = 15961002;
        public static final int GRAY = 4673362;
        public static final int SILVER = 0x9D9D97;
        public static final int CYAN = 1481884;
        public static final int PURPLE = 8991416;
        public static final int BLUE = 3949738;
        public static final int BROWN = 8606770;
        public static final int GREEN = 6192150;
        public static final int RED = 11546150;
        public static final int BLACK = 0x111111;
        public static final int[] byIndex_ = new int[]{0xF3F3F3, 16351261, 13061821, 3847130, 16701501, 8439583, 15961002, 4673362, 0x9D9D97, 1481884, 8991416, 3949738, 8606770, 6192150, 11546150, 0x111111};
        public static final String[] nameByIndex = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        public static final int[] lightTintByIndex_ = new int[]{0xFFFFFF, 16563336, 15250916, 10279148, 16773043, 13824423, 16437725, 9937317, 0xCECECA, 6810089, 13410277, 9804506, 13739397, 12904308, 15177618, 0x808080};

        public static int byIndex(int idx) {
            return byIndex_[idx & 0xF];
        }

        public static int lightTintByIndex(int idx) {
            return lightTintByIndex_[idx & 0xF];
        }
    }

    public static class DyeColorProperty
    extends EnumProperty<DyeColor> {
        public DyeColorProperty(String name) {
            super(name, DyeColor.class, Arrays.asList(DyeColor.values()));
        }

        public static DyeColorProperty create(String name) {
            return new DyeColorProperty(name);
        }
    }
}

