/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.RsItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class SwitchLinkPearlItem
extends RsItem {
    public SwitchLinkPearlItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return false;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        int distance;
        SwitchLink link = SwitchLink.fromItemStack(stack);
        if (Auxiliaries.Tooltip.addInformation(stack, (BlockGetter)world, tooltip, flag, !link.valid)) {
            return;
        }
        if (!link.valid) {
            return;
        }
        Block targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(link.block_name));
        if (targetBlock != null) {
            tooltip.add((Component)Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkedblock", ChatFormatting.GRAY, new Object[]{new TranslatableComponent(targetBlock.m_7705_()).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC)}));
        }
        if (Minecraft.m_91087_().f_91074_ != null && (distance = link.distance(Minecraft.m_91087_().f_91074_.m_142538_())) >= 0) {
            tooltip.add((Component)new TextComponent(Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkeddistance", ChatFormatting.GRAY, new Object[]{distance}).getString() + (String)(distance <= ModConfig.max_switch_linking_distance || ModConfig.max_switch_linking_distance <= 0 ? "" : " " + Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.toofaraway", ChatFormatting.DARK_RED, new Object[0]).getString())));
        }
        tooltip.add((Component)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(link.mode().index()), ChatFormatting.ITALIC, new Object[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.m_5776_() || !player.m_6144_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
        }
        SwitchLinkPearlItem.usePearl(world, player);
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)player.m_21120_(hand));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!selected || !entity.f_19853_.m_5776_() || world.m_5822_().nextDouble() > 0.3) {
            return;
        }
        SwitchLink lnk = SwitchLink.fromItemStack(stack);
        if (!lnk.valid || lnk.target_position.m_123331_((Vec3i)entity.m_142538_()) > 900.0) {
            return;
        }
        Vec3 p = Vec3.m_82528_((Vec3i)lnk.target_position).m_82520_((world.m_5822_().nextDouble() - 0.5) * 0.2, (world.m_5822_().nextDouble() - 0.5) * 0.2, (world.m_5822_().nextDouble() - 0.5) * 0.2);
        Vec3 v = new Vec3(0.0, (world.m_5822_().nextDouble() - 0.5) * 0.001, 0.0);
        BlockState state = world.m_8055_(lnk.target_position);
        if (state == null || !(state.m_60734_() instanceof SwitchLink.ISwitchLinkable)) {
            return;
        }
        p = p.m_82549_(state.m_60808_((BlockGetter)world, lnk.target_position).m_83215_().m_82399_());
        int power = ((SwitchLink.ISwitchLinkable)state.m_60734_()).switchLinkOutputPower(world, lnk.target_position).orElse(0);
        if (power > 0) {
            world.m_6493_((ParticleOptions)ParticleTypes.f_123751_, false, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
        } else {
            world.m_6493_((ParticleOptions)ParticleTypes.f_123771_, false, p.f_82479_, p.f_82480_, p.f_82481_, v.f_82479_, v.f_82480_, v.f_82481_);
        }
    }

    public static final void usePearl(Level world, Player player) {
        switch (SwitchLink.fromPlayerActiveItem(world, player).trigger(world, player.m_142538_(), player)) {
            case OK: {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_SUCCESS.play(world, player.m_142538_());
                return;
            }
            case TOO_FAR: {
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.switchlink_pearl.use.toofaraway", ChatFormatting.DARK_RED, new Object[0]));
                break;
            }
            case TARGET_GONE: {
                Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.switchlink_pearl.use.targetgone", ChatFormatting.DARK_RED, new Object[0]));
                break;
            }
        }
        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, player.m_142538_());
    }

    public static final ItemStack createFromPearl(Level world, BlockPos pos, Player player) {
        ItemStack stack_held = player.m_150109_().m_36056_();
        if (stack_held.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack link_pearl = SwitchLinkPearlItem.createForTarget(world, pos);
        if (link_pearl.m_41619_()) {
            return ItemStack.f_41583_;
        }
        link_pearl.m_41783_().m_128356_("cdtime", world.m_46467_());
        if (stack_held.m_41613_() > 1) {
            link_pearl.m_41764_(stack_held.m_41613_());
        }
        return link_pearl;
    }

    public static final ItemStack createForTarget(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof SwitchLink.ISwitchLinkable)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)ModContent.SWITCH_LINK_PEARL);
        SwitchLink.LinkMode mode = (SwitchLink.LinkMode)((Object)((SwitchLink.ISwitchLinkable)state.m_60734_()).switchLinkGetSupportedTargetModes().get(0));
        stack.m_41751_(SwitchLink.fromTargetPosition(world, pos).mode(mode).toNbt());
        return stack;
    }

    public static final boolean cycleLinkMode(ItemStack stack, Level world, BlockPos target_pos, boolean with_click_time) {
        SwitchLink.ISwitchLinkable target;
        int index;
        ImmutableList<SwitchLink.LinkMode> modes;
        SwitchLink lnk = SwitchLink.fromItemStack(stack);
        if (!target_pos.equals((Object)lnk.target_position)) {
            return false;
        }
        BlockState state = world.m_8055_(lnk.target_position);
        if (!(state.m_60734_() instanceof SwitchLink.ISwitchLinkable)) {
            return false;
        }
        long t = world.m_46467_();
        if (with_click_time) {
            long dt = Math.abs(t - stack.m_41783_().m_128454_("cdtime"));
            if (dt < 7L) {
                return true;
            }
            if (dt > 40L) {
                stack.m_41783_().m_128356_("cdtime", t);
                return true;
            }
        }
        SwitchLink.LinkMode next = (SwitchLink.LinkMode)((Object)modes.get((index = (modes = (target = (SwitchLink.ISwitchLinkable)state.m_60734_()).switchLinkGetSupportedTargetModes()).indexOf((Object)lnk.mode()) + 1) < 0 || index >= modes.size() ? 0 : index));
        lnk.mode(next);
        if (!lnk.valid) {
            return false;
        }
        stack.m_41751_(lnk.toNbt());
        stack.m_41783_().m_128356_("cdtime", t);
        return true;
    }
}

