/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.eapi.jei;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import wile.rsgauges.ModConfig;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Registries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(Auxiliaries.modid(), "jei_plugin_uid");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        HashSet<Item> blacklisted = new HashSet<Item>();
        for (Block block : Registries.getRegisteredBlocks()) {
            if (!ModConfig.isOptedOut(block) || !block.m_5456_().getRegistryName().m_135815_().equals(block.getRegistryName().m_135815_())) continue;
            blacklisted.add(block.m_5456_());
        }
        for (Item item : Registries.getRegisteredItems()) {
            if (!ModConfig.isOptedOut(item) || item instanceof BlockItem) continue;
            blacklisted.add(item);
        }
        if (!blacklisted.isEmpty()) {
            List blacklist = blacklisted.stream().map(ItemStack::new).collect(Collectors.toList());
            try {
                jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, blacklist);
            }
            catch (Exception exception) {
                Auxiliaries.logger().warn("Exception in JEI opt-out processing: '" + exception.getMessage() + "', skipping further JEI optout processing.");
            }
        }
    }
}

