/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import wile.rsgauges.blocks.ContactSwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public class TrapdoorSwitchBlock
extends ContactSwitchBlock {
    public TrapdoorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> {
                if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    @Override
    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float distance) {
        if ((this.config & 0x400000000000L) != 0L) {
            BlockPos[] neighbors;
            if (world.m_5776_()) {
                return;
            }
            this.onEntityCollided(world, pos, world.m_8055_(pos));
            for (BlockPos p : neighbors = new BlockPos[]{pos.m_142082_(1, 0, 0), pos.m_142082_(-1, 0, 0), pos.m_142082_(0, 0, 1), pos.m_142082_(0, 0, -1), pos.m_142082_(1, 0, 1), pos.m_142082_(-1, 0, -1), pos.m_142082_(-1, 0, 1), pos.m_142082_(1, 0, -1)}) {
                BlockState st = world.m_8055_(p);
                if (st == null || st.m_60734_() != this) continue;
                this.onEntityCollided(world, p, st);
            }
        }
        super.m_142072_(world, state, pos, entity, distance);
    }

    @Override
    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockPos[] neighbors;
        if ((this.config & 0x800000000000L) == 0L || world.m_5776_() || entity.m_6144_()) {
            return;
        }
        this.onEntityCollided(world, pos, world.m_8055_(pos));
        for (BlockPos p : neighbors = new BlockPos[]{pos.m_142082_(1, 0, 0), pos.m_142082_(-1, 0, 0), pos.m_142082_(0, 0, 1), pos.m_142082_(0, 0, -1), pos.m_142082_(1, 0, 1), pos.m_142082_(-1, 0, -1), pos.m_142082_(-1, 0, 1), pos.m_142082_(1, 0, -1)}) {
            BlockState st = world.m_8055_(p);
            if (st == null || st.m_60734_() != this) continue;
            this.onEntityCollided(world, p, st);
        }
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if ((this.config & 0x400000000000L) != 0L && (double)entity.m_20206_() < 0.9) {
            return;
        }
        this.onEntityCollided(world, pos, state);
    }

    @Override
    protected AABB detectionVolume(BlockPos pos) {
        if ((this.config & 0xC00000000000L) == 0L) {
            return new AABB(Vec3.m_82528_((Vec3i)pos).m_82520_(0.0, 0.0, 0.0), Vec3.m_82528_((Vec3i)pos).m_82520_(1.0, 1.0, 1.0));
        }
        return new AABB(Vec3.m_82528_((Vec3i)pos).m_82520_(-0.2, 0.0, -0.2), Vec3.m_82528_((Vec3i)pos).m_82520_(1.2, 2.0, 1.2));
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        Level world = link.world;
        BlockPos pos = link.target_position;
        if (world == null || (this.config & 0x200000000000000L) == 0L || world.m_5776_()) {
            return SwitchLink.RequestResult.REJECTED;
        }
        BlockState state = world.m_8055_(pos);
        if (state == null || !(state.m_60734_() instanceof TrapdoorSwitchBlock)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return SwitchLink.RequestResult.OK;
        }
        ContactSwitchBlock.ContactSwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 27);
        this.power_on_sound.play(world, pos);
        this.notifyNeighbours(world, pos, state, te, false);
        te.on_timer_reset(te.configured_on_time() == 0 ? 20 : Math.max(te.configured_on_time(), 2));
        te.reschedule_block_tick();
        return SwitchLink.RequestResult.OK;
    }
}

