/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.SwitchLinkPearlItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class SwitchBlock
extends RsDirectedBlock
implements EntityBlock,
SwitchLink.ISwitchLinkable {
    public static final long SWITCH_DATA_POWERED_POWER_MASK = 15L;
    public static final long SWITCH_DATA_RESERVED_MASK = 240L;
    public static final long SWITCH_DATA_INVERTED = 256L;
    public static final long SWITCH_DATA_WEAK = 512L;
    public static final long SWITCH_DATA_NOOUTPUT = 1024L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BOTTOM = 4096L;
    public static final long SWITCH_DATA_SIDE_ENABLED_TOP = 8192L;
    public static final long SWITCH_DATA_SIDE_ENABLED_FRONT = 16384L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BACK = 32768L;
    public static final long SWITCH_DATA_SIDE_ENABLED_LEFT = 65536L;
    public static final long SWITCH_DATA_SIDE_ENABLED_RIGHT = 131072L;
    public static final long SWITCH_DATA_SIDE_ENABLED_ALL = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_MASK = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_SHIFT = 12L;
    public static final long SWITCH_DATA_ENTITY_DEFAULTS_MASK = 262143L;
    public static final long SWITCH_CONFIG_INVERTABLE = 0x100000L;
    public static final long SWITCH_CONFIG_WEAKABLE = 0x200000L;
    public static final long SWITCH_CONFIG_PULSETIME_CONFIGURABLE = 0x400000L;
    public static final long SWITCH_CONFIG_TOUCH_CONFIGURABLE = 0x800000L;
    public static final long SWITCH_CONFIG_PULSE_EXTENDABLE = 0x1000000L;
    public static final long SWITCH_CONFIG_LCLICK_RESETTABLE = 0x2000000L;
    public static final long SWITCH_CONFIG_BISTABLE = 0x10000000L;
    public static final long SWITCH_CONFIG_PULSE = 0x20000000L;
    public static final long SWITCH_CONFIG_CONTACT = 0x40000000L;
    public static final long SWITCH_CONFIG_TIMER_DAYTIME = 0x100000000L;
    public static final long SWITCH_CONFIG_TIMER_INTERVAL = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_VOLUME = 0x400000000L;
    public static final long SWITCH_CONFIG_SENSOR_LINEAR = 0x800000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHT = 0x1000000000L;
    public static final long SWITCH_CONFIG_SENSOR_RAIN = 0x2000000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHTNING = 0x4000000000L;
    public static final long SWITCH_CONFIG_SENSOR_BLOCKDETECT = 0x8000000000L;
    public static final long SWITCH_CONFIG_SENSOR_TIME = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_DETECTOR = 0xC00000000L;
    public static final long SWITCH_CONFIG_SENSOR_ENVIRONMENTAL = 0x7100000000L;
    public static final long SWITCH_CONFIG_AUTOMATIC = 0xFF00000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_ON = 0x100000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_OFF = 0x200000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE = 0x300000000000L;
    public static final long SWITCH_CONFIG_SHOCK_SENSITIVE = 0x400000000000L;
    public static final long SWITCH_CONFIG_HIGH_SENSITIVE = 0x800000000000L;
    public static final long SWITCH_CONFIG_TRANSLUCENT = 0x3000000000000000L;
    public static final long SWITCH_CONFIG_NOT_PASSABLE = 0x10000000000000L;
    public static final long SWITCH_CONFIG_SIDES_CONFIGURABLE = 0x40000000000000L;
    public static final long SWITCH_CONFIG_LINK_SOURCE_SUPPORT = 0x100000000000000L;
    public static final long SWITCH_CONFIG_LINK_TARGET_SUPPORT = 0x200000000000000L;
    public static final long SWITCH_CONFIG_LINK_SENDER = 0x400000000000000L;
    public static final long SWITCH_CONFIG_WALLMOUNT = 0x4000000000000000L;
    public static final long SWITCH_CONFIG_LATERAL = Long.MIN_VALUE;
    public static final long SWITCH_CONFIG_LATERAL_WALLMOUNT = -4611686018427387904L;
    public static final int SWITCH_DATA_SVD_ACTIVE_TIME_MASK = 255;
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final int base_tick_rate = 2;
    public static final int default_pulse_on_time = 20;
    public final long config;
    protected final ModResources.BlockSoundEvent power_on_sound;
    protected final ModResources.BlockSoundEvent power_off_sound;

    public SwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered);
        if (powerOnSound == null && powerOffSound == null) {
            powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_ACTIVATION;
            powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_DEACTIVATION;
        } else {
            if (powerOnSound == null) {
                powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
            if (powerOffSound == null) {
                powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
        }
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        if ((config & 0xFFL) == 255L) {
            config &= 0xFFFFFFFFFFFFFF00L;
        } else if ((config & 0xFFL) == 0L) {
            config |= 0xFL;
        }
        if ((config & 0x3F000L) != 0L) {
            config |= 0x40000000000000L;
        }
        this.config = config;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    @Override
    public RsBlock.RenderTypeHint getRenderTypeHint() {
        return (this.config & 0x3000000000000000L) != 0L ? RsBlock.RenderTypeHint.TRANSLUCENT : RsBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return (this.config & 0x10000000000000L) == 0L ? Shapes.m_83040_() : this.m_5940_(state, world, pos, selectionContext);
    }

    public boolean m_7899_(BlockState state) {
        return (this.config & 0x400000000000000L) == 0L;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return !this.isWallMount() && (side == null || side == Direction.UP || side == state.m_61143_((Property)FACING));
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, false);
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, true);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te != null) {
            te.reset((LevelReader)world);
        }
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        this.notifyNeighbours(world, pos, state, te, true);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        SwitchTileEntity te;
        if (!newState.m_60713_((Block)this) && (te = this.getTe((LevelReader)world, pos)) != null) {
            te.unlinkAllSwitchLinks(true);
            te.nooutput(true);
            this.notifyNeighbours(world, pos, state, te, true);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.m_5776_() || (this.config & 0x300000000000L) == 0L || !(entity instanceof Projectile)) {
            return;
        }
        if ((Boolean)state.m_61143_((Property)POWERED) != false ? (this.config & 0x200000000000L) == 0L : (this.config & 0x100000000000L) == 0L) {
            return;
        }
        this.onSwitchActivated(world, pos, state, null, null);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return InteractionResult.FAIL;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        te.click_config(null, false);
        ClickInteraction ck = ClickInteraction.get(state, world, pos, player, hand, hit);
        if (ck.touch_configured && te.touch_config(state, player, ck.x, ck.y)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            return InteractionResult.CONSUME;
        }
        if (ck.wrenched && te.click_config(this, false)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            Overlay.show(player, (Component)te.configStatusTextComponentTranslation((SwitchBlock)state.m_60734_()));
            return InteractionResult.CONSUME;
        }
        if (!ModConfig.without_rightclick_item_switchconfig && (ck.item == Items.f_42451_ && (((SwitchBlock)state.m_60734_()).config & 0x400000L) != 0L || ck.item == Items.f_42584_ || ck.item == ModContent.SWITCH_LINK_PEARL)) {
            this.m_6256_(state, world, pos, player);
            return InteractionResult.CONSUME;
        }
        if ((this.config & 0x30000000L) == 0L) {
            return InteractionResult.CONSUME;
        }
        return this.onSwitchActivated(world, pos, state, player, hit.m_82434_()) ? InteractionResult.CONSUME : InteractionResult.FAIL;
    }

    @Override
    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.m_5776_()) {
            return;
        }
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return;
        }
        Item item_held = player.m_150109_().m_36056_().m_41720_();
        ClickInteraction ck = ClickInteraction.get(state, world, pos, player);
        if (ck.wrenched) {
            if (te.click_config(this, false)) {
                Overlay.show(player, (Component)te.configStatusTextComponentTranslation((SwitchBlock)state.m_60734_()));
                return;
            }
        } else if (ck.item == Items.f_42451_ && (((SwitchBlock)state.m_60734_()).config & 0x400000L) != 0L) {
            if (!ModConfig.without_pulsetime_config) {
                te.configured_on_time(ck.item_count * 2);
                Overlay.show(player, (Component)te.configStatusTextComponentTranslation((SwitchBlock)state.m_60734_()));
                return;
            }
        } else if (ck.item == Items.f_42584_) {
            if (!ModConfig.without_switch_linking) {
                SwitchBlock block = (SwitchBlock)state.m_60734_();
                if ((block.config & 0x200000000000000L) == 0L) {
                    Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.target_assign.error_notarget"));
                    ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                } else {
                    ItemStack link_stack = SwitchLinkPearlItem.createFromPearl(world, pos, player);
                    if (link_stack.m_41619_()) {
                        ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                    } else {
                        player.m_150109_().m_6836_(player.m_150109_().f_35977_, link_stack);
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.target_assign.ok"));
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_TARGET_SELECTED.play(world, pos);
                    }
                }
            }
        } else if (ck.item == ModContent.SWITCH_LINK_PEARL && item_held == ModContent.SWITCH_LINK_PEARL) {
            if (!ModConfig.without_switch_linking) {
                switch (te.assignSwitchLink(world, pos, player.m_150109_().m_36056_())) {
                    case OK: {
                        player.m_150109_().m_36056_().m_41774_(1);
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_SELECTED.play(world, pos);
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.ok"));
                        return;
                    }
                    case E_SELF_ASSIGN: {
                        SwitchLinkPearlItem.cycleLinkMode(player.m_150109_().m_36056_(), world, pos, true);
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(SwitchLink.fromItemStack(player.m_150109_().m_36056_()).mode().index())));
                        return;
                    }
                    case E_NOSOURCE: {
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.error_nosource"));
                        break;
                    }
                    case E_ALREADY_LINKED: {
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.error_alreadylinked"));
                        break;
                    }
                    case E_TOO_FAR: {
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.error_toofaraway"));
                        break;
                    }
                    case E_FAILED: {
                        Overlay.show(player, (Component)Auxiliaries.localizable("switchlinking.source_assign.error_failed"));
                    }
                }
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_FAILED.play(world, pos);
            }
            return;
        }
        if (item_held == Items.f_41852_ && te.click_config(this, true)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            Overlay.show(player, (Component)te.configStatusTextComponentTranslation((SwitchBlock)state.m_60734_()));
            return;
        }
        if ((this.config & 0x2000000L) != 0L) {
            te.on_timer_reset();
            if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
                return;
            }
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
            this.power_off_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L && !te.nooutput()) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return;
        }
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te != null && te.on_time_remaining() > 0) {
            te.reschedule_block_tick();
            return;
        }
        state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        world.m_7731_(pos, state, 27);
        this.power_off_sound.play((Level)world, pos);
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours((Level)world, pos, state, te, false);
        }
        if ((this.config & 0x100000000000000L) != 0L && !te.activateSwitchLinks(0, 0, true)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play((Level)world, pos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SwitchTileEntity(pos, state);
    }

    public SwitchTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof SwitchTileEntity ? (SwitchTileEntity)te : null;
    }

    @Override
    protected VoxelShape getShape(BlockState state) {
        return this.shapes_[((Direction)state.m_61143_((Property)FACING)).m_122411_()][(Boolean)state.m_61143_((Property)POWERED) != false ? 1 : 0];
    }

    protected void notifyNeighbours(Level world, BlockPos pos, BlockState state, @Nullable SwitchTileEntity te, boolean force) {
        if (!force && te != null && te.nooutput()) {
            return;
        }
        if (ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)state, EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        if ((this.config & 0x40000000000000L) != 0L) {
            if (te == null) {
                return;
            }
            long disabled_sides = te.enabled_sides();
            for (Direction facing : Direction.values()) {
                if ((disabled_sides & 1L << this.getAbsoluteFacing(state, facing).m_122411_() << 12) == 0L || ForgeEventFactory.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)state, EnumSet.of(facing), (boolean)false).isCanceled()) continue;
                world.m_46586_(pos.m_142300_(facing), (Block)this, pos);
                if (!force && te.weak()) continue;
                world.m_46590_(pos.m_142300_(facing), (Block)this, facing.m_122424_());
            }
        } else if (!this.isLateral() && this.isWallMount()) {
            Direction wall = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            world.m_46586_(pos.m_142300_(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.m_46590_(pos.m_142300_(wall), (Block)this, wall.m_122424_());
            }
        } else if (this.isLateral() && !this.isWallMount()) {
            Direction wall = (Direction)state.m_61143_((Property)FACING);
            world.m_46586_(pos.m_142300_(wall), (Block)this, pos);
            world.m_46586_(pos.m_7495_(), (Block)this, pos);
            if (force || !te.weak()) {
                world.m_46590_(pos.m_142300_(wall), (Block)this, wall.m_122424_());
                world.m_46590_(pos.m_7495_(), (Block)this, Direction.UP);
            }
        } else if (this.isLateral() && this.isWallMount()) {
            Direction wall = (Direction)state.m_61143_((Property)FACING);
            world.m_46586_(pos.m_142300_(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.m_46590_(pos.m_142300_(wall), (Block)this, wall.m_122424_());
            }
        } else {
            world.m_46672_(pos, (Block)this);
            if (force || !te.weak()) {
                world.m_46590_(pos.m_7495_(), (Block)this, Direction.UP);
                world.m_46590_(pos.m_7494_(), (Block)this, Direction.DOWN);
                world.m_46590_(pos.m_142126_(), (Block)this, Direction.WEST);
                world.m_46590_(pos.m_142125_(), (Block)this, Direction.EAST);
                world.m_46590_(pos.m_142127_(), (Block)this, Direction.SOUTH);
                world.m_46590_(pos.m_142128_(), (Block)this, Direction.NORTH);
            }
        }
    }

    protected int getPower(BlockState state, BlockGetter world, BlockPos pos, Direction side, boolean strong) {
        if ((this.config & 0x400000000000000L) != 0L || !(world instanceof Level)) {
            return 0;
        }
        if ((this.config & 0x40000000L) != 0L) {
            if (side != ((Direction)state.m_61143_((Property)FACING)).m_122424_() && (side != Direction.UP || this.isWallMount())) {
                return 0;
            }
            SwitchTileEntity te = this.getTe((LevelReader)((Level)world), pos);
            return te == null ? 0 : te.power(state, strong);
        }
        if ((this.config & 0x40000000000000L) == 0L) {
            boolean is_main_direction = side == (this.isLateral() ? ((Direction)state.m_61143_((Property)FACING)).m_122424_() : (Direction)state.m_61143_((Property)FACING));
            SwitchTileEntity te = this.getTe((LevelReader)((Level)world), pos);
            if (te == null) {
                return 0;
            }
            if (!is_main_direction && (strong || te.weak())) {
                return 0;
            }
            return te.power(state, strong);
        }
        SwitchTileEntity te = this.getTe((LevelReader)((Level)world), pos);
        if (te == null) {
            return 0;
        }
        return te.power(state, strong);
    }

    protected boolean onSwitchActivated(Level world, BlockPos pos, BlockState state, @Nullable Player player, @Nullable Direction facing) {
        if (world.m_5776_()) {
            return true;
        }
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return true;
        }
        boolean was_powered = (Boolean)state.m_61143_((Property)POWERED);
        if ((this.config & 0x8010000000L) != 0L) {
            state = (BlockState)state.m_61122_((Property)POWERED);
            world.m_7731_(pos, state, 27);
            if (was_powered) {
                this.power_off_sound.play(world, pos);
            } else {
                this.power_on_sound.play(world, pos);
            }
        } else {
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
            world.m_7731_(pos, state, 27);
            this.power_on_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
        if ((this.config & 0x20000000L) != 0L) {
            if ((this.config & 0x1000000L) == 0L) {
                te.on_timer_reset();
            }
            te.on_timer_extend();
            te.reschedule_block_tick();
        }
        if ((this.config & 0x100000000000000L) != 0L && (this.config & 0x8030000000L) != 0L) {
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            if (!was_powered) {
                if (!te.activateSwitchLinks(powered ? te.setpower() : 0, powered ? 15 : 0, was_powered != powered)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            } else if ((this.config & 0x20000000L) == 0L && !te.activateSwitchLinks(powered ? te.setpower() : 0, powered ? 15 : 0, was_powered != powered)) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean switchLinkHasTargetSupport(Level world, BlockPos pos) {
        return (this.config & 0x200000000000000L) != 0L;
    }

    @Override
    public boolean switchLinkHasSourceSupport(Level world, BlockPos pos) {
        return (this.config & 0x100000000000000L) != 0L;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(Level world, BlockPos pos) {
        return false;
    }

    @Override
    public ImmutableList<SwitchLink.LinkMode> switchLinkGetSupportedTargetModes() {
        if ((this.config & 0x20000000L) != 0L) {
            return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.ACTIVATE), (Object)((Object)SwitchLink.LinkMode.DEACTIVATE), (Object)((Object)SwitchLink.LinkMode.TOGGLE));
        }
        return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.AS_STATE), (Object)((Object)SwitchLink.LinkMode.ACTIVATE), (Object)((Object)SwitchLink.LinkMode.DEACTIVATE), (Object)((Object)SwitchLink.LinkMode.TOGGLE), (Object)((Object)SwitchLink.LinkMode.INV_STATE));
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(Level world, BlockPos pos) {
        SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        return te == null ? Optional.empty() : Optional.of(te.power(world.m_8055_(pos), false));
    }

    @Override
    public Optional<Integer> switchLinkInputPower(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof SwitchBlock)) {
            return Optional.empty();
        }
        if (((SwitchBlock)state.m_60734_()).isCube()) {
            return Optional.of(world.m_46755_(pos));
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return Optional.of(world.m_46681_(pos.m_142300_(facing), facing.m_122424_()));
    }

    @Override
    public Optional<Integer> switchLinkComparatorInput(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof SwitchBlock)) {
            return Optional.empty();
        }
        BlockPos adjacent_pos = pos.m_142300_((Direction)state.m_61143_((Property)FACING));
        BlockState adjacent = world.m_8055_(adjacent_pos);
        if (!adjacent.m_60807_()) {
            return Optional.empty();
        }
        return Optional.of(adjacent.m_60674_(world, adjacent_pos));
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        if ((this.config & 0x30000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        SwitchTileEntity te = this.getTe((LevelReader)link.world, link.target_position);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        return this.onSwitchActivated(link.world, link.target_position, link.world.m_8055_(link.target_position), link.player, null) ? SwitchLink.RequestResult.OK : SwitchLink.RequestResult.REJECTED;
    }

    @Override
    public void switchLinkInit(SwitchLink link) {
        BlockState state;
        if (link.mode() != SwitchLink.LinkMode.AS_STATE && link.mode() != SwitchLink.LinkMode.INV_STATE) {
            return;
        }
        if (link.source_digital_power == 0 == (Boolean)(state = link.world.m_8055_(link.target_position)).m_61143_((Property)POWERED)) {
            this.onSwitchActivated(link.world, link.target_position, state, link.player, null);
        }
    }

    @Override
    public void switchLinkUnlink(SwitchLink link) {
    }

    public static class SwitchTileEntity
    extends RsBlock.RsTileEntity {
        protected static final int max_pulse_time = 200;
        protected long pulse_off_deadline_ = 0L;
        protected int scd_ = 0;
        protected int svd_ = 0;
        protected long click_config_time_lastclicked_ = 0L;
        protected long click_config_last_cycled_ = 0L;
        protected long touch_config_time_lastclicked_ = 0L;
        protected long last_link_request_ = 0L;
        protected ArrayList<SwitchLink> links_ = null;

        public SwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public SwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_SWITCH, pos, state);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            nbt.m_128405_("scd", this.scd_);
            nbt.m_128405_("svd", this.svd_);
            if (updatePacket) {
                return;
            }
            if (this.links_ == null || this.links_.isEmpty()) {
                if (nbt.m_128441_("links")) {
                    nbt.m_128473_("links");
                }
            } else {
                ListTag tl = new ListTag();
                for (SwitchLink e : this.links_) {
                    tl.add((Object)e.toNbt());
                }
                nbt.m_128365_("links", (Tag)tl);
            }
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            int previous_scd = this.scd_;
            int previous_svd = this.svd_;
            this.scd_ = nbt.m_128451_("scd");
            this.svd_ = nbt.m_128451_("svd");
            if (!updatePacket) {
                if (this.scd_ == 0) {
                    this.reset(null);
                }
                if (!nbt.m_128441_("links")) {
                    if (this.links_ != null) {
                        this.links_.clear();
                    }
                } else {
                    ListTag tl = nbt.m_128437_("links", (int)nbt.m_7060_());
                    ArrayList<SwitchLink> links = new ArrayList<SwitchLink>();
                    for (Tag e : tl) {
                        SwitchLink lnk = SwitchLink.fromNbt((CompoundTag)e);
                        links.add(lnk);
                    }
                    this.links_ = links;
                }
            }
        }

        public int configured_on_time() {
            return (this.svd_ & 0xFF) >> 0;
        }

        public void configured_on_time(int t) {
            this.svd_ = this.svd_ & 0xFFFFFF00 | (t & 0xFF) << 0;
        }

        public int setpower() {
            return (this.scd_ & 0xF) >> 0;
        }

        public boolean inverted() {
            return (this.scd_ & 0x100) != 0;
        }

        public boolean weak() {
            return (this.scd_ & 0x200) != 0;
        }

        public boolean nooutput() {
            return (this.scd_ & 0x400) != 0;
        }

        public long enabled_sides() {
            return (long)this.scd_ & 0x3F000L;
        }

        public void setpower(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFF0 | (p < 0 ? 0 : Math.min(p, 15) & 0xF) << 0;
        }

        public void inverted(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x100) : (this.scd_ &= 0xFFFFFEFF);
        }

        public void weak(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x200) : (this.scd_ &= 0xFFFFFDFF);
        }

        public void nooutput(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x400) : (this.scd_ &= 0xFFFFFBFF);
        }

        public void enabled_sides(long mask) {
            this.scd_ = this.scd_ & 0xFFFC0FFF | (int)(mask & 0x3F000L);
        }

        public void reset(@Nullable LevelReader world) {
            this.pulse_off_deadline_ = 0L;
            this.click_config_time_lastclicked_ = 0L;
            this.svd_ = 0;
            if (world instanceof Level) {
                try {
                    this.scd_ = (int)(((SwitchBlock)world.m_8055_((BlockPos)this.m_58899_()).m_60734_()).config & 0x3FFFFL);
                }
                catch (Exception e) {
                    this.scd_ = 15;
                }
            } else {
                this.scd_ = 15;
            }
        }

        public int power(BlockState state, boolean strong) {
            return this.nooutput() ? 0 : (strong && this.weak() ? 0 : (this.inverted() == ((Boolean)state.m_61143_((Property)POWERED)).booleanValue() ? 0 : this.setpower()));
        }

        public void reschedule_block_tick() {
            int t = this.on_time_remaining();
            if (t <= 0) {
                return;
            }
            Block block = this.m_58900_().m_60734_();
            if (!this.f_58857_.m_183326_().m_183582_(this.f_58858_, (Object)block)) {
                this.f_58857_.m_186460_(this.f_58858_, block, t);
            }
        }

        public int on_time_remaining() {
            long dt = Math.max(0L, this.pulse_off_deadline_ - this.f_58857_.m_46467_());
            return dt > 200L ? 0 : (int)dt;
        }

        public void on_timer_reset() {
            this.on_timer_reset(0);
        }

        public void on_timer_reset(int preset_ticks) {
            this.pulse_off_deadline_ = this.f_58857_.m_46467_() + (long)(Math.min(preset_ticks, 200) > 0 ? preset_ticks : 0);
        }

        public void on_timer_extend() {
            int t = this.on_time_remaining();
            t = this.configured_on_time() >= 2 ? this.configured_on_time() : (t > 90 ? 200 : (t > 45 ? 100 : (t > 15 ? 50 : (t > 1 ? 30 : 20))));
            this.on_timer_reset(t);
        }

        public boolean touch_config(BlockState state, @Nullable Player player, double x, double y) {
            long t = this.f_58857_.m_46467_();
            boolean show_only = Math.abs(t - this.touch_config_time_lastclicked_) > 40L;
            this.touch_config_time_lastclicked_ = t;
            return this.activation_config(state, player, x, y, show_only);
        }

        protected boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            return false;
        }

        public boolean click_config(@Nullable SwitchBlock block, boolean needsDoubleClick) {
            if (block == null) {
                this.click_config_time_lastclicked_ = 0L;
                return false;
            }
            long t = System.currentTimeMillis();
            if (needsDoubleClick) {
                boolean dblclicked = t - this.click_config_time_lastclicked_ > 0L && t - this.click_config_time_lastclicked_ < (long)ModConfig.config_left_click_timeout;
                long l = this.click_config_time_lastclicked_ = dblclicked ? 0L : t;
                if (!dblclicked) {
                    return false;
                }
            }
            boolean multiclicked = t - this.click_config_last_cycled_ > 0L && t - this.click_config_last_cycled_ < 3000L;
            this.click_config_last_cycled_ = t;
            if (!multiclicked) {
                return true;
            }
            if ((block.config & 0x300000L) == 0x300000L) {
                switch ((this.weak() ? 1 : 0) | (this.inverted() ? 2 : 0) | (this.nooutput() ? 4 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 2: {
                        this.weak(true);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 3: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x200000L) != 0L) {
                switch ((this.weak() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x100000L) != 0L) {
                switch ((this.inverted() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                    }
                }
            }
            if ((block.config & 0x200200L) == 512L && !this.weak()) {
                this.weak(true);
            }
            if (ModConfig.without_switch_nooutput || (block.config & 0x400000000000000L) != 0L) {
                this.nooutput(false);
            }
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, (Block)block);
            for (Direction f : Direction.values()) {
                this.f_58857_.m_46672_(this.f_58858_.m_142300_(f), (Block)block);
            }
            return true;
        }

        public TranslatableComponent configStatusTextComponentTranslation(SwitchBlock block) {
            TextComponent separator = new TextComponent(" | ");
            separator.m_130940_(ChatFormatting.GRAY);
            TranslatableComponent status = Auxiliaries.localizable("switchconfig.options", ChatFormatting.RESET, new Object[0]);
            boolean statusset = false;
            if (this.setpower() < 15 && (block == null || (block.config & 0x40000FF00000000L) == 0L)) {
                statusset = true;
                status.m_7220_((Component)Auxiliaries.localizable("switchconfig.options.output_power", ChatFormatting.RED, new Object[]{this.setpower()}));
            }
            if (this.nooutput()) {
                if (statusset) {
                    status.m_7220_((Component)separator.m_6881_());
                }
                statusset = true;
                status.m_7220_((Component)Auxiliaries.localizable("switchconfig.options.no_output", ChatFormatting.DARK_AQUA, new Object[0]));
            } else if (!this.inverted()) {
                if (statusset) {
                    status.m_7220_((Component)separator.m_6881_());
                }
                statusset = true;
                status.m_7220_((Component)Auxiliaries.localizable("switchconfig.options." + (this.weak() ? "weak" : "strong"), ChatFormatting.DARK_AQUA, new Object[0]));
            } else {
                if (statusset) {
                    status.m_7220_((Component)separator.m_6881_());
                }
                statusset = true;
                status.m_7220_((Component)Auxiliaries.localizable("switchconfig.options." + (this.weak() ? "weakinverted" : "stronginverted"), ChatFormatting.DARK_AQUA, new Object[0]));
            }
            if (this.configured_on_time() > 0) {
                if (statusset) {
                    status.m_7220_((Component)separator.m_6881_());
                }
                status.m_7220_((Component)Auxiliaries.localizable("switchconfig.options.pulsetime", ChatFormatting.GOLD, new Object[]{Double.toString((double)this.configured_on_time() / 20.0), Integer.toString(this.configured_on_time())}));
            }
            return status;
        }

        public static long linktime() {
            return System.currentTimeMillis();
        }

        public boolean verifySwitchLinkTarget(SwitchLink link) {
            long t = SwitchTileEntity.linktime();
            if (this.f_58857_.m_5776_() || this.last_link_request_ == t) {
                return false;
            }
            this.last_link_request_ = t;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (state == null || !(state.m_60734_() instanceof SwitchBlock)) {
                return false;
            }
            return (((SwitchBlock)state.m_60734_()).config & 0x200000000000000L) != 0L;
        }

        SwitchLinkAssignmentResult assignSwitchLink(Level world, BlockPos sourcepos, ItemStack stack) {
            SwitchLink link = SwitchLink.fromItemStack(stack);
            if (!link.valid || !sourcepos.equals((Object)this.m_58899_())) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            BlockState state = world.m_8055_(sourcepos);
            if (!(state.m_60734_() instanceof SwitchBlock)) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            if (link.target_position.equals((Object)sourcepos)) {
                return SwitchLinkAssignmentResult.E_SELF_ASSIGN;
            }
            if ((((SwitchBlock)state.m_60734_()).config & 0x100000000000000L) == 0L) {
                return SwitchLinkAssignmentResult.E_NOSOURCE;
            }
            if (link.isTooFar(sourcepos)) {
                return SwitchLinkAssignmentResult.E_TOO_FAR;
            }
            if (this.links_ == null) {
                this.links_ = new ArrayList();
            }
            for (SwitchLink lnk : this.links_) {
                if (!lnk.target_position.equals((Object)link.target_position)) continue;
                return SwitchLinkAssignmentResult.E_ALREADY_LINKED;
            }
            this.links_.add(link);
            boolean powered = (Boolean)state.m_61143_((Property)POWERED);
            link.initializeTarget(this.m_58904_(), this.m_58899_(), powered ? this.setpower() : 0, powered ? 15 : 0);
            this.m_6596_();
            return SwitchLinkAssignmentResult.OK;
        }

        public ArrayList<ItemStack> unlinkAllSwitchLinks(boolean drop) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (this.f_58857_.m_5776_() || this.links_ == null) {
                return stacks;
            }
            for (SwitchLink switchLink : this.links_) {
                stacks.add(switchLink.toSwitchLinkPearl());
                switchLink.unlinkTarget(this.m_58904_(), this.m_58899_());
            }
            this.links_.clear();
            if (drop) {
                for (ItemStack itemStack : stacks) {
                    this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), itemStack));
                }
            }
            return stacks;
        }

        public boolean activateSwitchLinks(int analog_power, int digital_power, boolean state_changed) {
            if (ModConfig.without_switch_linking) {
                return true;
            }
            this.last_link_request_ = SwitchTileEntity.linktime();
            if (this.links_ == null) {
                return true;
            }
            int n_fails = 0;
            block3: for (SwitchLink lnk : this.links_) {
                switch (lnk.trigger(this.f_58857_, this.f_58858_, analog_power, digital_power, state_changed)) {
                    case OK: 
                    case NOT_MATCHED: {
                        continue block3;
                    }
                }
                ++n_fails;
            }
            return n_fails == 0;
        }

        static enum SwitchLinkAssignmentResult {
            OK,
            E_SELF_ASSIGN,
            E_ALREADY_LINKED,
            E_TOO_FAR,
            E_NOSOURCE,
            E_FAILED;

        }
    }

    protected static final class ClickInteraction {
        public boolean touch_configured = false;
        public boolean wrenched = false;
        public Item item = Items.f_41852_;
        public int item_count = 0;
        public int dye = -1;
        public double x = 0.0;
        public double y = 0.0;

        protected ClickInteraction() {
        }

        public String toString() {
            return "{x:" + Double.toString(this.x) + ",y:" + Double.toString(this.y) + ",touch_configured:" + Boolean.toString(this.touch_configured) + ",wrenched:" + Boolean.toString(this.wrenched) + ",item_count:" + Integer.toString(this.item_count) + "}";
        }

        private static ClickInteraction touch(ClickInteraction ck, BlockState state, Direction facing, float x, float y, float z) {
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            double xo = 0.0;
            double yo = 0.0;
            if (block.isCube() || block.isWallMount() && !block.isLateral()) {
                if (!block.isCube() ? facing != state.m_61143_((Property)RsDirectedBlock.FACING) : facing != ((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122424_()) {
                    return ck;
                }
                switch (facing.m_122411_()) {
                    case 0: {
                        xo = 1.0f - x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 1: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = 1.0f - x;
                        yo = y;
                        break;
                    }
                    case 3: {
                        xo = x;
                        yo = y;
                        break;
                    }
                    case 4: {
                        xo = z;
                        yo = y;
                        break;
                    }
                    case 5: {
                        xo = 1.0f - z;
                        yo = y;
                    }
                }
                AABB aa = block.getShape((BlockState)block.m_49966_().m_61124_((Property)RsDirectedBlock.FACING, (Comparable)Direction.SOUTH)).m_83215_();
                xo = Math.round((xo - aa.f_82288_) * (1.0 / (aa.f_82291_ - aa.f_82288_)) * 15.5 - 0.25);
                yo = Math.round((yo - aa.f_82289_) * (1.0 / (aa.f_82292_ - aa.f_82289_)) * 15.5 - 0.25);
            } else if (block.isLateral()) {
                if (facing != Direction.UP) {
                    return ck;
                }
                facing = (Direction)state.m_61143_((Property)RsDirectedBlock.FACING);
                switch (facing.m_122411_()) {
                    case 0: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 1: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 3: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 4: {
                        xo = 1.0f - z;
                        yo = 1.0f - x;
                        break;
                    }
                    case 5: {
                        xo = z;
                        yo = x;
                    }
                }
                AABB aa = block.getShape((BlockState)block.m_49966_().m_61124_((Property)RsDirectedBlock.FACING, (Comparable)Direction.NORTH)).m_83215_();
                xo = 0.1 * (double)Math.round(10.0 * ((xo - aa.f_82288_) * (1.0 / (aa.f_82291_ - aa.f_82288_)) * 15.5 - 0.25));
                yo = 0.1 * (double)Math.round(10.0 * ((yo - (1.0 - aa.f_82293_)) * (1.0 / (aa.f_82293_ - aa.f_82290_)) * 15.5 - 0.25));
            } else {
                return ck;
            }
            ck.x = xo > 15.0 ? 15.0 : Math.max(xo, 0.0);
            ck.y = yo > 15.0 ? 15.0 : Math.max(yo, 0.0);
            ck.touch_configured = true;
            return ck;
        }

        public static ClickInteraction get(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            float x = (float)(hit.m_82450_().m_7096_() - Math.floor(hit.m_82450_().m_7096_()));
            float y = (float)(hit.m_82450_().m_7098_() - Math.floor(hit.m_82450_().m_7098_()));
            float z = (float)(hit.m_82450_().m_7094_() - Math.floor(hit.m_82450_().m_7094_()));
            return ClickInteraction.get(world, pos, state, player, hand, hit.m_82434_(), x, y, z);
        }

        public static ClickInteraction get(BlockState state, Level world, BlockPos pos, Player player) {
            return ClickInteraction.get(world, pos, state, player, null, null, 0.0f, 0.0f, 0.0f);
        }

        public static ClickInteraction get(Level world, BlockPos pos, @Nullable BlockState state, Player player, @Nullable InteractionHand hand, @Nullable Direction facing, float x, float y, float z) {
            ClickInteraction ck = new ClickInteraction();
            if (world == null || pos == null) {
                return ck;
            }
            if (state == null) {
                state = world.m_8055_(pos);
            }
            if (state == null || !(state.m_60734_() instanceof SwitchBlock)) {
                return ck;
            }
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            ItemStack item = player.m_21205_();
            if (item == null) {
                return ck;
            }
            if (item.m_41720_() == Items.f_42451_) {
                ck.item = Items.f_42451_;
                ck.item_count = item.m_41613_();
            } else if (item.m_41720_() == Items.f_42584_) {
                ck.item = Items.f_42584_;
                ck.item_count = item.m_41613_();
            } else if (item.m_41720_() == ModContent.SWITCH_LINK_PEARL) {
                ck.item = ModContent.SWITCH_LINK_PEARL;
                ck.item_count = item.m_41613_();
            } else if (item.m_41720_() != Items.f_41852_) {
                ck.wrenched = ModConfig.isWrench(item);
                if (ck.wrenched) {
                    return ck;
                }
            }
            if (facing != null && (block.config & 0x800000L) != 0L && ck.item != ModContent.SWITCH_LINK_PEARL && ck.item != Items.f_42584_) {
                return ClickInteraction.touch(ck, state, facing, x, y, z);
            }
            return ck;
        }
    }
}

