/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.EnvironmentalSensorSwitchBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.RsAuxiliaries;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class DayTimerSwitchBlock
extends AutoSwitchBlock {
    public DayTimerSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public DayTimerSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DayTimerSwitchTileEntity(pos, state);
    }

    public static class DayTimerSwitchTileEntity
    extends EnvironmentalSensorSwitchBlock.EnvironmentalSensorSwitchTileEntity {
        public DayTimerSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public DayTimerSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_DAYTIMER_SWITCH, pos, state);
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if (!show_only) {
                double time_scaling = 0.3125;
                switch (field) {
                    case 1: {
                        double v = this.threshold0_on() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_on(v);
                        break;
                    }
                    case 2: {
                        double v = this.threshold0_off() + 0.3125 * (double)direction;
                        if (v < 0.0) {
                            v += 15.0;
                        } else if (v > 15.0) {
                            v = 0.0;
                        }
                        this.threshold0_off(v);
                        break;
                    }
                    case 3: {
                        this.debounce(this.debounce() + direction);
                        break;
                    }
                    case 4: {
                        this.setpower(this.setpower() + direction);
                    }
                }
                if (this.setpower() < 1) {
                    this.setpower(1);
                }
                this.m_6596_();
            }
            TextComponent separator = new TextComponent(" | ");
            separator.m_130940_(ChatFormatting.GRAY);
            ArrayList<Object> tr = new ArrayList<Object>();
            tr.add(Auxiliaries.localizable("switchconfig.daytimerclock.daytime_on", ChatFormatting.BLUE, new Object[]{RsAuxiliaries.daytimeToString((long)(this.threshold0_on() * 24000.0 / 15.0))}));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.daytimerclock.daytime_off", ChatFormatting.YELLOW, new Object[]{RsAuxiliaries.daytimeToString((long)(this.threshold0_off() * 24000.0 / 15.0))})));
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.daytimerclock.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            if (this.debounce() > 0) {
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.daytimerclock.random", ChatFormatting.DARK_GREEN, new Object[]{this.debounce()})));
            } else {
                tr.add(new TextComponent(""));
            }
            tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.daytimerclock.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
            Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.daytimerclock", ChatFormatting.RESET, tr.toArray()));
            return true;
        }

        @Override
        public void tick() {
            boolean active_setpoint;
            if (!this.m_58898_() || this.m_58904_().f_46443_ || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            BlockState state = this.m_58900_();
            if (!(state.m_60734_() instanceof DayTimerSwitchBlock)) {
                return;
            }
            boolean active = (Boolean)state.m_61143_((Property)SwitchBlock.POWERED);
            long wt = this.f_58857_.m_46468_() % 24000L;
            double t = 6.25E-4 * (double)wt;
            if (this.threshold0_on() == this.threshold0_off()) {
                active_setpoint = false;
            } else if (this.threshold0_on() < this.threshold0_off()) {
                active_setpoint = t >= this.threshold0_on() && t <= this.threshold0_off();
            } else {
                boolean bl = active_setpoint = t >= this.threshold0_on() && t <= 15.0 || t >= 0.0 && t <= this.threshold0_off();
            }
            if (active != active_setpoint) {
                if (this.debounce() <= 0) {
                    active = active_setpoint;
                } else {
                    double d1 = (1.0 - (double)this.debounce() / 9.0) * 0.7;
                    d1 *= d1;
                    if (Math.random() <= d1) {
                        active = active_setpoint;
                    }
                }
            }
            this.updateSwitchState(state, (DayTimerSwitchBlock)state.m_60734_(), active, 0);
        }
    }
}

