/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.blocks.IntervalTimerSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public abstract class AutoSwitchBlock
extends SwitchBlock {
    public AutoSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public AutoSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        this(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        if ((this.config & 0x200000000000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        if ((this.config & 0x200000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        BlockState state = link.world.m_8055_(link.target_position);
        if (state == null || !(state.m_60734_() instanceof AutoSwitchBlock)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        AutoSwitchTileEntity te = this.getTe((LevelReader)link.world, link.target_position);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        te.updateSwitchState(state, this, (Boolean)state.m_61143_((Property)POWERED) == false, 0);
        return SwitchLink.RequestResult.OK;
    }

    @Override
    public AutoSwitchTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof AutoSwitchTileEntity)) {
            return null;
        }
        return (AutoSwitchTileEntity)te;
    }

    public static abstract class AutoSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        public AutoSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        protected final void updateSwitchState(BlockState state, AutoSwitchBlock block, boolean active, int hold_time) {
            this.updateSwitchState(state, block, active, hold_time, true);
        }

        protected final void updateSwitchState(BlockState state, AutoSwitchBlock block, boolean active, int hold_time, boolean link_update) {
            if (active) {
                this.on_timer_reset(hold_time);
                if (!((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue()) {
                    if (this instanceof IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity) {
                        ((IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity)this).restart();
                    }
                    this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)SwitchBlock.POWERED, (Comparable)Boolean.valueOf(true)), 26);
                    block.power_on_sound.play(this.f_58857_, this.f_58858_);
                    this.f_58857_.m_46672_(this.f_58858_, (Block)block);
                    BlockPos np = this.f_58858_.m_142300_(((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122424_());
                    Block nb = this.f_58857_.m_8055_(np).m_60734_();
                    this.f_58857_.m_46672_(np, nb);
                    if (link_update && (block.config & 0x100000000000000L) != 0L && !this.activateSwitchLinks(this.setpower(), 15, true)) {
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.f_58857_, this.f_58858_);
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue() && (hold_time <= 0 || this.on_time_remaining() <= 0)) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)SwitchBlock.POWERED, (Comparable)Boolean.valueOf(false)), 26);
                block.power_off_sound.play(this.f_58857_, this.f_58858_);
                this.f_58857_.m_46672_(this.f_58858_, (Block)block);
                BlockPos np = this.f_58858_.m_142300_(((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122424_());
                Block nb = this.f_58857_.m_8055_(np).m_60734_();
                this.f_58857_.m_46672_(np, nb);
                if (link_update && (block.config & 0x100000000000000L) != 0L && !this.activateSwitchLinks(0, 0, true)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.f_58857_, this.f_58858_);
                }
            }
        }
    }
}

