/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.shared.peripheral.speaker.UpgradeSpeakerPeripheral;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurtleSpeaker
extends AbstractTurtleUpgrade {
    private static final ModelResourceLocation leftModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_left", "inventory");
    private static final ModelResourceLocation rightModel = new ModelResourceLocation("computercraft:turtle_speaker_upgrade_right", "inventory");

    public TurtleSpeaker(ResourceLocation id, ItemStack item) {
        super(id, TurtleUpgradeType.PERIPHERAL, "upgrade.computercraft.speaker.adjective", item);
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return TransformedModel.of(side == TurtleSide.LEFT ? leftModel : rightModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide turtleSide) {
        IPeripheral peripheral = turtle.getPeripheral(turtleSide);
        if (peripheral instanceof Peripheral) {
            Peripheral speaker = (Peripheral)peripheral;
            speaker.update();
        }
    }

    private static class Peripheral
    extends UpgradeSpeakerPeripheral {
        final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public Level getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)this.turtle.getPosition());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral speaker = (Peripheral)other;
            if (this.turtle != speaker.turtle) return false;
            return true;
        }
    }
}

