/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;

public class TileCable
extends TileGeneric {
    private static final String NBT_PERIPHERAL_ENABLED = "PeirpheralAccess";
    private boolean invalidPeripheral;
    private boolean peripheralAccessAllowed;
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral(this::queueRefreshPeripheral);
    private boolean destroyed = false;
    private boolean connectionsFormed = false;
    private final WiredModemElement cable = new CableElement();
    private LazyOptional<IWiredElement> elementCap;
    private final IWiredNode node = this.cable.getNode();
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this)), this.cable){

        @Override
        @Nonnull
        protected WiredModemLocalPeripheral getLocalPeripheral() {
            return TileCable.this.peripheral;
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)TileCable.this.m_58899_().m_142300_(TileCable.this.getDirection()));
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return TileCable.this;
        }
    };
    private LazyOptional<IPeripheral> modemCap;
    private final NonNullConsumer<LazyOptional<IWiredElement>> connectedNodeChanged = x -> this.connectionsChanged();

    public TileCable(BlockEntityType<? extends TileCable> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private void onRemove() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    @Override
    public void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.modem.destroy();
            this.onRemove();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onRemove();
    }

    public void m_7651_() {
        super.m_7651_();
        this.onRemove();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        this.modemCap = CapabilityUtil.invalidate(this.modemCap);
    }

    public void m_6339_() {
        super.m_6339_();
        TickScheduler.schedule(this);
    }

    @Deprecated
    public void m_155250_(@Nonnull BlockState state) {
        Direction direction = this.getMaybeDirection();
        super.m_155250_(state);
        if (this.getMaybeDirection() != direction) {
            this.modemCap = CapabilityUtil.invalidate(this.modemCap);
            this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        }
    }

    @Nullable
    private Direction getMaybeDirection() {
        return ((CableModemVariant)((Object)this.m_58900_().m_61143_(BlockCable.MODEM))).getFacing();
    }

    @Nonnull
    private Direction getDirection() {
        Direction direction = this.getMaybeDirection();
        return direction == null ? Direction.NORTH : direction;
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        Direction dir = this.getDirection();
        if (neighbour.equals((Object)this.m_58899_().m_142300_(dir)) && this.hasModem() && !this.m_58900_().m_60710_((LevelReader)this.m_58904_(), this.m_58899_())) {
            if (this.hasCable()) {
                Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)Registry.ModItems.WIRED_MODEM.get()));
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.None)));
                this.modemChanged();
                this.connectionsChanged();
            } else {
                Block.m_49840_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (ItemStack)new ItemStack((ItemLike)Registry.ModItems.WIRED_MODEM.get()));
                this.m_58904_().m_7471_(this.m_58899_(), false);
            }
            return;
        }
        this.onNeighbourTileEntityChange(neighbour);
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        super.onNeighbourTileEntityChange(neighbour);
        if (!this.f_58857_.f_46443_ && this.peripheralAccessAllowed) {
            Direction facing = this.getDirection();
            if (this.m_58899_().m_142300_(facing).equals((Object)neighbour)) {
                this.queueRefreshPeripheral();
            }
        }
    }

    private void queueRefreshPeripheral() {
        if (this.invalidPeripheral) {
            return;
        }
        this.invalidPeripheral = true;
        TickScheduler.schedule(this);
    }

    private void refreshPeripheral() {
        this.invalidPeripheral = false;
        if (this.f_58857_ != null && !this.m_58901_() && this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getDirection())) {
            this.updateConnectedPeripherals();
        }
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!this.canAttachPeripheral()) {
            return InteractionResult.FAIL;
        }
        if (this.m_58904_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equal((Object)newName, (Object)oldName)) {
            if (oldName != null) {
                player.m_5661_((Component)new TranslatableComponent("chat.computercraft.wired_modem.peripheral_disconnected", new Object[]{ChatHelpers.copy(oldName)}), false);
            }
            if (newName != null) {
                player.m_5661_((Component)new TranslatableComponent("chat.computercraft.wired_modem.peripheral_connected", new Object[]{ChatHelpers.copy(newName)}), false);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.peripheralAccessAllowed = nbt.m_128471_(NBT_PERIPHERAL_ENABLED);
        this.peripheral.read(nbt, "");
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        super.m_183515_(nbt);
    }

    private void updateBlockState() {
        CableModemVariant newVariant;
        BlockState state = this.m_58900_();
        CableModemVariant oldVariant = (CableModemVariant)((Object)state.m_61143_(BlockCable.MODEM));
        if (oldVariant != (newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheralAccessAllowed))) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_(BlockCable.MODEM, (Comparable)((Object)newVariant)));
        }
    }

    @Override
    public void blockTick() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.invalidPeripheral) {
            this.refreshPeripheral();
        }
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.f_58857_, this.f_58858_, this.getDirection());
                this.updateConnectedPeripherals();
            }
        }
    }

    void connectionsChanged() {
        if (this.m_58904_().f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        Level world = this.m_58904_();
        BlockPos current = this.m_58899_();
        for (Direction facing : DirectionUtil.FACINGS) {
            LazyOptional<IWiredElement> element;
            BlockPos offset = current.m_142300_(facing);
            if (!world.m_46749_(offset) || !(element = ComputerCraftAPI.getWiredElementAt((BlockGetter)world, offset, facing.m_122424_())).isPresent()) continue;
            element.addListener(this.connectedNodeChanged);
            IWiredNode node = ((IWiredElement)element.orElseThrow(NullPointerException::new)).getNode();
            if (BlockCable.canConnectIn(state, facing)) {
                this.node.connectTo(node);
                continue;
            }
            if (this.node.getNetwork() != node.getNetwork()) continue;
            this.node.disconnectFrom(node);
        }
    }

    void modemChanged() {
        this.elementCap = CapabilityUtil.invalidate(this.elementCap);
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Collections.emptyMap());
            this.m_6596_();
            this.updateBlockState();
        }
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.f_58857_, this.m_58899_(), this.getDirection());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == Capabilities.CAPABILITY_WIRED_ELEMENT) {
            if (this.destroyed || !BlockCable.canConnectIn(this.m_58900_(), side)) {
                return LazyOptional.empty();
            }
            if (this.elementCap == null) {
                this.elementCap = LazyOptional.of(() -> this.cable);
            }
            return this.elementCap.cast();
        }
        if (capability == Capabilities.CAPABILITY_PERIPHERAL) {
            if (side != null && this.getMaybeDirection() != side) {
                return LazyOptional.empty();
            }
            if (this.modemCap == null) {
                this.modemCap = LazyOptional.of(() -> this.modem);
            }
            return this.modemCap.cast();
        }
        return super.getCapability(capability, side);
    }

    boolean hasCable() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockCable.CABLE);
    }

    public boolean hasModem() {
        return this.m_58900_().m_61143_(BlockCable.MODEM) != CableModemVariant.None;
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        @Nonnull
        public Level getLevel() {
            return TileCable.this.m_58904_();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            return Vec3.m_82512_((Vec3i)TileCable.this.m_58899_());
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            TileCable.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            TileCable.this.modem.detachPeripheral(name);
        }
    }
}

