/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.peripheral.modem.wired.BlockCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ItemBlockCable
extends BlockItem {
    private String translationKey;

    public ItemBlockCable(BlockCable block, Item.Properties settings) {
        super((Block)block, settings);
    }

    boolean placeAt(Level world, BlockPos pos, BlockState state, Player player) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return false;
        }
        world.m_7731_(pos, state, 3);
        SoundType soundType = state.m_60734_().getSoundType(state, (LevelReader)world, pos, (Entity)player);
        world.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileCable) {
            TileCable cable = (TileCable)tile;
            cable.modemChanged();
            cable.connectionsChanged();
        }
        return true;
    }

    boolean placeAtCorrected(Level world, BlockPos pos, BlockState state) {
        return this.placeAt(world, pos, BlockCable.correctConnections(world, pos, state), null);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            list.add((Object)new ItemStack((ItemLike)this));
        }
    }

    @Nonnull
    public String m_5524_() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"block", (ResourceLocation)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public static class Cable
    extends ItemBlockCable {
        public Cable(BlockCable block, Item.Properties settings) {
            super(block, settings);
        }

        @Nonnull
        public InteractionResult m_40576_(BlockPlaceContext context) {
            BlockPos pos;
            BlockPos insidePos;
            ItemStack stack = context.m_43722_();
            if (stack.m_41619_()) {
                return InteractionResult.FAIL;
            }
            Level world = context.m_43725_();
            BlockState insideState = world.m_8055_(insidePos = (pos = context.m_8083_()).m_142300_(context.m_43719_().m_122424_()));
            if (insideState.m_60734_() == Registry.ModBlocks.CABLE.get() && !((Boolean)insideState.m_61143_((Property)BlockCable.CABLE)).booleanValue() && this.placeAtCorrected(world, insidePos, (BlockState)insideState.m_61124_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            BlockState existingState = world.m_8055_(pos);
            if (existingState.m_60734_() == Registry.ModBlocks.CABLE.get() && !((Boolean)existingState.m_61143_((Property)BlockCable.CABLE)).booleanValue() && this.placeAtCorrected(world, pos, (BlockState)existingState.m_61124_((Property)BlockCable.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            return super.m_40576_(context);
        }
    }

    public static class WiredModem
    extends ItemBlockCable {
        public WiredModem(BlockCable block, Item.Properties settings) {
            super(block, settings);
        }

        @Nonnull
        public InteractionResult m_40576_(BlockPlaceContext context) {
            Direction side;
            BlockState newState;
            BlockPos pos;
            ItemStack stack = context.m_43722_();
            if (stack.m_41619_()) {
                return InteractionResult.FAIL;
            }
            Level world = context.m_43725_();
            BlockState existingState = world.m_8055_(pos = context.m_8083_());
            if (existingState.m_60734_() == Registry.ModBlocks.CABLE.get() && existingState.m_61143_(BlockCable.MODEM) == CableModemVariant.None && this.placeAt(world, pos, newState = (BlockState)((BlockState)existingState.m_61124_(BlockCable.MODEM, (Comparable)((Object)CableModemVariant.from(side = context.m_43719_().m_122424_())))).m_61124_((Property)BlockCable.CONNECTIONS.get(side), (Comparable)((Boolean)existingState.m_61143_((Property)BlockCable.CABLE))), context.m_43723_())) {
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            return super.m_40576_(context);
        }
    }
}

