/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import dan200.computercraft.core.filesystem.FileSystemWrapper;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.core.IContainerComputer;
import dan200.computercraft.shared.computer.core.InputState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.upload.FileSlice;
import dan200.computercraft.shared.computer.upload.FileUpload;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public abstract class ContainerComputerBase
extends AbstractContainerMenu
implements IContainerComputer {
    private static final String LIST_PREFIX = "\n \u2022 ";
    private final Predicate<Player> canUse;
    private final IComputer computer;
    private final ComputerFamily family;
    private final InputState input = new InputState(this);
    private UUID toUploadId;
    private List<FileUpload> toUpload;

    public ContainerComputerBase(MenuType<? extends ContainerComputerBase> type, int id, Predicate<Player> canUse, IComputer computer, ComputerFamily family) {
        super(type, id);
        this.canUse = canUse;
        this.computer = computer;
        this.family = family;
    }

    public ContainerComputerBase(MenuType<? extends ContainerComputerBase> type, int id, Inventory player, ComputerContainerData data) {
        this(type, id, x -> true, ContainerComputerBase.getComputer(player, data), data.getFamily());
    }

    protected static IComputer getComputer(Inventory player, ComputerContainerData data) {
        int id = data.getInstanceId();
        if (!player.f_35978_.f_19853_.f_46443_) {
            return ComputerCraft.serverComputerRegistry.get(id);
        }
        ClientComputer computer = (ClientComputer)ComputerCraft.clientComputerRegistry.get(id);
        if (computer == null) {
            computer = new ClientComputer(id);
            ComputerCraft.clientComputerRegistry.add(id, computer);
        }
        return computer;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.canUse.test(player);
    }

    @Nonnull
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    @Nullable
    public IComputer getComputer() {
        return this.computer;
    }

    @Override
    @Nonnull
    public InputState getInput() {
        return this.input;
    }

    @Override
    public void startUpload(@Nonnull UUID uuid, @Nonnull List<FileUpload> files) {
        this.toUploadId = uuid;
        this.toUpload = files;
    }

    @Override
    public void continueUpload(@Nonnull UUID uploadId, @Nonnull List<FileSlice> slices) {
        if (this.toUploadId == null || this.toUpload == null || !this.toUploadId.equals(uploadId)) {
            ComputerCraft.log.warn("Invalid continueUpload call, skipping.");
            return;
        }
        for (FileSlice slice : slices) {
            slice.apply(this.toUpload);
        }
    }

    @Override
    public void finishUpload(@Nonnull ServerPlayer uploader, @Nonnull UUID uploadId) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty() || !this.toUploadId.equals(uploadId)) {
            ComputerCraft.log.warn("Invalid finishUpload call, skipping.");
            return;
        }
        UploadResultMessage message = this.finishUpload(false);
        NetworkHandler.sendToPlayer((Player)uploader, message);
    }

    @Override
    public void confirmUpload(@Nonnull ServerPlayer uploader, boolean overwrite) {
        if (this.toUploadId == null || this.toUpload == null || this.toUpload.isEmpty()) {
            ComputerCraft.log.warn("Invalid finishUpload call, skipping.");
            return;
        }
        UploadResultMessage message = this.finishUpload(true);
        NetworkHandler.sendToPlayer((Player)uploader, message);
    }

    @Nonnull
    private UploadResultMessage finishUpload(boolean forceOverwrite) {
        ServerComputer computer = (ServerComputer)this.getComputer();
        if (computer == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        FileSystem fs = computer.getComputer().getEnvironment().getFileSystem();
        if (fs == null) {
            return UploadResultMessage.COMPUTER_OFF;
        }
        for (FileUpload upload : this.toUpload) {
            if (upload.checksumMatches()) continue;
            ComputerCraft.log.warn("Checksum failed to match for {}.", (Object)upload.getName());
            return new UploadResultMessage(UploadResult.ERROR, (Component)new TranslatableComponent("gui.computercraft.upload.failed.corrupted"));
        }
        try {
            ArrayList<String> overwrite = new ArrayList<String>();
            List<FileUpload> files = this.toUpload;
            this.toUpload = null;
            for (FileUpload upload : files) {
                if (!fs.exists(upload.getName())) continue;
                if (fs.isDir(upload.getName())) {
                    return new UploadResultMessage(UploadResult.ERROR, (Component)new TranslatableComponent("gui.computercraft.upload.failed.overwrite_dir", new Object[]{upload.getName()}));
                }
                overwrite.add(upload.getName());
            }
            if (!overwrite.isEmpty() && !forceOverwrite) {
                StringJoiner joiner = new StringJoiner(LIST_PREFIX, LIST_PREFIX, "");
                for (String value : overwrite) {
                    joiner.add(value);
                }
                this.toUpload = files;
                return new UploadResultMessage(UploadResult.CONFIRM_OVERWRITE, (Component)new TranslatableComponent("gui.computercraft.upload.overwrite.detail", new Object[]{joiner.toString()}));
            }
            long availableSpace = fs.getFreeSpace("/");
            long neededSpace = 0L;
            for (FileUpload upload : files) {
                neededSpace += (long)Math.max(512, upload.getBytes().remaining());
            }
            if (neededSpace > availableSpace) {
                return UploadResultMessage.OUT_OF_SPACE;
            }
            for (FileUpload file : files) {
                FileSystemWrapper channel = fs.openForWrite(file.getName(), false, Function.identity());
                try {
                    ((WritableByteChannel)channel.get()).write(file.getBytes());
                }
                finally {
                    if (channel == null) continue;
                    channel.close();
                }
            }
            return new UploadResultMessage(UploadResult.SUCCESS, (Component)new TranslatableComponent("gui.computercraft.upload.success.msg", new Object[]{files.size()}));
        }
        catch (FileSystemException | IOException e) {
            ComputerCraft.log.error("Error uploading files", (Throwable)e);
            return new UploadResultMessage(UploadResult.ERROR, (Component)new TranslatableComponent("gui.computercraft.upload.failed.generic", new Object[]{e.getMessage()}));
        }
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.input.close();
    }
}

