/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeDataProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeDataProvider;
import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

class RecipeGenerator
extends RecipeProvider {
    private final TurtleUpgradeDataProvider turtleUpgrades;
    private final PocketUpgradeDataProvider pocketUpgrades;

    RecipeGenerator(DataGenerator generator, TurtleUpgradeDataProvider turtleUpgrades, PocketUpgradeDataProvider pocketUpgrades) {
        super(generator);
        this.turtleUpgrades = turtleUpgrades;
        this.pocketUpgrades = pocketUpgrades;
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        RecipeGenerator.addSpecial(add, PrintoutRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, DiskRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, ColourableRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, TurtleUpgradeRecipe.SERIALIZER);
        RecipeGenerator.addSpecial(add, PocketComputerUpgradeRecipe.SERIALIZER);
    }

    private void diskColours(@Nonnull Consumer<FinishedRecipe> add) {
        for (Colour colour : Colour.VALUES) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)Registry.ModItems.DISK.get())).m_206419_(Tags.Items.DUSTS_REDSTONE).m_126209_((ItemLike)Items.f_42516_).m_126209_((ItemLike)DyeItem.m_41082_((DyeColor)RecipeGenerator.ofColour(colour))).m_142409_("computercraft:disk").m_142284_("has_drive", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModBlocks.DISK_DRIVE.get())).m_142700_(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add, x -> x.m_128405_("Color", colour.getHex())), new ResourceLocation("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private void turtleUpgrades(@Nonnull Consumer<FinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null);
            if (base.m_41619_()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            for (ITurtleUpgrade upgrade : this.turtleUpgrades.getGeneratedUpgrades()) {
                ItemStack result = TurtleItemFactory.create(-1, null, -1, family, null, upgrade, -1, null);
                ShapedRecipeBuilder.m_126116_((ItemLike)result.m_41720_()).m_142409_(String.format("%s:turtle_%s", "computercraft", nameId)).m_126130_("#T").m_126127_(Character.valueOf('T'), (ItemLike)base.m_41720_()).m_126127_(Character.valueOf('#'), (ItemLike)upgrade.getCraftingItem().m_41720_()).m_142284_("has_items", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{base.m_41720_(), upgrade.getCraftingItem().m_41720_()})).m_142700_(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.m_41783_()), new ResourceLocation("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().m_135827_(), upgrade.getUpgradeID().m_135815_())));
            }
        }
    }

    private void pocketUpgrades(@Nonnull Consumer<FinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = PocketComputerItemFactory.create(-1, null, -1, family, null);
            if (base.m_41619_()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            for (IPocketUpgrade upgrade : this.pocketUpgrades.getGeneratedUpgrades()) {
                ItemStack result = PocketComputerItemFactory.create(-1, null, -1, family, upgrade);
                ShapedRecipeBuilder.m_126116_((ItemLike)result.m_41720_()).m_142409_(String.format("%s:pocket_%s", "computercraft", nameId)).m_126130_("#").m_126130_("P").m_126127_(Character.valueOf('P'), (ItemLike)base.m_41720_()).m_126127_(Character.valueOf('#'), (ItemLike)upgrade.getCraftingItem().m_41720_()).m_142284_("has_items", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{base.m_41720_(), upgrade.getCraftingItem().m_41720_()})).m_142700_(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.m_41783_()), new ResourceLocation("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().m_135827_(), upgrade.getUpgradeID().m_135815_())));
            }
        }
    }

    private void basicRecipes(@Nonnull Consumer<FinishedRecipe> add) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)Registry.ModItems.CABLE.get()), (int)6).m_126130_(" # ").m_126130_("#R#").m_126130_(" # ").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_142284_("has_modem", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.COMPUTER_NORMAL.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_redstone", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((TagKey<Item>)Tags.Items.DUSTS_REDSTONE)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_components", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{Items.f_42451_, Items.f_42417_})).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.COMPUTER_COMMAND.get())).m_126130_("###").m_126130_("#R#").m_126130_("#G#").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('R'), (ItemLike)Blocks.f_50272_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_components", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{Blocks.f_50272_})).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.DISK_DRIVE.get())).m_126130_("###").m_126130_("#R#").m_126130_("#R#").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.MONITOR_NORMAL.get())).m_126130_("###").m_126130_("#G#").m_126130_("###").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)Registry.ModBlocks.MONITOR_ADVANCED.get()), (int)4).m_126130_("###").m_126130_("#G#").m_126130_("###").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModItems.POCKET_COMPUTER_NORMAL.get())).m_126130_("###").m_126130_("#A#").m_126130_("#G#").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42436_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_142284_("has_apple", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{Items.f_42436_})).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())).m_126130_("###").m_126130_("#A#").m_126130_("#G#").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42436_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_142284_("has_apple", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(new ItemLike[]{Items.f_42436_})).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.PRINTER.get())).m_126130_("###").m_126130_("#R#").m_126130_("#D#").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), Tags.Items.DYES).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.SPEAKER.get())).m_126130_("###").m_126130_("#N#").m_126130_("#R#").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_126127_(Character.valueOf('N'), (ItemLike)Blocks.f_50065_).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModItems.WIRED_MODEM.get())).m_126130_("###").m_126130_("#R#").m_126130_("###").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_142284_("has_cable", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModItems.CABLE.get())).m_176498_(add);
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)Registry.ModBlocks.WIRED_MODEM_FULL.get())).m_126209_((ItemLike)Registry.ModItems.WIRED_MODEM.get()).m_142284_("has_modem", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_142700_(add, new ResourceLocation("computercraft", "wired_modem_full_from"));
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)Registry.ModItems.WIRED_MODEM.get())).m_126209_((ItemLike)Registry.ModBlocks.WIRED_MODEM_FULL.get()).m_142284_("has_modem", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).m_142700_(add, new ResourceLocation("computercraft", "wired_modem_full_to"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).m_126130_("###").m_126130_("#E#").m_126130_("###").m_206416_(Character.valueOf('#'), Tags.Items.STONE).m_206416_(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_176498_(add);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get())).m_126130_("###").m_126130_("#E#").m_126130_("###").m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange(ComputerCraftTags.Items.COMPUTER)).m_142284_("has_wireless", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).m_176498_(add);
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42680_).m_206419_(Tags.Items.HEADS).m_126209_((ItemLike)Registry.ModItems.MONITOR_NORMAL.get()).m_142284_("has_monitor", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModItems.MONITOR_NORMAL.get())).m_142700_(RecipeWrapper.wrap(RecipeSerializer.f_44077_, add, RecipeGenerator.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new ResourceLocation("computercraft", "skull_cloudy"));
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42680_).m_206419_(Tags.Items.HEADS).m_126209_((ItemLike)Registry.ModItems.COMPUTER_ADVANCED.get()).m_142284_("has_computer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModItems.COMPUTER_ADVANCED.get())).m_142700_(RecipeWrapper.wrap(RecipeSerializer.f_44077_, add, RecipeGenerator.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new ResourceLocation("computercraft", "skull_dan200"));
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)Registry.ModItems.PRINTED_PAGES.get())).m_126211_((ItemLike)Registry.ModItems.PRINTED_PAGE.get(), 2).m_206419_(Tags.Items.STRING).m_142284_("has_printer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModBlocks.PRINTER.get())).m_176498_(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)Registry.ModItems.PRINTED_BOOK.get())).m_206419_(Tags.Items.LEATHER).m_126211_((ItemLike)Registry.ModItems.PRINTED_PAGE.get(), 1).m_206419_(Tags.Items.STRING).m_142284_("has_printer", (CriterionTriggerInstance)RecipeGenerator.inventoryChange((ItemLike)Registry.ModBlocks.PRINTER.get())).m_176498_(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
    }

    private static DyeColor ofColour(Colour colour) {
        return DyeColor.m_41053_((int)(15 - colour.ordinal()));
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryChange(TagKey<Item> stack) {
        return InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(stack).m_45077_()});
    }

    private static InventoryChangeTrigger.TriggerInstance inventoryChange(ItemLike ... stack) {
        return InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])stack);
    }

    private static CompoundTag playerHead(String name, String uuid) {
        CompoundTag owner = new CompoundTag();
        owner.m_128359_("Name", name);
        owner.m_128359_("Id", uuid);
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("SkullOwner", (Tag)owner);
        return tag;
    }

    private static void addSpecial(Consumer<FinishedRecipe> add, SimpleRecipeSerializer<?> special) {
        SpecialRecipeBuilder.m_126357_(special).m_126359_(add, special.getRegistryName().toString());
    }
}

