/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.simibubi.create.foundation.block.BlockStressDefaults;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlockStressValues {
    private static final Map<String, IStressValueProvider> PROVIDERS = new HashMap<String, IStressValueProvider>();

    public static void registerProvider(String namespace, IStressValueProvider provider) {
        PROVIDERS.put(namespace, provider);
    }

    @Nullable
    public static IStressValueProvider getProvider(String namespace) {
        return PROVIDERS.get(namespace);
    }

    @Nullable
    public static IStressValueProvider getProvider(Block block) {
        return BlockStressValues.getProvider(block.getRegistryName().m_135827_());
    }

    public static double getImpact(Block block) {
        ResourceLocation blockId = block.getRegistryName();
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.m_135827_());
        if (provider != null) {
            return provider.getImpact(block);
        }
        Double defaultImpact = BlockStressDefaults.DEFAULT_IMPACTS.get(blockId);
        if (defaultImpact != null) {
            return defaultImpact;
        }
        return 0.0;
    }

    public static double getCapacity(Block block) {
        ResourceLocation blockId = block.getRegistryName();
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.m_135827_());
        if (provider != null) {
            return provider.getCapacity(block);
        }
        Double defaultCapacity = BlockStressDefaults.DEFAULT_CAPACITIES.get(blockId);
        if (defaultCapacity != null) {
            return defaultCapacity;
        }
        return 0.0;
    }

    public static boolean hasImpact(Block block) {
        ResourceLocation blockId = block.getRegistryName();
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.m_135827_());
        if (provider != null) {
            return provider.hasImpact(block);
        }
        return BlockStressDefaults.DEFAULT_IMPACTS.containsKey(blockId);
    }

    public static boolean hasCapacity(Block block) {
        ResourceLocation blockId = block.getRegistryName();
        IStressValueProvider provider = BlockStressValues.getProvider(blockId.m_135827_());
        if (provider != null) {
            return provider.hasCapacity(block);
        }
        return BlockStressDefaults.DEFAULT_CAPACITIES.containsKey(blockId);
    }

    public static interface IStressValueProvider {
        public double getImpact(Block var1);

        public double getCapacity(Block var1);

        public boolean hasImpact(Block var1);

        public boolean hasCapacity(Block var1);
    }
}

