/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class NixieTubeTileEntity
extends SmartTileEntity {
    private static final Couple<String> EMPTY = Couple.create("", "");
    private boolean hasCustomText = false;
    private int redstoneStrength = 0;
    private JsonElement rawCustomText;
    private int customTextIndex;
    private Component parsedCustomText;
    private Couple<String> displayedStrings;

    public NixieTubeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ instanceof ServerLevel && this.hasCustomText) {
            Couple<String> currentStrings = this.displayedStrings;
            this.parsedCustomText = this.parseCustomText();
            this.updateDisplayedStrings();
            if (currentStrings == null || !currentStrings.equals(this.displayedStrings)) {
                this.sendData();
            }
        }
    }

    @Override
    public void initialize() {
        if (this.f_58857_.f_46443_) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return !this.hasCustomText;
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        this.notifyUpdate();
    }

    public void displayCustomNameOf(ItemStack stack, int nixiePositionInRow) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        if (compoundnbt != null && compoundnbt.m_128425_("Name", 8)) {
            this.hasCustomText = true;
            this.rawCustomText = this.getJsonFromString(compoundnbt.m_128461_("Name"));
            this.customTextIndex = nixiePositionInRow;
            this.parsedCustomText = this.parseCustomText();
            this.notifyUpdate();
        }
    }

    public void updateDisplayedStrings() {
        if (!this.hasCustomText) {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        } else {
            String fullText = this.parsedCustomText.getString();
            int index = this.customTextIndex * 2;
            this.displayedStrings = Couple.create(this.charOrEmpty(fullText, index), this.charOrEmpty(fullText, index + 1));
        }
    }

    public void clearCustomText() {
        this.hasCustomText = false;
        this.rawCustomText = null;
        this.customTextIndex = 0;
        this.parsedCustomText = null;
    }

    @Override
    protected void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128425_("RawCustomText", 8)) {
            Component deserializedComponent;
            this.rawCustomText = this.getJsonFromString(nbt.m_128461_("RawCustomText"));
            if (this.rawCustomText != null && !this.rawCustomText.isJsonNull() && (deserializedComponent = this.parseCustomText()) != null) {
                try {
                    this.parsedCustomText = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomText"));
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
                if (this.parsedCustomText == null) {
                    this.parsedCustomText = deserializedComponent;
                }
                this.hasCustomText = true;
                this.customTextIndex = nbt.m_128451_("CustomTextIndex");
            }
        }
        if (!this.hasCustomText) {
            this.clearCustomText();
            this.redstoneStrength = nbt.m_128451_("RedstoneStrength");
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.hasCustomText) {
            nbt.m_128359_("RawCustomText", this.rawCustomText.toString());
            nbt.m_128405_("CustomTextIndex", this.customTextIndex);
            nbt.m_128359_("CustomText", Component.Serializer.m_130703_((Component)this.parsedCustomText));
        } else {
            nbt.m_128405_("RedstoneStrength", this.redstoneStrength);
        }
    }

    private JsonElement getJsonFromString(String string) {
        try {
            return JsonParser.parseString((String)string);
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    protected Component parseCustomText() {
        try {
            return this.parseDynamicComponent((Component)Component.Serializer.m_130691_((JsonElement)this.rawCustomText));
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    protected Component parseDynamicComponent(Component customText) {
        if (this.f_58857_ instanceof ServerLevel) {
            try {
                return ComponentUtils.m_130731_((CommandSourceStack)this.getCommandSource(null), (Component)customText, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return customText;
    }

    public CommandSourceStack getCommandSource(@Nullable ServerPlayer p_195539_1_) {
        String s = p_195539_1_ == null ? "Nixie Tube" : p_195539_1_.m_7755_().getString();
        TextComponent itextcomponent = p_195539_1_ == null ? new TextComponent("Nixie Tube") : p_195539_1_.m_5446_();
        return new CommandSourceStack(CommandSource.f_80164_, Vec3.m_82512_((Vec3i)this.f_58858_), Vec2.f_82462_, (ServerLevel)this.f_58857_, 2, s, (Component)itextcomponent, this.f_58857_.m_142572_(), (Entity)p_195539_1_);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

