/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.tools;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.tools.BlueprintEntity;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterContainer;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class BlueprintOverlayRenderer {
    public static final IIngameOverlay OVERLAY = BlueprintOverlayRenderer::renderOverlay;
    static boolean active;
    static boolean empty;
    static boolean lastSneakState;
    static BlueprintEntity.BlueprintSection lastTargetedSection;
    static Map<ItemStack, ItemStack[]> cachedRenderedFilters;
    static List<Pair<ItemStack, Boolean>> ingredients;
    static ItemStack result;
    static boolean resultCraftable;

    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult mouseOver = mc.f_91077_;
        BlueprintEntity.BlueprintSection last = lastTargetedSection;
        boolean sneak = mc.f_91074_.m_6144_();
        lastTargetedSection = null;
        active = false;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.m_6662_() != HitResult.Type.ENTITY) {
            return;
        }
        EntityHitResult entityRay = (EntityHitResult)mouseOver;
        if (!(entityRay.m_82443_() instanceof BlueprintEntity)) {
            return;
        }
        BlueprintEntity blueprintEntity = (BlueprintEntity)entityRay.m_82443_();
        BlueprintEntity.BlueprintSection sectionAt = blueprintEntity.getSectionAt(entityRay.m_82450_().m_82546_(blueprintEntity.m_20182_()));
        lastTargetedSection = last;
        active = true;
        if (sectionAt != lastTargetedSection || AnimationTickHolder.getTicks() % 10 == 0 || lastSneakState != sneak) {
            BlueprintOverlayRenderer.rebuild(sectionAt, sneak);
        }
        lastTargetedSection = sectionAt;
        lastSneakState = sneak;
    }

    public static void rebuild(BlueprintEntity.BlueprintSection sectionAt, boolean sneak) {
        int i;
        cachedRenderedFilters.clear();
        ItemStackHandler items = sectionAt.getItems();
        boolean empty = true;
        for (int i2 = 0; i2 < 9; ++i2) {
            if (items.getStackInSlot(i2).m_41619_()) continue;
            empty = false;
            break;
        }
        BlueprintOverlayRenderer.empty = empty;
        result = ItemStack.f_41583_;
        if (empty) {
            return;
        }
        boolean firstPass = true;
        boolean success = true;
        Minecraft mc = Minecraft.m_91087_();
        ItemStackHandler playerInv = new ItemStackHandler(mc.f_91074_.m_150109_().m_6643_());
        for (int i3 = 0; i3 < playerInv.getSlots(); ++i3) {
            playerInv.setStackInSlot(i3, mc.f_91074_.m_150109_().m_8020_(i3).m_41777_());
        }
        int amountCrafted = 0;
        Optional recipe = Optional.empty();
        HashMap<Integer, ItemStack> craftingGrid = new HashMap<Integer, ItemStack>();
        ingredients.clear();
        ItemStackHandler missingItems = new ItemStackHandler(64);
        ItemStackHandler availableItems = new ItemStackHandler(64);
        ArrayList<ItemStack> newlyAdded = new ArrayList<ItemStack>();
        ArrayList<ItemStack> newlyMissing = new ArrayList<ItemStack>();
        boolean invalid = false;
        do {
            craftingGrid.clear();
            newlyAdded.clear();
            newlyMissing.clear();
            block3: for (i = 0; i < 9; ++i) {
                ItemStack requestedItem = items.getStackInSlot(i);
                if (requestedItem.m_41619_()) {
                    craftingGrid.put(i, ItemStack.f_41583_);
                    continue;
                }
                for (int slot = 0; slot < playerInv.getSlots(); ++slot) {
                    if (!FilterItem.test((Level)mc.f_91073_, playerInv.getStackInSlot(slot), requestedItem)) continue;
                    ItemStack currentItem = playerInv.extractItem(slot, 1, false);
                    craftingGrid.put(i, currentItem);
                    newlyAdded.add(currentItem);
                    continue block3;
                }
                success = false;
                newlyMissing.add(requestedItem);
            }
            if (success) {
                ItemStack resultFromRecipe;
                BlueprintEntity.BlueprintCraftingInventory craftingInventory = new BlueprintEntity.BlueprintCraftingInventory(craftingGrid);
                if (!recipe.isPresent()) {
                    recipe = mc.f_91073_.m_7465_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, (Level)mc.f_91073_);
                }
                if ((resultFromRecipe = recipe.filter(r -> r.m_5818_((Container)craftingInventory, (Level)mc.f_91073_)).map(r -> r.m_5874_((Container)craftingInventory)).orElse(ItemStack.f_41583_)).m_41619_()) {
                    if (!recipe.isPresent()) {
                        invalid = true;
                    }
                    success = false;
                } else if (resultFromRecipe.m_41613_() + amountCrafted > 64) {
                    success = false;
                } else {
                    amountCrafted += resultFromRecipe.m_41613_();
                    if (result.m_41619_()) {
                        result = resultFromRecipe.m_41777_();
                    } else {
                        result.m_41769_(resultFromRecipe.m_41613_());
                    }
                    resultCraftable = true;
                    firstPass = false;
                }
            }
            if (success || firstPass) {
                newlyAdded.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)availableItems, (ItemStack)s, (boolean)false));
                newlyMissing.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)missingItems, (ItemStack)s, (boolean)false));
            }
            if (success) continue;
            if (!firstPass) break;
            result = invalid ? ItemStack.f_41583_ : items.getStackInSlot(9);
            resultCraftable = false;
            break;
        } while (sneak && success);
        for (i = 0; i < 9; ++i) {
            ItemStack available = availableItems.getStackInSlot(i);
            if (available.m_41619_()) continue;
            ingredients.add(Pair.of(available, true));
        }
        for (i = 0; i < 9; ++i) {
            ItemStack missing = missingItems.getStackInSlot(i);
            if (missing.m_41619_()) continue;
            ingredients.add(Pair.of(missing, false));
        }
    }

    public static void renderOverlay(ForgeIngameGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        if (!active || empty) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int w = 30 + 21 * ingredients.size() + 21;
        int x = (width - w) / 2;
        int y = (int)((float)height / 3.0f * 2.0f);
        for (Pair<ItemStack, Boolean> pair : ingredients) {
            RenderSystem.m_69478_();
            (pair.getSecond() != false ? AllGuiTextures.HOTSLOT_ACTIVE : AllGuiTextures.HOTSLOT).render(poseStack, x, y);
            ItemStack itemStack = pair.getFirst();
            String count = pair.getSecond() != false ? null : ChatFormatting.GOLD.toString() + itemStack.m_41613_();
            BlueprintOverlayRenderer.drawItemStack(poseStack, mc, x, y, itemStack, count);
            x += 21;
        }
        RenderSystem.m_69478_();
        AllGuiTextures.HOTSLOT_ARROW.render(poseStack, x += 5, y + 4);
        x += 25;
        if (result.m_41619_()) {
            AllGuiTextures.HOTSLOT.render(poseStack, x, y);
            ((RenderElement)GuiGameElement.of((ItemLike)Items.f_42127_).at(x + 3, y + 3)).render(poseStack);
        } else {
            (resultCraftable ? AllGuiTextures.HOTSLOT_SUPER_ACTIVE : AllGuiTextures.HOTSLOT).render(poseStack, resultCraftable ? x - 1 : x, resultCraftable ? y - 1 : y);
            BlueprintOverlayRenderer.drawItemStack(poseStack, mc, x, y, result, null);
        }
    }

    public static void drawItemStack(PoseStack ms, Minecraft mc, int x, int y, ItemStack itemStack, String count) {
        if (itemStack.m_41720_() instanceof FilterItem) {
            int step = AnimationTickHolder.getTicks((LevelAccessor)mc.f_91073_) / 10;
            ItemStack[] itemsMatchingFilter = BlueprintOverlayRenderer.getItemsMatchingFilter(itemStack);
            if (itemsMatchingFilter.length > 0) {
                itemStack = itemsMatchingFilter[step % itemsMatchingFilter.length];
            }
        }
        ((RenderElement)GuiGameElement.of(itemStack).at(x + 3, y + 3)).render(ms);
        mc.m_91291_().m_115174_(mc.f_91062_, itemStack, x + 3, y + 3, count);
    }

    private static ItemStack[] getItemsMatchingFilter(ItemStack filter) {
        return cachedRenderedFilters.computeIfAbsent(filter, itemStack -> {
            CompoundTag tag = itemStack.m_41784_();
            if (AllItems.FILTER.isIn((ItemStack)itemStack) && !tag.m_128471_("Blacklist")) {
                ItemStackHandler filterItems = FilterItem.getFilterItems(itemStack);
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int slot = 0; slot < filterItems.getSlots(); ++slot) {
                    ItemStack stackInSlot = filterItems.getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    list.add(stackInSlot);
                }
                return list.toArray(new ItemStack[list.size()]);
            }
            if (AllItems.ATTRIBUTE_FILTER.isIn((ItemStack)itemStack)) {
                ItemAttribute fromNBT;
                AttributeFilterContainer.WhitelistMode whitelistMode = AttributeFilterContainer.WhitelistMode.values()[tag.m_128451_("WhitelistMode")];
                ListTag attributes = tag.m_128437_("MatchedAttributes", 10);
                if (whitelistMode == AttributeFilterContainer.WhitelistMode.WHITELIST_DISJ && attributes.size() == 1 && (fromNBT = ItemAttribute.fromNBT((CompoundTag)attributes.get(0))) instanceof ItemAttribute.InTag) {
                    ITag taggedItems;
                    ItemAttribute.InTag inTag = (ItemAttribute.InTag)fromNBT;
                    ITagManager tagManager = ForgeRegistries.ITEMS.tags();
                    if (tagManager.isKnownTagName(inTag.tag) && !(taggedItems = tagManager.getTag(inTag.tag)).isEmpty()) {
                        ItemStack[] stacks = new ItemStack[taggedItems.size()];
                        int i = 0;
                        for (Item item : taggedItems) {
                            stacks[i] = new ItemStack((ItemLike)item);
                            ++i;
                        }
                        return stacks;
                    }
                }
            }
            return new ItemStack[0];
        });
    }

    static {
        cachedRenderedFilters = new IdentityHashMap<ItemStack, ItemStack[]>();
        ingredients = new ArrayList<Pair<ItemStack, Boolean>>();
        result = ItemStack.f_41583_;
        resultCraftable = false;
    }
}

