/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.potion;

import com.google.common.collect.Lists;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class PotionFluidHandler {
    public static Pair<FluidStack, ItemStack> emptyPotion(ItemStack stack, boolean simulate) {
        FluidStack fluid = PotionFluidHandler.getFluidFromPotionItem(stack);
        if (!simulate) {
            stack.m_41774_(1);
        }
        return Pair.of(fluid, new ItemStack((ItemLike)Items.f_42590_));
    }

    public static FluidIngredient potionIngredient(Potion potion, int amount) {
        return FluidIngredient.fromFluidStack(FluidHelper.copyStackWithAmount(PotionFluidHandler.getFluidFromPotionItem(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion)), amount));
    }

    public static FluidStack getFluidFromPotionItem(ItemStack stack) {
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        List list = PotionUtils.m_43571_((ItemStack)stack);
        PotionFluid.BottleType bottleTypeFromItem = PotionFluidHandler.bottleTypeFromItem(stack.m_41720_());
        if (potion == Potions.f_43599_ && list.isEmpty() && bottleTypeFromItem == PotionFluid.BottleType.REGULAR) {
            return new FluidStack((Fluid)Fluids.f_76193_, 250);
        }
        FluidStack fluid = PotionFluid.withEffects(250, potion, list);
        NBTHelper.writeEnum(fluid.getOrCreateTag(), "Bottle", bottleTypeFromItem);
        return fluid;
    }

    public static FluidStack getFluidFromPotion(Potion potion, PotionFluid.BottleType bottleType, int amount) {
        if (potion == Potions.f_43599_ && bottleType == PotionFluid.BottleType.REGULAR) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        FluidStack fluid = PotionFluid.of(amount, potion);
        NBTHelper.writeEnum(fluid.getOrCreateTag(), "Bottle", bottleType);
        return fluid;
    }

    public static PotionFluid.BottleType bottleTypeFromItem(Item item) {
        if (item == Items.f_42739_) {
            return PotionFluid.BottleType.LINGERING;
        }
        if (item == Items.f_42736_) {
            return PotionFluid.BottleType.SPLASH;
        }
        return PotionFluid.BottleType.REGULAR;
    }

    public static ItemLike itemFromBottleType(PotionFluid.BottleType type) {
        switch (type) {
            case LINGERING: {
                return Items.f_42739_;
            }
            case SPLASH: {
                return Items.f_42736_;
            }
        }
        return Items.f_42589_;
    }

    public static int getRequiredAmountForFilledBottle(ItemStack stack, FluidStack availableFluid) {
        return 250;
    }

    public static ItemStack fillBottle(ItemStack stack, FluidStack availableFluid) {
        CompoundTag tag = availableFluid.getOrCreateTag();
        ItemStack potionStack = new ItemStack(PotionFluidHandler.itemFromBottleType(NBTHelper.readEnum(tag, "Bottle", PotionFluid.BottleType.class)));
        PotionUtils.m_43549_((ItemStack)potionStack, (Potion)PotionUtils.m_43577_((CompoundTag)tag));
        PotionUtils.m_43552_((ItemStack)potionStack, (Collection)PotionUtils.m_43573_((CompoundTag)tag));
        return potionStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addPotionTooltip(FluidStack fs, List<Component> tooltip, float p_185182_2_) {
        List list = PotionUtils.m_43566_((CompoundTag)fs.getOrCreateTag());
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add((Component)new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                TranslatableComponent textcomponent = new TranslatableComponent(effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Tuple((Object)((Attribute)entry.getKey()).m_22087_(), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() > 0) {
                    textcomponent.m_130946_(" ").m_130946_(new TranslatableComponent("potion.potency." + effectinstance.m_19564_()).getString());
                }
                if (effectinstance.m_19557_() > 20) {
                    textcomponent.m_130946_(" (").m_130946_(MobEffectUtil.m_19581_((MobEffectInstance)effectinstance, (float)p_185182_2_)).m_130946_(")");
                }
                tooltip.add((Component)textcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.m_14419_();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent((String)tuple.m_14418_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent((String)tuple.m_14418_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

