/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(LevelReader var1, BlockPos var2, BlockState var3, Direction var4);

    public Direction.Axis getRotationAxis(BlockState var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.SLOW;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum SpeedLevel {
        NONE(ChatFormatting.DARK_GRAY, 0, 0),
        SLOW(ChatFormatting.GREEN, 0x22FF22, 10),
        MEDIUM(ChatFormatting.AQUA, 34047, 20),
        FAST(ChatFormatting.LIGHT_PURPLE, 0xFF55FF, 30);

        private final ChatFormatting textColor;
        private final int color;
        private final int particleSpeed;

        private SpeedLevel(ChatFormatting textColor, int color, int particleSpeed) {
            this.textColor = textColor;
            this.color = color;
            this.particleSpeed = particleSpeed;
        }

        public ChatFormatting getTextColor() {
            return this.textColor;
        }

        public int getColor() {
            return this.color;
        }

        public int getParticleSpeed() {
            return this.particleSpeed;
        }

        public float getSpeedValue() {
            switch (this) {
                case FAST: {
                    return ((Double)AllConfigs.SERVER.kinetics.fastSpeed.get()).floatValue();
                }
                case MEDIUM: {
                    return ((Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()).floatValue();
                }
                case SLOW: {
                    return 1.0f;
                }
            }
            return 0.0f;
        }

        public static SpeedLevel of(float speed) {
            if ((double)(speed = Math.abs(speed)) >= (Double)AllConfigs.SERVER.kinetics.fastSpeed.get()) {
                return FAST;
            }
            if ((double)speed >= (Double)AllConfigs.SERVER.kinetics.mediumSpeed.get()) {
                return MEDIUM;
            }
            if (speed >= 1.0f) {
                return SLOW;
            }
            return NONE;
        }

        public static Component getFormattedSpeedText(float speed, boolean overstressed) {
            SpeedLevel speedLevel = SpeedLevel.of(speed);
            TextComponent level = new TextComponent(ItemDescription.makeProgressBar(3, speedLevel.ordinal()));
            level.m_7220_((Component)Lang.translate("tooltip.speedRequirement." + Lang.asId(speedLevel.name()), new Object[0]));
            level.m_130946_(" (" + IHaveGoggleInformation.format(Math.abs(speed))).m_7220_((Component)Lang.translate("generic.unit.rpm", new Object[0])).m_130946_(") ");
            if (overstressed) {
                level.m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.STRIKETHROUGH});
            } else {
                level.m_130940_(speedLevel.getTextColor());
            }
            return level;
        }
    }

    public static enum StressImpact {
        LOW(ChatFormatting.YELLOW, ChatFormatting.GREEN),
        MEDIUM(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        HIGH(ChatFormatting.RED, ChatFormatting.GOLD),
        OVERSTRESSED(ChatFormatting.RED, ChatFormatting.RED);

        private final ChatFormatting absoluteColor;
        private final ChatFormatting relativeColor;

        private StressImpact(ChatFormatting absoluteColor, ChatFormatting relativeColor) {
            this.absoluteColor = absoluteColor;
            this.relativeColor = relativeColor;
        }

        public ChatFormatting getAbsoluteColor() {
            return this.absoluteColor;
        }

        public ChatFormatting getRelativeColor() {
            return this.relativeColor;
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.SERVER.kinetics.disableStress.get() == false;
        }

        public static Component getFormattedStressText(double stressPercent) {
            StressImpact stressLevel = StressImpact.of(stressPercent);
            TextComponent level = new TextComponent(ItemDescription.makeProgressBar(3, Math.min(stressLevel.ordinal() + 1, 3)));
            level.m_7220_((Component)Lang.translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]));
            level.m_130946_(String.format(" (%s%%) ", (int)(stressPercent * 100.0)));
            return level.m_130940_(stressLevel.getRelativeColor());
        }
    }
}

