/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.Random;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.util.text.ITextComponent;

public final class MathUtils {
    public static int parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int randomIntInRange(int min, int max) {
        Random rand = new Random();
        return rand.nextInt(max - min + 1) + min;
    }

    public static int scaleToRedstone(long currentAmount, long max) {
        double proportion = (double)currentAmount / (double)max;
        if (currentAmount <= 0L) {
            return 0;
        }
        if (currentAmount >= max) {
            return 15;
        }
        return (int)Math.round(proportion * 13.0 + 1.0);
    }

    public static double tickToSec(int ticks) {
        return (double)ticks / 20.0;
    }

    public static ITextComponent tickToSecFormatted(int ticks) {
        double result = MathUtils.tickToSec(ticks);
        if (result == 0.0) {
            return PELang.EVERY_TICK.translate(result);
        }
        return PELang.SECONDS.translate(result);
    }

    public static int secToTicks(double secs) {
        return (int)Math.round(secs * 20.0);
    }

    public static long clampToLong(BigInteger bigInt) {
        if (bigInt.compareTo(Constants.MAX_LONG) > 0) {
            return Long.MAX_VALUE;
        }
        return bigInt.longValueExact();
    }
}

