/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.capability.managing.SerializableCapabilityResolver;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public final class KnowledgeImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IKnowledgeProvider.class, (Capability.IStorage)new Capability.IStorage<IKnowledgeProvider>(){

            public CompoundNBT writeNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IKnowledgeProvider> capability, IKnowledgeProvider instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> new DefaultImpl(null));
    }

    private KnowledgeImpl() {
    }

    public static class Provider
    extends SerializableCapabilityResolver<IKnowledgeProvider> {
        public static final ResourceLocation NAME = PECore.rl("knowledge");

        public Provider(PlayerEntity player) {
            super(new DefaultImpl(player));
        }

        @Override
        @Nonnull
        public Capability<IKnowledgeProvider> getMatchingCapability() {
            return ProjectEAPI.KNOWLEDGE_CAPABILITY;
        }
    }

    private static class DefaultImpl
    implements IKnowledgeProvider {
        @Nullable
        private final PlayerEntity player;
        private final Set<ItemInfo> knowledge = new HashSet<ItemInfo>();
        private final IItemHandlerModifiable inputLocks = new ItemStackHandler(9);
        private BigInteger emc = BigInteger.ZERO;
        private boolean fullKnowledge = false;

        private DefaultImpl(@Nullable PlayerEntity player) {
            this.player = player;
        }

        private void fireChangedEvent() {
            if (this.player != null && !this.player.field_70170_p.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(this.player));
            }
        }

        @Override
        public boolean hasFullKnowledge() {
            return this.fullKnowledge;
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge) {
            boolean changed = this.fullKnowledge != fullKnowledge;
            this.fullKnowledge = fullKnowledge;
            if (changed) {
                this.fireChangedEvent();
            }
        }

        @Override
        public void clearKnowledge() {
            boolean hasKnowledge = this.fullKnowledge || !this.knowledge.isEmpty();
            this.knowledge.clear();
            this.fullKnowledge = false;
            if (hasKnowledge) {
                this.fireChangedEvent();
            }
        }

        @Nullable
        private ItemInfo getIfPersistent(@Nonnull ItemInfo info) {
            if (!info.hasNBT() || EMCMappingHandler.hasEmcValue(info)) {
                return null;
            }
            ItemInfo cleanedInfo = NBTManager.getPersistentInfo(info);
            if (cleanedInfo.hasNBT() && !EMCMappingHandler.hasEmcValue(cleanedInfo)) {
                return cleanedInfo;
            }
            return null;
        }

        @Override
        public boolean hasKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                ItemInfo persistentInfo = this.getIfPersistent(info);
                return persistentInfo == null || this.knowledge.contains(persistentInfo);
            }
            return this.knowledge.contains(NBTManager.getPersistentInfo(info));
        }

        @Override
        public boolean addKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                ItemInfo persistentInfo = this.getIfPersistent(info);
                if (persistentInfo == null) {
                    return false;
                }
                return this.tryAdd(persistentInfo);
            }
            if (info.getItem() instanceof Tome) {
                if (info.hasNBT()) {
                    info = ItemInfo.fromItem(info.getItem());
                }
                this.knowledge.add(info);
                this.fullKnowledge = true;
                this.fireChangedEvent();
                return true;
            }
            return this.tryAdd(NBTManager.getPersistentInfo(info));
        }

        private boolean tryAdd(@Nonnull ItemInfo cleanedInfo) {
            if (this.knowledge.add(cleanedInfo)) {
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        public boolean removeKnowledge(@Nonnull ItemInfo info) {
            if (this.fullKnowledge) {
                if (info.getItem() instanceof Tome) {
                    if (info.hasNBT()) {
                        info = ItemInfo.fromItem(info.getItem());
                    }
                    this.knowledge.remove(info);
                    this.fullKnowledge = false;
                    this.fireChangedEvent();
                    return true;
                }
                ItemInfo persistentInfo = this.getIfPersistent(info);
                return persistentInfo != null && this.tryRemove(persistentInfo);
            }
            return this.tryRemove(NBTManager.getPersistentInfo(info));
        }

        private boolean tryRemove(@Nonnull ItemInfo cleanedInfo) {
            if (this.knowledge.remove(cleanedInfo)) {
                this.fireChangedEvent();
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public Set<ItemInfo> getKnowledge() {
            if (this.fullKnowledge) {
                Set<ItemInfo> allKnowledge = EMCMappingHandler.getMappedItems();
                allKnowledge.addAll(this.knowledge);
                return Collections.unmodifiableSet(allKnowledge);
            }
            return Collections.unmodifiableSet(this.knowledge);
        }

        @Nonnull
        public IItemHandlerModifiable getInputAndLocks() {
            return this.inputLocks;
        }

        @Override
        public BigInteger getEmc() {
            return this.emc;
        }

        @Override
        public void setEmc(BigInteger emc) {
            this.emc = emc;
        }

        @Override
        public void sync(@Nonnull ServerPlayerEntity player) {
            PacketHandler.sendTo(new KnowledgeSyncPKT(this.serializeNBT()), player);
        }

        @Override
        public void syncEmc(@Nonnull ServerPlayerEntity player) {
            PacketHandler.sendTo(new KnowledgeSyncEmcPKT(this.getEmc()), player);
        }

        @Override
        public void syncKnowledgeChange(@Nonnull ServerPlayerEntity player, ItemInfo change, boolean learned) {
            PacketHandler.sendTo(new KnowledgeSyncChangePKT(change, learned), player);
        }

        @Override
        public void syncInputAndLocks(@Nonnull ServerPlayerEntity player, List<Integer> slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
            if (!slotsChanged.isEmpty()) {
                int slots = this.inputLocks.getSlots();
                HashMap<Integer, ItemStack> stacksToSync = new HashMap<Integer, ItemStack>();
                for (int slot : slotsChanged) {
                    if (slot < 0 || slot >= slots) continue;
                    stacksToSync.put(slot, this.inputLocks.getStackInSlot(slot));
                }
                if (!stacksToSync.isEmpty()) {
                    PacketHandler.sendTo(new KnowledgeSyncInputsAndLocksPKT(stacksToSync, updateTargets), player);
                }
            }
        }

        @Override
        public void receiveInputsAndLocks(Map<Integer, ItemStack> changes) {
            int slots = this.inputLocks.getSlots();
            for (Map.Entry<Integer, ItemStack> entry : changes.entrySet()) {
                int slot = entry.getKey();
                if (slot < 0 || slot >= slots) continue;
                this.inputLocks.setStackInSlot(slot, entry.getValue());
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT properties = new CompoundNBT();
            properties.func_74778_a("transmutationEmc", this.emc.toString());
            ListNBT knowledgeWrite = new ListNBT();
            for (ItemInfo i : this.knowledge) {
                knowledgeWrite.add((Object)i.write(new CompoundNBT()));
            }
            properties.func_218657_a("knowledge", (INBT)knowledgeWrite);
            INBT lock = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inputLocks, null);
            if (lock != null) {
                properties.func_218657_a("inputlock", lock);
            }
            properties.func_74757_a("fullknowledge", this.fullKnowledge);
            return properties;
        }

        public void deserializeNBT(CompoundNBT properties) {
            int i;
            String transmutationEmc = properties.func_74779_i("transmutationEmc");
            this.emc = transmutationEmc.isEmpty() ? BigInteger.ZERO : new BigInteger(transmutationEmc);
            ListNBT list = properties.func_150295_c("knowledge", 10);
            for (i = 0; i < list.size(); ++i) {
                ItemInfo info = ItemInfo.read(list.func_150305_b(i));
                if (info == null) continue;
                this.knowledge.add(info);
            }
            this.pruneStaleKnowledge();
            for (i = 0; i < this.inputLocks.getSlots(); ++i) {
                this.inputLocks.setStackInSlot(i, ItemStack.field_190927_a);
            }
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inputLocks, null, (INBT)properties.func_150295_c("inputlock", 10));
            this.fullKnowledge = properties.func_74767_n("fullknowledge");
        }

        private void pruneStaleKnowledge() {
            ArrayList<ItemInfo> toRemove = new ArrayList<ItemInfo>();
            ArrayList<ItemInfo> toAdd = new ArrayList<ItemInfo>();
            for (ItemInfo info : this.knowledge) {
                ItemInfo persistentInfo;
                if (!info.equals(persistentInfo = NBTManager.getPersistentInfo(info))) {
                    toRemove.add(info);
                    if (!EMCHelper.doesItemHaveEmc(persistentInfo)) continue;
                    toAdd.add(persistentInfo);
                    continue;
                }
                if (EMCHelper.doesItemHaveEmc(info)) continue;
                toRemove.add(info);
            }
            this.knowledge.removeAll(toRemove);
            this.knowledge.addAll(toAdd);
        }
    }
}

