/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.impl.capability;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.capability.managing.SerializableCapabilityResolver;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_client.SyncBagDataPKT;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public final class AlchBagImpl {
    public static void init() {
        CapabilityManager.INSTANCE.register(IAlchBagProvider.class, (Capability.IStorage)new Capability.IStorage<IAlchBagProvider>(){

            public CompoundNBT writeNBT(Capability<IAlchBagProvider> capability, IAlchBagProvider instance, Direction side) {
                return (CompoundNBT)instance.serializeNBT();
            }

            public void readNBT(Capability<IAlchBagProvider> capability, IAlchBagProvider instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> new DefaultImpl());
    }

    private AlchBagImpl() {
    }

    public static class Provider
    extends SerializableCapabilityResolver<IAlchBagProvider> {
        public static final ResourceLocation NAME = PECore.rl("alch_bags");

        public Provider() {
            super(new DefaultImpl());
        }

        @Override
        @Nonnull
        public Capability<IAlchBagProvider> getMatchingCapability() {
            return ProjectEAPI.ALCH_BAG_CAPABILITY;
        }
    }

    private static class DefaultImpl
    implements IAlchBagProvider {
        private final Map<DyeColor, IItemHandler> inventories = new EnumMap<DyeColor, IItemHandler>(DyeColor.class);

        private DefaultImpl() {
        }

        @Override
        @Nonnull
        public IItemHandler getBag(@Nonnull DyeColor color) {
            if (!this.inventories.containsKey(color)) {
                this.inventories.put(color, (IItemHandler)new ItemStackHandler(104));
            }
            return this.inventories.get(color);
        }

        @Override
        public void sync(@Nullable DyeColor color, @Nonnull ServerPlayerEntity player) {
            PacketHandler.sendTo(new SyncBagDataPKT(this.writeNBT(color)), player);
        }

        private CompoundNBT writeNBT(DyeColor color) {
            DyeColor[] colors;
            DyeColor[] dyeColorArray;
            CompoundNBT ret = new CompoundNBT();
            if (color == null) {
                dyeColorArray = DyeColor.values();
            } else {
                DyeColor[] dyeColorArray2 = new DyeColor[1];
                dyeColorArray = dyeColorArray2;
                dyeColorArray2[0] = color;
            }
            for (DyeColor c : colors = dyeColorArray) {
                INBT inv;
                if (!this.inventories.containsKey(c) || (inv = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().writeNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.inventories.get(c), null)) == null) continue;
                ret.func_218657_a(c.func_176610_l(), inv);
            }
            return ret;
        }

        public CompoundNBT serializeNBT() {
            return this.writeNBT(null);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            for (DyeColor e : DyeColor.values()) {
                if (!nbt.func_74764_b(e.func_176610_l())) continue;
                ItemStackHandler inv = new ItemStackHandler(104);
                CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.getStorage().readNBT(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)inv, null, nbt.func_74781_a(e.func_176610_l()));
                this.inventories.put(e, (IItemHandler)inv);
            }
        }
    }
}

