/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;

public class TimeWatch
extends PEToggleItem
implements IPedestalItem,
IItemCharge {
    public TimeWatch(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (!ProjectEConfig.server.items.enableTimeWatch.get()) {
                player.func_145747_a((ITextComponent)PELang.TIME_WATCH_DISABLED.translate(new Object[0]), Util.field_240973_b_);
                return ActionResult.func_226251_d_((Object)stack);
            }
            byte current = this.getTimeBoost(stack);
            this.setTimeBoost(stack, (byte)(current == 2 ? 0 : current + 1));
            player.func_145747_a((ITextComponent)PELang.TIME_WATCH_MODE_SWITCH.translate(this.getTimeName(stack)), Util.field_240973_b_);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int invSlot, boolean isHeld) {
        float mobSlowdown;
        int bonusTicks;
        super.func_77663_a(stack, world, entity, invSlot, isHeld);
        if (!(entity instanceof PlayerEntity) || invSlot >= PlayerInventory.func_70451_h() || !ProjectEConfig.server.items.enableTimeWatch.get()) {
            return;
        }
        byte timeControl = this.getTimeBoost(stack);
        if (!world.field_72995_K && world.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
            ServerWorld serverWorld = (ServerWorld)world;
            if (timeControl == 1) {
                serverWorld.func_241114_a_(Math.min(world.func_72820_D() + (long)(this.getCharge(stack) + 1) * 4L, Long.MAX_VALUE));
            } else if (timeControl == 2) {
                long charge = this.getCharge(stack) + 1;
                if (world.func_72820_D() - charge * 4L < 0L) {
                    serverWorld.func_241114_a_(0L);
                } else {
                    serverWorld.func_241114_a_(world.func_72820_D() - charge * 4L);
                }
            }
        }
        if (world.field_72995_K || !ItemHelper.checkItemNBT(stack, "Active")) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        long reqEmc = EMCHelper.removeFractionalEMC(stack, this.getEmcPerTick(this.getCharge(stack)));
        if (!TimeWatch.consumeFuel(player, stack, reqEmc, true)) {
            return;
        }
        int charge = this.getCharge(stack);
        if (charge == 0) {
            bonusTicks = 8;
            mobSlowdown = 0.25f;
        } else if (charge == 1) {
            bonusTicks = 12;
            mobSlowdown = 0.16f;
        } else {
            bonusTicks = 16;
            mobSlowdown = 0.12f;
        }
        AxisAlignedBB bBox = player.func_174813_aQ().func_186662_g(8.0);
        this.speedUpTileEntities(world, bonusTicks, bBox);
        this.speedUpRandomTicks(world, bonusTicks, bBox);
        this.slowMobs(world, bBox, mobSlowdown);
    }

    private void slowMobs(World world, AxisAlignedBB bBox, double mobSlowdown) {
        if (bBox == null) {
            return;
        }
        for (MobEntity ent : world.func_217357_a(MobEntity.class, bBox)) {
            ent.func_213317_d(ent.func_213322_ci().func_216372_d(mobSlowdown, 1.0, mobSlowdown));
        }
    }

    private void speedUpTileEntities(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0) {
            return;
        }
        List<TileEntity> list = WorldHelper.getTileEntitiesWithinAABB(world, bBox);
        for (int i = 0; i < bonusTicks; ++i) {
            for (TileEntity tile : list) {
                if (tile.func_145837_r() || !(tile instanceof ITickableTileEntity) || tile.func_200662_C().isIn(PETags.TileEntities.BLACKLIST_TIME_WATCH)) continue;
                ((ITickableTileEntity)tile).func_73660_a();
            }
        }
    }

    private void speedUpRandomTicks(World world, int bonusTicks, AxisAlignedBB bBox) {
        if (bBox == null || bonusTicks == 0 || !(world instanceof ServerWorld)) {
            return;
        }
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            for (int i = 0; i < bonusTicks; ++i) {
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (!state.func_204519_t() || block.func_203417_a(PETags.Blocks.BLACKLIST_TIME_WATCH) || block instanceof FlowingFluidBlock || block instanceof IGrowable || block instanceof IPlantable) continue;
                state.func_227034_b_((ServerWorld)world, pos.func_185334_h(), field_77697_d);
            }
        }
    }

    private ILangEntry getTimeName(ItemStack stack) {
        byte mode = this.getTimeBoost(stack);
        switch (mode) {
            case 0: {
                return PELang.TIME_WATCH_OFF;
            }
            case 1: {
                return PELang.TIME_WATCH_FAST_FORWARD;
            }
            case 2: {
                return PELang.TIME_WATCH_REWIND;
            }
        }
        return PELang.INVALID_MODE;
    }

    private byte getTimeBoost(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74771_c("TimeMode") : (byte)0;
    }

    private void setTimeBoost(ItemStack stack, byte time) {
        stack.func_196082_o().func_74774_a("TimeMode", (byte)MathHelper.func_76125_a((int)time, (int)0, (int)2));
    }

    public double getEmcPerTick(int charge) {
        return (double)(charge + 2) / 2.0;
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltips, @Nonnull ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltips, flags);
        tooltips.add((ITextComponent)PELang.TOOLTIP_TIME_WATCH_1.translate(new Object[0]));
        tooltips.add((ITextComponent)PELang.TOOLTIP_TIME_WATCH_2.translate(new Object[0]));
        if (stack.func_77942_o()) {
            tooltips.add((ITextComponent)PELang.TIME_WATCH_MODE.translate(this.getTimeName(stack)));
        }
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        DMPedestalTile tile;
        if (!world.field_72995_K && ProjectEConfig.server.items.enableTimeWatch.get() && (tile = WorldHelper.getTileEntity(DMPedestalTile.class, (IBlockReader)world, pos, true)) != null) {
            AxisAlignedBB bBox = tile.getEffectBounds();
            if (ProjectEConfig.server.effects.timePedBonus.get() > 0) {
                this.speedUpTileEntities(world, ProjectEConfig.server.effects.timePedBonus.get(), bBox);
                this.speedUpRandomTicks(world, ProjectEConfig.server.effects.timePedBonus.get(), bBox);
            }
            if (ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
                this.slowMobs(world, bBox, ProjectEConfig.server.effects.timePedMobSlowness.get());
            }
        }
    }

    @Override
    @Nonnull
    public List<ITextComponent> getPedestalDescription() {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (ProjectEConfig.server.effects.timePedBonus.get() > 0) {
            list.add((ITextComponent)PELang.PEDESTAL_TIME_WATCH_1.translateColored(TextFormatting.BLUE, ProjectEConfig.server.effects.timePedBonus.get()));
        }
        if (ProjectEConfig.server.effects.timePedMobSlowness.get() < 1.0) {
            list.add((ITextComponent)PELang.PEDESTAL_TIME_WATCH_2.translateColored(TextFormatting.BLUE, String.format("%.3f", ProjectEConfig.server.effects.timePedMobSlowness.get())));
        }
        return list;
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 2;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getChargePercent(stack);
    }
}

