/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.gameObjs.container.DMFurnaceContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraftforge.items.IItemHandler;

public class RMFurnaceContainer
extends DMFurnaceContainer {
    public RMFurnaceContainer(int windowId, PlayerInventory invPlayer, RMFurnaceTile tile) {
        super(PEContainerTypes.RM_FURNACE_CONTAINER, windowId, invPlayer, tile);
    }

    public static RMFurnaceContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buffer) {
        return new RMFurnaceContainer(windowId, invPlayer, (RMFurnaceTile)GuiHandler.getTeFromBuf(buffer));
    }

    @Override
    void initSlots(PlayerInventory invPlayer) {
        int j;
        int i;
        IItemHandler fuel = this.tile.getFuel();
        IItemHandler input = this.tile.getInput();
        IItemHandler output = this.tile.getOutput();
        this.func_75146_a((Slot)new ValidatedSlot(fuel, 0, 65, 53, SlotPredicates.FURNACE_FUEL));
        this.func_75146_a((Slot)new ValidatedSlot(input, 0, 65, 17, stack -> !this.tile.getSmeltingResult((ItemStack)stack).func_190926_b()));
        int counter = input.getSlots() - 1;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(input, counter--, 11 + i * 18, 8 + j * 18, stack -> !this.tile.getSmeltingResult((ItemStack)stack).func_190926_b()));
            }
        }
        counter = output.getSlots() - 1;
        this.func_75146_a((Slot)new ValidatedSlot(output, counter--, 125, 35, s -> false));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new ValidatedSlot(output, counter--, 147 + i * 18, 8 + j * 18, s -> false));
            }
        }
        ContainerHelper.addPlayerInventory(arg_0 -> ((RMFurnaceContainer)this).func_75146_a(arg_0), (IInventory)invPlayer, 24, 84);
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == PEBlocks.RED_MATTER_FURNACE.getBlock() && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex <= 26) {
            if (!this.func_75135_a(stack, 27, 63, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (AbstractFurnaceTileEntity.func_213991_b((ItemStack)newStack) || newStack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
            if (!this.func_75135_a(stack, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (!this.tile.getSmeltingResult(newStack).func_190926_b()) {
            if (!this.func_75135_a(stack, 1, 14, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return newStack;
    }
}

