/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import javax.annotation.Nonnull;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.utils.ContainerHelper;
import moze_intel.projecte.utils.GuiHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AlchChestContainer
extends Container {
    private final AlchChestTile tile;

    public AlchChestContainer(int windowId, PlayerInventory invPlayer, AlchChestTile tile) {
        super((ContainerType)PEContainerTypes.ALCH_CHEST_CONTAINER.get(), windowId);
        this.tile = tile;
        ++tile.numPlayersUsing;
        IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler(inv, j + i * 13, 12 + j * 18, 5 + i * 18));
            }
        }
        ContainerHelper.addPlayerInventory(arg_0 -> ((AlchChestContainer)this).func_75146_a(arg_0), (IInventory)invPlayer, 48, 152);
    }

    public static AlchChestContainer fromNetwork(int windowId, PlayerInventory invPlayer, PacketBuffer buf) {
        return new AlchChestContainer(windowId, invPlayer, (AlchChestTile)GuiHandler.getTeFromBuf(buf));
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return player.field_70170_p.func_180495_p(this.tile.func_174877_v()).func_177230_c() == PEBlocks.ALCHEMICAL_CHEST.getBlock() && player.func_70092_e((double)this.tile.func_174877_v().func_177958_n() + 0.5, (double)this.tile.func_174877_v().func_177956_o() + 0.5, (double)this.tile.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack newStack = stack.func_77946_l();
        if (slotIndex < 104 ? !this.func_75135_a(stack, 104, this.field_75151_b.size(), false) : !this.func_75135_a(stack, 0, 104, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return newStack;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        super.func_75134_a(player);
        --this.tile.numPlayersUsing;
    }
}

