/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.data.CustomConversionNSSHelper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConversionGroupBuilder
implements CustomConversionNSSHelper<GroupConversionBuilder> {
    private final CustomConversionBuilder customConversionBuilder;
    private final List<GroupConversionBuilder> conversions = new ArrayList<GroupConversionBuilder>();
    @Nullable
    private String comment;

    ConversionGroupBuilder(CustomConversionBuilder customConversionBuilder) {
        this.customConversionBuilder = customConversionBuilder;
    }

    public ConversionGroupBuilder comment(String comment) {
        CustomConversionBuilder.validateComment(this.comment, comment, "Group");
        this.comment = comment;
        return this;
    }

    @Override
    public GroupConversionBuilder conversion(NormalizedSimpleStack output, int amount) {
        if (amount < 1) {
            throw new IllegalArgumentException("Output amount for fixed value conversions must be at least one.");
        }
        GroupConversionBuilder builder = new GroupConversionBuilder(output, amount);
        this.conversions.add(builder);
        return builder;
    }

    public CustomConversionBuilder end() {
        return this.customConversionBuilder;
    }

    boolean hasComment() {
        return this.comment != null;
    }

    JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.comment != null) {
            json.addProperty("comment", this.comment);
        }
        if (!this.conversions.isEmpty()) {
            json.add("conversions", (JsonElement)CustomConversionBuilder.serializeConversions(this.conversions));
        }
        return json;
    }

    public class GroupConversionBuilder
    extends ConversionBuilder<GroupConversionBuilder> {
        private GroupConversionBuilder(NormalizedSimpleStack output, int count) {
            super(output, count);
        }

        public ConversionGroupBuilder end() {
            this.validateIngredients();
            return ConversionGroupBuilder.this;
        }
    }
}

