/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.RsItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class SwitchLinkPearlItem
extends RsItem {
    public SwitchLinkPearlItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int distance;
        SwitchLink link = SwitchLink.fromItemStack(stack);
        if (Auxiliaries.Tooltip.addInformation(stack, (IBlockReader)world, tooltip, flag, !link.valid)) {
            return;
        }
        if (!link.valid) {
            return;
        }
        Block targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(link.block_name));
        if (targetBlock != null) {
            tooltip.add((ITextComponent)Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkedblock", TextFormatting.GRAY, new Object[]{new TranslationTextComponent(targetBlock.func_149739_a()).func_240699_a_(TextFormatting.YELLOW).func_240699_a_(TextFormatting.ITALIC)}));
        }
        if (Minecraft.func_71410_x().field_71439_g != null && (distance = link.distance(Minecraft.func_71410_x().field_71439_g.func_233580_cy_())) >= 0) {
            tooltip.add((ITextComponent)new StringTextComponent(Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.linkeddistance", TextFormatting.GRAY, new Object[]{distance}).getString() + (distance <= ModConfig.max_switch_linking_distance || ModConfig.max_switch_linking_distance <= 0 ? "" : " " + Auxiliaries.localizable("switchlinking.switchlink_pearl.tooltip.toofaraway", TextFormatting.DARK_RED, new Object[0]).getString())));
        }
        tooltip.add((ITextComponent)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(link.mode().index()), TextFormatting.ITALIC, new Object[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.func_201670_d() || !player.func_225608_bj_()) {
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
        }
        SwitchLinkPearlItem.usePearl(world, player);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!selected || !entity.field_70170_p.func_201670_d() || world.func_201674_k().nextDouble() > 0.3) {
            return;
        }
        SwitchLink lnk = SwitchLink.fromItemStack(stack);
        if (!lnk.valid || lnk.target_position.func_177951_i((Vector3i)entity.func_233580_cy_()) > 900.0) {
            return;
        }
        Vector3d p = Vector3d.func_237491_b_((Vector3i)lnk.target_position).func_72441_c((world.func_201674_k().nextDouble() - 0.5) * 0.2, (world.func_201674_k().nextDouble() - 0.5) * 0.2, (world.func_201674_k().nextDouble() - 0.5) * 0.2);
        Vector3d v = new Vector3d(0.0, (world.func_201674_k().nextDouble() - 0.5) * 0.001, 0.0);
        BlockState state = world.func_180495_p(lnk.target_position);
        if (state == null || !(state.func_177230_c() instanceof SwitchLink.ISwitchLinkable)) {
            return;
        }
        p = p.func_178787_e(state.func_196954_c((IBlockReader)world, lnk.target_position).func_197752_a().func_189972_c());
        int power = ((SwitchLink.ISwitchLinkable)state.func_177230_c()).switchLinkOutputPower(world, lnk.target_position).orElse(0);
        if (power > 0) {
            world.func_195590_a((IParticleData)ParticleTypes.field_197590_A, false, p.field_72450_a, p.field_72448_b, p.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c);
        } else {
            world.func_195590_a((IParticleData)ParticleTypes.field_197607_R, false, p.field_72450_a, p.field_72448_b, p.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }
    }

    public static final void usePearl(World world, PlayerEntity player) {
        switch (SwitchLink.fromPlayerActiveItem(world, player).trigger(world, player.func_233580_cy_(), player)) {
            case OK: {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_SUCCESS.play(world, player.func_233580_cy_());
                return;
            }
            case TOO_FAR: {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.switchlink_pearl.use.toofaraway", TextFormatting.DARK_RED, new Object[0]));
                break;
            }
            case TARGET_GONE: {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.switchlink_pearl.use.targetgone", TextFormatting.DARK_RED, new Object[0]));
                break;
            }
        }
        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, player.func_233580_cy_());
    }

    public static final ItemStack createFromPearl(World world, BlockPos pos, PlayerEntity player) {
        ItemStack stack_held = player.field_71071_by.func_70448_g();
        if (stack_held.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack link_pearl = SwitchLinkPearlItem.createForTarget(world, pos);
        if (link_pearl.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        link_pearl.func_77978_p().func_74772_a("cdtime", world.func_82737_E());
        if (stack_held.func_190916_E() > 1) {
            link_pearl.func_190920_e(stack_held.func_190916_E());
        }
        return link_pearl;
    }

    public static final ItemStack createForTarget(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof SwitchLink.ISwitchLinkable)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack((IItemProvider)ModContent.SWITCH_LINK_PEARL);
        SwitchLink.LinkMode mode = (SwitchLink.LinkMode)((Object)((SwitchLink.ISwitchLinkable)state.func_177230_c()).switchLinkGetSupportedTargetModes().get(0));
        stack.func_77982_d(SwitchLink.fromTargetPosition(world, pos).mode(mode).toNbt());
        return stack;
    }

    public static final boolean cycleLinkMode(ItemStack stack, World world, BlockPos target_pos, boolean with_click_time) {
        SwitchLink.ISwitchLinkable target;
        int index;
        ImmutableList<SwitchLink.LinkMode> modes;
        SwitchLink lnk = SwitchLink.fromItemStack(stack);
        if (!target_pos.equals((Object)lnk.target_position)) {
            return false;
        }
        BlockState state = world.func_180495_p(lnk.target_position);
        if (!(state.func_177230_c() instanceof SwitchLink.ISwitchLinkable)) {
            return false;
        }
        long t = world.func_82737_E();
        if (with_click_time) {
            long dt = Math.abs(t - stack.func_77978_p().func_74763_f("cdtime"));
            if (dt < 7L) {
                return true;
            }
            if (dt > 40L) {
                stack.func_77978_p().func_74772_a("cdtime", t);
                return true;
            }
        }
        SwitchLink.LinkMode next = (SwitchLink.LinkMode)((Object)modes.get((index = (modes = (target = (SwitchLink.ISwitchLinkable)state.func_177230_c()).switchLinkGetSupportedTargetModes()).indexOf((Object)lnk.mode()) + 1) < 0 || index >= modes.size() ? 0 : index));
        lnk.mode(next);
        if (!lnk.valid) {
            return false;
        }
        stack.func_77982_d(lnk.toNbt());
        stack.func_77978_p().func_74772_a("cdtime", t);
        return true;
    }
}

