/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import wile.rsgauges.ModConfig;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;
import wile.rsgauges.items.SwitchLinkPearlItem;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class SwitchBlock
extends RsDirectedBlock
implements SwitchLink.ISwitchLinkable {
    public static final long SWITCH_DATA_POWERED_POWER_MASK = 15L;
    public static final long SWITCH_DATA_UNPOWERED_POWER_MASK = 240L;
    public static final long SWITCH_DATA_INVERTED = 256L;
    public static final long SWITCH_DATA_WEAK = 512L;
    public static final long SWITCH_DATA_NOOUTPUT = 1024L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BOTTOM = 4096L;
    public static final long SWITCH_DATA_SIDE_ENABLED_TOP = 8192L;
    public static final long SWITCH_DATA_SIDE_ENABLED_FRONT = 16384L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BACK = 32768L;
    public static final long SWITCH_DATA_SIDE_ENABLED_LEFT = 65536L;
    public static final long SWITCH_DATA_SIDE_ENABLED_RIGHT = 131072L;
    public static final long SWITCH_DATA_SIDE_ENABLED_ALL = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_MASK = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_SHIFT = 12L;
    public static final long SWITCH_DATA_ENTITY_DEFAULTS_MASK = 262143L;
    public static final long SWITCH_CONFIG_INVERTABLE = 0x100000L;
    public static final long SWITCH_CONFIG_WEAKABLE = 0x200000L;
    public static final long SWITCH_CONFIG_PULSETIME_CONFIGURABLE = 0x400000L;
    public static final long SWITCH_CONFIG_TOUCH_CONFIGURABLE = 0x800000L;
    public static final long SWITCH_CONFIG_PULSE_EXTENDABLE = 0x1000000L;
    public static final long SWITCH_CONFIG_LCLICK_RESETTABLE = 0x2000000L;
    public static final long SWITCH_CONFIG_BISTABLE = 0x10000000L;
    public static final long SWITCH_CONFIG_PULSE = 0x20000000L;
    public static final long SWITCH_CONFIG_CONTACT = 0x40000000L;
    public static final long SWITCH_CONFIG_TIMER_DAYTIME = 0x100000000L;
    public static final long SWITCH_CONFIG_TIMER_INTERVAL = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_VOLUME = 0x400000000L;
    public static final long SWITCH_CONFIG_SENSOR_LINEAR = 0x800000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHT = 0x1000000000L;
    public static final long SWITCH_CONFIG_SENSOR_RAIN = 0x2000000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHTNING = 0x4000000000L;
    public static final long SWITCH_CONFIG_SENSOR_BLOCKDETECT = 0x8000000000L;
    public static final long SWITCH_CONFIG_SENSOR_TIME = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_DETECTOR = 0xC00000000L;
    public static final long SWITCH_CONFIG_SENSOR_ENVIRONMENTAL = 0x7100000000L;
    public static final long SWITCH_CONFIG_AUTOMATIC = 0xFF00000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_ON = 0x100000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_OFF = 0x200000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE = 0x300000000000L;
    public static final long SWITCH_CONFIG_SHOCK_SENSITIVE = 0x400000000000L;
    public static final long SWITCH_CONFIG_HIGH_SENSITIVE = 0x800000000000L;
    public static final long SWITCH_CONFIG_TRANSLUCENT = 0x3000000000000000L;
    public static final long SWITCH_CONFIG_NOT_PASSABLE = 0x10000000000000L;
    public static final long SWITCH_CONFIG_SIDES_CONFIGURABLE = 0x40000000000000L;
    public static final long SWITCH_CONFIG_LINK_SOURCE_SUPPORT = 0x100000000000000L;
    public static final long SWITCH_CONFIG_LINK_TARGET_SUPPORT = 0x200000000000000L;
    public static final long SWITCH_CONFIG_LINK_SENDER = 0x400000000000000L;
    public static final long SWITCH_CONFIG_WALLMOUNT = 0x4000000000000000L;
    public static final long SWITCH_CONFIG_LATERAL = Long.MIN_VALUE;
    public static final long SWITCH_CONFIG_LATERAL_WALLMOUNT = -4611686018427387904L;
    public static final int SWITCH_DATA_SVD_ACTIVE_TIME_MASK = 255;
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final int base_tick_rate = 2;
    public static final int default_pulse_on_time = 20;
    public final long config;
    protected final ModResources.BlockSoundEvent power_on_sound;
    protected final ModResources.BlockSoundEvent power_off_sound;

    public SwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered);
        if (powerOnSound == null && powerOffSound == null) {
            powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_ACTIVATION;
            powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_DEACTIVATION;
        } else {
            if (powerOnSound == null) {
                powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
            if (powerOffSound == null) {
                powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
        }
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        if ((config & 0xFFL) == 255L) {
            config &= 0xFFFFFFFFFFFFFF00L;
        } else if ((config & 0xFFL) == 0L) {
            config |= 0xFL;
        }
        if ((config & 0x3F000L) != 0L) {
            config |= 0x40000000000000L;
        }
        this.config = config;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
    }

    @Override
    public RsBlock.RenderTypeHint getRenderTypeHint() {
        return (this.config & 0x3000000000000000L) != 0L ? RsBlock.RenderTypeHint.TRANSLUCENT : RsBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return (this.config & 0x10000000000000L) == 0L ? VoxelShapes.func_197880_a() : this.func_220053_a(state, world, pos, selectionContext);
    }

    public boolean func_149744_f(BlockState state) {
        return (this.config & 0x400000000000000L) == 0L;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return !this.isWallMount() && (side == null || side == Direction.UP || side == state.func_177229_b((Property)FACING));
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, false);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getPower(state, world, pos, side, true);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te != null) {
            te.reset((IWorldReader)world);
        }
        world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        this.notifyNeighbours(world, pos, state, te, true);
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        SwitchTileEntity te;
        if (!newState.func_203425_a((Block)this) && (te = this.getTe((IWorldReader)world, pos)) != null) {
            te.unlinkAllSwitchLinks(true);
            te.nooutput(true);
            this.notifyNeighbours(world, pos, state, te, true);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world.func_201670_d() || (this.config & 0x300000000000L) == 0L || !(entity instanceof ProjectileEntity)) {
            return;
        }
        if ((Boolean)state.func_177229_b((Property)POWERED) != false ? (this.config & 0x200000000000L) == 0L : (this.config & 0x100000000000L) == 0L) {
            return;
        }
        this.onSwitchActivated(world, pos, state, null, null);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return ActionResultType.FAIL;
        }
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        te.click_config(null, false);
        ClickInteraction ck = ClickInteraction.get(state, world, pos, player, hand, hit);
        if (ck.touch_configured && te.touch_config(state, player, ck.x, ck.y)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            return ActionResultType.SUCCESS;
        }
        if (ck.wrenched && te.click_config(this, false)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            Overlay.show(player, (ITextComponent)te.configStatusTextComponentTranslation((SwitchBlock)state.func_177230_c()));
            return ActionResultType.SUCCESS;
        }
        if (!ModConfig.without_rightclick_item_switchconfig && (ck.item == Items.field_151137_ax && (((SwitchBlock)state.func_177230_c()).config & 0x400000L) != 0L || ck.item == Items.field_151079_bi || ck.item == ModContent.SWITCH_LINK_PEARL)) {
            this.func_196270_a(state, world, pos, player);
            return ActionResultType.SUCCESS;
        }
        if ((this.config & 0x30000000L) == 0L) {
            return ActionResultType.SUCCESS;
        }
        return this.onSwitchActivated(world, pos, state, player, hit.func_216354_b()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    @Override
    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return;
        }
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return;
        }
        Item item_held = player.field_71071_by.func_70448_g().func_77973_b();
        ClickInteraction ck = ClickInteraction.get(state, world, pos, player);
        if (ck.wrenched) {
            if (te.click_config(this, false)) {
                Overlay.show(player, (ITextComponent)te.configStatusTextComponentTranslation((SwitchBlock)state.func_177230_c()));
                return;
            }
        } else if (ck.item == Items.field_151137_ax && (((SwitchBlock)state.func_177230_c()).config & 0x400000L) != 0L) {
            if (!ModConfig.without_pulsetime_config) {
                te.configured_on_time(ck.item_count * 2);
                Overlay.show(player, (ITextComponent)te.configStatusTextComponentTranslation((SwitchBlock)state.func_177230_c()));
                return;
            }
        } else if (ck.item == Items.field_151079_bi) {
            if (!ModConfig.without_switch_linking) {
                SwitchBlock block = (SwitchBlock)state.func_177230_c();
                if ((block.config & 0x200000000000000L) == 0L) {
                    Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.target_assign.error_notarget"));
                    ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                } else {
                    ItemStack link_stack = SwitchLinkPearlItem.createFromPearl(world, pos, player);
                    if (link_stack.func_190926_b()) {
                        ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, link_stack);
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.target_assign.ok"));
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_TARGET_SELECTED.play(world, pos);
                    }
                }
            }
        } else if (ck.item == ModContent.SWITCH_LINK_PEARL && item_held == ModContent.SWITCH_LINK_PEARL) {
            if (!ModConfig.without_switch_linking) {
                switch (te.assignSwitchLink(world, pos, player.field_71071_by.func_70448_g())) {
                    case OK: {
                        player.field_71071_by.func_70448_g().func_190918_g(1);
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_SELECTED.play(world, pos);
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.ok"));
                        return;
                    }
                    case E_SELF_ASSIGN: {
                        SwitchLinkPearlItem.cycleLinkMode(player.field_71071_by.func_70448_g(), world, pos, true);
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(SwitchLink.fromItemStack(player.field_71071_by.func_70448_g()).mode().index())));
                        return;
                    }
                    case E_NOSOURCE: {
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.error_nosource"));
                        break;
                    }
                    case E_ALREADY_LINKED: {
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.error_alreadylinked"));
                        break;
                    }
                    case E_TOO_FAR: {
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.error_toofaraway"));
                        break;
                    }
                    case E_FAILED: {
                        Overlay.show(player, (ITextComponent)Auxiliaries.localizable("switchlinking.source_assign.error_failed"));
                    }
                }
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_FAILED.play(world, pos);
            }
            return;
        }
        if (item_held == Items.field_190931_a && te.click_config(this, true)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            Overlay.show(player, (ITextComponent)te.configStatusTextComponentTranslation((SwitchBlock)state.func_177230_c()));
            return;
        }
        if ((this.config & 0x2000000L) != 0L) {
            te.on_timer_reset();
            if (!((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                return;
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
            this.power_off_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L && !te.nooutput()) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.func_201670_d() || !((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return;
        }
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te != null && te.on_time_remaining() > 0) {
            te.reschedule_block_tick();
            return;
        }
        state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
        world.func_180501_a(pos, state, 27);
        this.power_off_sound.play((World)world, pos);
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours((World)world, pos, state, te, false);
        }
        if ((this.config & 0x100000000000000L) != 0L && !te.activateSwitchLinks(0, true)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play((World)world, pos);
        }
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SwitchTileEntity(ModContent.TET_SWITCH);
    }

    public SwitchTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof SwitchTileEntity ? (SwitchTileEntity)te : null;
    }

    @Override
    protected VoxelShape getShape(BlockState state) {
        return this.shapes_[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()][(Boolean)state.func_177229_b((Property)POWERED) != false ? 1 : 0];
    }

    protected void notifyNeighbours(World world, BlockPos pos, BlockState state, @Nullable SwitchTileEntity te, boolean force) {
        if (!force && te != null && te.nooutput()) {
            return;
        }
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)state, EnumSet.allOf(Direction.class), (boolean)false).isCanceled()) {
            return;
        }
        if ((this.config & 0x40000000000000L) != 0L) {
            if (te == null) {
                return;
            }
            long disabled_sides = te.enabled_sides();
            for (Direction facing : Direction.values()) {
                if ((disabled_sides & 1L << this.getAbsoluteFacing(state, facing).func_176745_a() << 12) == 0L || ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (BlockState)state, EnumSet.of(facing), (boolean)false).isCanceled()) continue;
                world.func_190524_a(pos.func_177972_a(facing), (Block)this, pos);
                if (!force && te.weak()) continue;
                world.func_175695_a(pos.func_177972_a(facing), (Block)this, facing.func_176734_d());
            }
        } else if (!this.isLateral() && this.isWallMount()) {
            Direction wall = ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
            }
        } else if (this.isLateral() && !this.isWallMount()) {
            Direction wall = (Direction)state.func_177229_b((Property)FACING);
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            world.func_190524_a(pos.func_177977_b(), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
                world.func_175695_a(pos.func_177977_b(), (Block)this, Direction.UP);
            }
        } else if (this.isLateral() && this.isWallMount()) {
            Direction wall = (Direction)state.func_177229_b((Property)FACING);
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
            }
        } else {
            world.func_195593_d(pos, (Block)this);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177977_b(), (Block)this, Direction.UP);
                world.func_175695_a(pos.func_177984_a(), (Block)this, Direction.DOWN);
                world.func_175695_a(pos.func_177974_f(), (Block)this, Direction.WEST);
                world.func_175695_a(pos.func_177976_e(), (Block)this, Direction.EAST);
                world.func_175695_a(pos.func_177978_c(), (Block)this, Direction.SOUTH);
                world.func_175695_a(pos.func_177968_d(), (Block)this, Direction.NORTH);
            }
        }
    }

    private int getPower(BlockState state, IBlockReader world, BlockPos pos, Direction side, boolean strong) {
        if ((this.config & 0x400000000000000L) != 0L || !(world instanceof World)) {
            return 0;
        }
        if ((this.config & 0x40000000L) != 0L) {
            if (side != ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() && (side != Direction.UP || this.isWallMount())) {
                return 0;
            }
            SwitchTileEntity te = this.getTe((IWorldReader)((World)world), pos);
            return te == null ? 0 : te.power(state, strong);
        }
        if ((this.config & 0x40000000000000L) == 0L) {
            boolean is_main_direction = side == (this.isLateral() ? ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() : (Direction)state.func_177229_b((Property)FACING));
            SwitchTileEntity te = this.getTe((IWorldReader)((World)world), pos);
            if (te == null) {
                return 0;
            }
            if (!is_main_direction && (strong || te.weak())) {
                return 0;
            }
            return te.power(state, strong);
        }
        SwitchTileEntity te = this.getTe((IWorldReader)((World)world), pos);
        if (te == null) {
            return 0;
        }
        return te.power(state, strong);
    }

    protected boolean onSwitchActivated(World world, BlockPos pos, BlockState state, @Nullable PlayerEntity player, @Nullable Direction facing) {
        if (world.func_201670_d()) {
            return true;
        }
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        if (te == null) {
            return true;
        }
        boolean was_powered = (Boolean)state.func_177229_b((Property)POWERED);
        if ((this.config & 0x8010000000L) != 0L) {
            state = (BlockState)state.func_235896_a_((Property)POWERED);
            world.func_180501_a(pos, state, 27);
            if (was_powered) {
                this.power_off_sound.play(world, pos);
            } else {
                this.power_on_sound.play(world, pos);
            }
        } else {
            state = (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true));
            world.func_180501_a(pos, state, 27);
            this.power_on_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
        if ((this.config & 0x20000000L) != 0L) {
            if ((this.config & 0x1000000L) == 0L) {
                te.on_timer_reset();
            }
            te.on_timer_extend();
            te.reschedule_block_tick();
        }
        if ((this.config & 0x100000000000000L) != 0L && (this.config & 0x8030000000L) != 0L) {
            if (!was_powered) {
                if (!te.activateSwitchLinks((Boolean)state.func_177229_b((Property)POWERED) != false ? te.on_power() : 0, was_powered != (Boolean)state.func_177229_b((Property)POWERED))) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            } else if ((this.config & 0x20000000L) == 0L && !te.activateSwitchLinks((Boolean)state.func_177229_b((Property)POWERED) != false ? te.on_power() : 0, was_powered != (Boolean)state.func_177229_b((Property)POWERED))) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean switchLinkHasTargetSupport(World world, BlockPos pos) {
        return (this.config & 0x200000000000000L) != 0L;
    }

    @Override
    public boolean switchLinkHasSourceSupport(World world, BlockPos pos) {
        return (this.config & 0x100000000000000L) != 0L;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(World world, BlockPos pos) {
        return false;
    }

    @Override
    public ImmutableList<SwitchLink.LinkMode> switchLinkGetSupportedTargetModes() {
        if ((this.config & 0x20000000L) != 0L) {
            return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.ACTIVATE), (Object)((Object)SwitchLink.LinkMode.DEACTIVATE), (Object)((Object)SwitchLink.LinkMode.TOGGLE));
        }
        return ImmutableList.of((Object)((Object)SwitchLink.LinkMode.AS_STATE), (Object)((Object)SwitchLink.LinkMode.ACTIVATE), (Object)((Object)SwitchLink.LinkMode.DEACTIVATE), (Object)((Object)SwitchLink.LinkMode.TOGGLE), (Object)((Object)SwitchLink.LinkMode.INV_STATE));
    }

    @Override
    public Optional<Integer> switchLinkOutputPower(World world, BlockPos pos) {
        SwitchTileEntity te = this.getTe((IWorldReader)world, pos);
        return te == null ? Optional.empty() : Optional.of(te.power(world.func_180495_p(pos), false));
    }

    @Override
    public Optional<Integer> switchLinkInputPower(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof SwitchBlock)) {
            return Optional.empty();
        }
        if (((SwitchBlock)state.func_177230_c().getBlock()).isCube()) {
            return Optional.of(world.func_175687_A(pos));
        }
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        return Optional.of(world.func_175651_c(pos.func_177972_a(facing), facing.func_176734_d()));
    }

    @Override
    public Optional<Integer> switchLinkComparatorInput(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof SwitchBlock)) {
            return Optional.empty();
        }
        BlockPos adjacent_pos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
        BlockState adjacent = world.func_180495_p(adjacent_pos);
        if (!adjacent.func_185912_n()) {
            return Optional.empty();
        }
        return Optional.of(adjacent.func_185888_a(world, adjacent_pos));
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        if ((this.config & 0x30000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        SwitchTileEntity te = this.getTe((IWorldReader)link.world, link.target_position);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.TARGET_GONE;
        }
        return this.onSwitchActivated(link.world, link.target_position, link.world.func_180495_p(link.target_position), link.player, null) ? SwitchLink.RequestResult.OK : SwitchLink.RequestResult.REJECTED;
    }

    @Override
    public void switchLinkInit(SwitchLink link) {
        BlockState state;
        if (link.mode() != SwitchLink.LinkMode.AS_STATE && link.mode() != SwitchLink.LinkMode.INV_STATE) {
            return;
        }
        if (link.source_power == 0 == (Boolean)(state = link.world.func_180495_p(link.target_position)).func_177229_b((Property)POWERED)) {
            this.onSwitchActivated(link.world, link.target_position, state, link.player, null);
        }
    }

    @Override
    public void switchLinkUnlink(SwitchLink link) {
    }

    protected static final class ClickInteraction {
        public boolean touch_configured = false;
        public boolean wrenched = false;
        public Item item = Items.field_190931_a;
        public int item_count = 0;
        public int dye = -1;
        public double x = 0.0;
        public double y = 0.0;

        protected ClickInteraction() {
        }

        public String toString() {
            return "{x:" + Double.toString(this.x) + ",y:" + Double.toString(this.y) + ",touch_configured:" + Boolean.toString(this.touch_configured) + ",wrenched:" + Boolean.toString(this.wrenched) + ",item_count:" + Integer.toString(this.item_count) + "}";
        }

        private static ClickInteraction touch(ClickInteraction ck, BlockState state, Direction facing, float x, float y, float z) {
            SwitchBlock block = (SwitchBlock)state.func_177230_c();
            double xo = 0.0;
            double yo = 0.0;
            if (block.isCube() || block.isWallMount() && !block.isLateral()) {
                if (!block.isCube() ? facing != state.func_177229_b((Property)RsDirectedBlock.FACING) : facing != ((Direction)state.func_177229_b((Property)RsDirectedBlock.FACING)).func_176734_d()) {
                    return ck;
                }
                switch (facing.func_176745_a()) {
                    case 0: {
                        xo = 1.0f - x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 1: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = 1.0f - x;
                        yo = y;
                        break;
                    }
                    case 3: {
                        xo = x;
                        yo = y;
                        break;
                    }
                    case 4: {
                        xo = z;
                        yo = y;
                        break;
                    }
                    case 5: {
                        xo = 1.0f - z;
                        yo = y;
                    }
                }
                AxisAlignedBB aa = block.getShape((BlockState)block.func_176223_P().func_206870_a((Property)RsDirectedBlock.FACING, (Comparable)Direction.SOUTH)).func_197752_a();
                xo = Math.round((xo - aa.field_72340_a) * (1.0 / (aa.field_72336_d - aa.field_72340_a)) * 15.5 - 0.25);
                yo = Math.round((yo - aa.field_72338_b) * (1.0 / (aa.field_72337_e - aa.field_72338_b)) * 15.5 - 0.25);
            } else if (block.isLateral()) {
                if (facing != Direction.UP) {
                    return ck;
                }
                facing = (Direction)state.func_177229_b((Property)RsDirectedBlock.FACING);
                switch (facing.func_176745_a()) {
                    case 0: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 1: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 3: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 4: {
                        xo = 1.0f - z;
                        yo = 1.0f - x;
                        break;
                    }
                    case 5: {
                        xo = z;
                        yo = x;
                    }
                }
                AxisAlignedBB aa = block.getShape((BlockState)block.func_176223_P().func_206870_a((Property)RsDirectedBlock.FACING, (Comparable)Direction.NORTH)).func_197752_a();
                xo = 0.1 * (double)Math.round(10.0 * ((xo - aa.field_72340_a) * (1.0 / (aa.field_72336_d - aa.field_72340_a)) * 15.5 - 0.25));
                yo = 0.1 * (double)Math.round(10.0 * ((yo - (1.0 - aa.field_72334_f)) * (1.0 / (aa.field_72334_f - aa.field_72339_c)) * 15.5 - 0.25));
            } else {
                return ck;
            }
            double d = xo > 15.0 ? 15.0 : (ck.x = xo < 0.0 ? 0.0 : xo);
            ck.y = yo > 15.0 ? 15.0 : (yo < 0.0 ? 0.0 : yo);
            ck.touch_configured = true;
            return ck;
        }

        public static ClickInteraction get(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            float x = (float)(hit.func_216347_e().func_82615_a() - Math.floor(hit.func_216347_e().func_82615_a()));
            float y = (float)(hit.func_216347_e().func_82617_b() - Math.floor(hit.func_216347_e().func_82617_b()));
            float z = (float)(hit.func_216347_e().func_82616_c() - Math.floor(hit.func_216347_e().func_82616_c()));
            return ClickInteraction.get(world, pos, state, player, hand, hit.func_216354_b(), x, y, z);
        }

        public static ClickInteraction get(BlockState state, World world, BlockPos pos, PlayerEntity player) {
            return ClickInteraction.get(world, pos, state, player, null, null, 0.0f, 0.0f, 0.0f);
        }

        public static ClickInteraction get(World world, BlockPos pos, @Nullable BlockState state, PlayerEntity player, @Nullable Hand hand, @Nullable Direction facing, float x, float y, float z) {
            ClickInteraction ck = new ClickInteraction();
            if (world == null || pos == null) {
                return ck;
            }
            if (state == null) {
                state = world.func_180495_p(pos);
            }
            if (state == null || !(state.func_177230_c() instanceof SwitchBlock)) {
                return ck;
            }
            SwitchBlock block = (SwitchBlock)state.func_177230_c();
            ItemStack item = player.func_184614_ca();
            if (item == null) {
                return ck;
            }
            if (item.func_77973_b() == Items.field_151137_ax) {
                ck.item = Items.field_151137_ax;
                ck.item_count = item.func_190916_E();
            } else if (item.func_77973_b() == Items.field_151079_bi) {
                ck.item = Items.field_151079_bi;
                ck.item_count = item.func_190916_E();
            } else if (item.func_77973_b() == ModContent.SWITCH_LINK_PEARL) {
                ck.item = ModContent.SWITCH_LINK_PEARL;
                ck.item_count = item.func_190916_E();
            } else if (item.func_77973_b() != Items.field_190931_a) {
                ck.wrenched = ModConfig.isWrench(item);
                if (ck.wrenched) {
                    return ck;
                }
            }
            if (facing != null && (block.config & 0x800000L) != 0L && ck.item != ModContent.SWITCH_LINK_PEARL && ck.item != Items.field_151079_bi) {
                return ClickInteraction.touch(ck, state, facing, x, y, z);
            }
            return ck;
        }
    }

    public static class SwitchTileEntity
    extends RsBlock.RsTileEntity {
        protected static final int max_pulse_time = 200;
        protected long pulse_off_deadline_ = 0L;
        protected int scd_ = 0;
        protected int svd_ = 0;
        protected long click_config_time_lastclicked_ = 0L;
        protected long click_config_last_cycled_ = 0L;
        protected long touch_config_time_lastclicked_ = 0L;
        protected long last_link_request_ = 0L;
        protected ArrayList<SwitchLink> links_ = null;

        public SwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public SwitchTileEntity() {
            super(ModContent.TET_SWITCH);
        }

        @Override
        public void write(CompoundNBT nbt, boolean updatePacket) {
            nbt.func_74768_a("scd", this.scd_);
            nbt.func_74768_a("svd", this.svd_);
            if (updatePacket) {
                return;
            }
            if (this.links_ == null || this.links_.isEmpty()) {
                if (nbt.func_74764_b("links")) {
                    nbt.func_82580_o("links");
                }
            } else {
                ListNBT tl = new ListNBT();
                for (SwitchLink e : this.links_) {
                    tl.add((Object)e.toNbt());
                }
                nbt.func_218657_a("links", (INBT)tl);
            }
        }

        @Override
        public void read(CompoundNBT nbt, boolean updatePacket) {
            int previous_scd = this.scd_;
            int previous_svd = this.svd_;
            this.scd_ = nbt.func_74762_e("scd");
            this.svd_ = nbt.func_74762_e("svd");
            if (!updatePacket) {
                if (this.scd_ == 0) {
                    this.reset(null);
                }
                if (!nbt.func_74764_b("links")) {
                    if (this.links_ != null) {
                        this.links_.clear();
                    }
                } else {
                    ListNBT tl = nbt.func_150295_c("links", (int)nbt.func_74732_a());
                    ArrayList<SwitchLink> links = new ArrayList<SwitchLink>();
                    for (INBT e : tl) {
                        SwitchLink lnk = SwitchLink.fromNbt((CompoundNBT)e);
                        links.add(lnk);
                    }
                    this.links_ = links;
                }
            }
        }

        public int configured_on_time() {
            return (this.svd_ & 0xFF) >> 0;
        }

        public void configured_on_time(int t) {
            this.svd_ = this.svd_ & 0xFFFFFF00 | (t & 0xFF) << 0;
        }

        public int on_power() {
            return (this.scd_ & 0xF) >> 0;
        }

        public int off_power() {
            return (this.scd_ & 0xF0) >> 8;
        }

        public boolean inverted() {
            return (this.scd_ & 0x100) != 0;
        }

        public boolean weak() {
            return (this.scd_ & 0x200) != 0;
        }

        public boolean nooutput() {
            return (this.scd_ & 0x400) != 0;
        }

        public long enabled_sides() {
            return (long)this.scd_ & 0x3F000L;
        }

        public void on_power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFF0 | (p < 0 ? 0 : (p > 15 ? 15 : p) & 0xF) << 0;
        }

        public void off_power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFF0F | (p < 0 ? 0 : (p > 15 ? 15 : p) & 0xF) << 8 & 0xF0;
        }

        public void inverted(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x100) : (this.scd_ &= 0xFFFFFEFF);
        }

        public void weak(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x200) : (this.scd_ &= 0xFFFFFDFF);
        }

        public void nooutput(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x400) : (this.scd_ &= 0xFFFFFBFF);
        }

        public void enabled_sides(long mask) {
            this.scd_ = this.scd_ & 0xFFFC0FFF | (int)(mask & 0x3F000L);
        }

        public void reset(@Nullable IWorldReader world) {
            this.pulse_off_deadline_ = 0L;
            this.click_config_time_lastclicked_ = 0L;
            this.svd_ = 0;
            try {
                int current_scd = this.scd_;
                this.scd_ = world instanceof World && world.isAreaLoaded(this.func_174877_v(), 1) ? (int)(((SwitchBlock)world.func_180495_p((BlockPos)this.func_174877_v()).func_177230_c()).config & 0x3FFFFL) : 15;
            }
            catch (Exception e) {
                this.scd_ = 15;
            }
        }

        public int power(BlockState state, boolean strong) {
            return this.nooutput() ? 0 : (strong && this.weak() ? 0 : (this.inverted() == ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() ? this.off_power() : this.on_power()));
        }

        public void reschedule_block_tick() {
            int t = this.on_time_remaining();
            if (t <= 0) {
                return;
            }
            Block block = this.func_195044_w().func_177230_c();
            if (!this.field_145850_b.func_205220_G_().func_205359_a(this.field_174879_c, (Object)block)) {
                this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)block, t);
            }
        }

        public int on_time_remaining() {
            long dt = Math.max(0L, this.pulse_off_deadline_ - this.field_145850_b.func_82737_E());
            return dt > 200L ? 0 : (int)dt;
        }

        public void on_timer_reset() {
            this.on_timer_reset(0);
        }

        public void on_timer_reset(int preset_ticks) {
            this.pulse_off_deadline_ = this.field_145850_b.func_82737_E() + (long)(Math.min(preset_ticks, 200) > 0 ? preset_ticks : 0);
        }

        public void on_timer_extend() {
            int t = this.on_time_remaining();
            t = this.configured_on_time() >= 2 ? this.configured_on_time() : (t > 90 ? 200 : (t > 45 ? 100 : (t > 15 ? 50 : (t > 1 ? 30 : 20))));
            this.on_timer_reset(t);
        }

        public boolean touch_config(BlockState state, @Nullable PlayerEntity player, double x, double y) {
            long t = this.field_145850_b.func_82737_E();
            boolean show_only = Math.abs(t - this.touch_config_time_lastclicked_) > 40L;
            this.touch_config_time_lastclicked_ = t;
            return this.activation_config(state, player, x, y, show_only);
        }

        protected boolean activation_config(BlockState state, @Nullable PlayerEntity player, double x, double y, boolean show_only) {
            return false;
        }

        public boolean click_config(@Nullable SwitchBlock block, boolean needsDoubleClick) {
            if (block == null) {
                this.click_config_time_lastclicked_ = 0L;
                return false;
            }
            long t = System.currentTimeMillis();
            if (needsDoubleClick) {
                boolean dblclicked = t - this.click_config_time_lastclicked_ > 0L && t - this.click_config_time_lastclicked_ < (long)ModConfig.config_left_click_timeout;
                long l = this.click_config_time_lastclicked_ = dblclicked ? 0L : t;
                if (!dblclicked) {
                    return false;
                }
            }
            boolean multiclicked = t - this.click_config_last_cycled_ > 0L && t - this.click_config_last_cycled_ < 3000L;
            this.click_config_last_cycled_ = t;
            if (!multiclicked) {
                return true;
            }
            if ((block.config & 0x300000L) == 0x300000L) {
                switch ((this.weak() ? 1 : 0) | (this.inverted() ? 2 : 0) | (this.nooutput() ? 4 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 2: {
                        this.weak(true);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 3: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x200000L) != 0L) {
                switch ((this.weak() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x100000L) != 0L) {
                switch ((this.inverted() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                    }
                }
            }
            if ((block.config & 0x200200L) == 512L && !this.weak()) {
                this.weak(true);
            }
            if (ModConfig.without_switch_nooutput || (block.config & 0x400000000000000L) != 0L) {
                this.nooutput(false);
            }
            this.func_70296_d();
            this.field_145850_b.func_195593_d(this.field_174879_c, (Block)block);
            for (Direction f : Direction.values()) {
                this.field_145850_b.func_195593_d(this.field_174879_c.func_177972_a(f), (Block)block);
            }
            return true;
        }

        public TranslationTextComponent configStatusTextComponentTranslation(SwitchBlock block) {
            StringTextComponent separator = new StringTextComponent(" | ");
            separator.func_240699_a_(TextFormatting.GRAY);
            TranslationTextComponent status = Auxiliaries.localizable("switchconfig.options", TextFormatting.RESET, new Object[0]);
            boolean statusset = false;
            if (!(this.on_power() >= 15 && this.off_power() <= 0 || block != null && (block.config & 0x40000FF00000000L) != 0L)) {
                statusset = true;
                status.func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.options.output_power", TextFormatting.RED, new Object[]{this.on_power()}));
            }
            if (this.nooutput()) {
                if (statusset) {
                    status.func_230529_a_((ITextComponent)separator.func_230532_e_());
                }
                statusset = true;
                status.func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.options.no_output", TextFormatting.DARK_AQUA, new Object[0]));
            } else if (!this.inverted()) {
                if (statusset) {
                    status.func_230529_a_((ITextComponent)separator.func_230532_e_());
                }
                statusset = true;
                status.func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.options." + (this.weak() ? "weak" : "strong"), TextFormatting.DARK_AQUA, new Object[0]));
            } else {
                if (statusset) {
                    status.func_230529_a_((ITextComponent)separator.func_230532_e_());
                }
                statusset = true;
                status.func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.options." + (this.weak() ? "weakinverted" : "stronginverted"), TextFormatting.DARK_AQUA, new Object[0]));
            }
            if (this.configured_on_time() > 0) {
                if (statusset) {
                    status.func_230529_a_((ITextComponent)separator.func_230532_e_());
                }
                status.func_230529_a_((ITextComponent)Auxiliaries.localizable("switchconfig.options.pulsetime", TextFormatting.GOLD, new Object[]{Double.toString((double)this.configured_on_time() / 20.0), Integer.toString(this.configured_on_time())}));
            }
            return status;
        }

        public static long linktime() {
            return System.currentTimeMillis();
        }

        public boolean verifySwitchLinkTarget(SwitchLink link) {
            long t = SwitchTileEntity.linktime();
            if (this.field_145850_b.func_201670_d() || this.last_link_request_ == t) {
                return false;
            }
            this.last_link_request_ = t;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state == null || !(state.func_177230_c() instanceof SwitchBlock)) {
                return false;
            }
            return (((SwitchBlock)state.func_177230_c()).config & 0x200000000000000L) != 0L;
        }

        SwitchLinkAssignmentResult assignSwitchLink(World world, BlockPos sourcepos, ItemStack stack) {
            SwitchLink link = SwitchLink.fromItemStack(stack);
            if (!link.valid || !sourcepos.equals((Object)this.func_174877_v())) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            BlockState state = world.func_180495_p(sourcepos);
            if (!(state.func_177230_c() instanceof SwitchBlock)) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            if (link.target_position.equals((Object)sourcepos)) {
                return SwitchLinkAssignmentResult.E_SELF_ASSIGN;
            }
            if ((((SwitchBlock)state.func_177230_c()).config & 0x100000000000000L) == 0L) {
                return SwitchLinkAssignmentResult.E_NOSOURCE;
            }
            if (link.isTooFar(sourcepos)) {
                return SwitchLinkAssignmentResult.E_TOO_FAR;
            }
            if (this.links_ == null) {
                this.links_ = new ArrayList();
            }
            for (SwitchLink lnk : this.links_) {
                if (!lnk.target_position.equals((Object)link.target_position)) continue;
                return SwitchLinkAssignmentResult.E_ALREADY_LINKED;
            }
            this.links_.add(link);
            link.initializeTarget(this.func_145831_w(), this.func_174877_v(), (Boolean)state.func_177229_b((Property)POWERED) != false ? this.on_power() : 0);
            this.func_70296_d();
            return SwitchLinkAssignmentResult.OK;
        }

        public ArrayList<ItemStack> unlinkAllSwitchLinks(boolean drop) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (this.field_145850_b.func_201670_d() || this.links_ == null) {
                return stacks;
            }
            for (SwitchLink switchLink : this.links_) {
                stacks.add(switchLink.toSwitchLinkPearl());
                switchLink.unlinkTarget(this.func_145831_w(), this.func_174877_v());
            }
            this.links_.clear();
            if (drop) {
                for (ItemStack itemStack : stacks) {
                    this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), itemStack));
                }
            }
            return stacks;
        }

        public boolean activateSwitchLinks(int power, boolean state_changed) {
            if (ModConfig.without_switch_linking) {
                return true;
            }
            this.last_link_request_ = SwitchTileEntity.linktime();
            if (this.links_ == null) {
                return true;
            }
            int n_fails = 0;
            block3: for (SwitchLink lnk : this.links_) {
                switch (lnk.trigger(this.field_145850_b, this.field_174879_c, power, state_changed)) {
                    case OK: 
                    case NOT_MATCHED: {
                        continue block3;
                    }
                }
                ++n_fails;
            }
            return n_fails == 0;
        }

        static enum SwitchLinkAssignmentResult {
            OK,
            E_SELF_ASSIGN,
            E_ALREADY_LINKED,
            E_TOO_FAR,
            E_NOSOURCE,
            E_FAILED;

        }
    }
}

