/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import wile.rsgauges.blocks.RsBlock;

public class RsDirectedBlock
extends RsBlock {
    public static final long RSBLOCK_CONFIG_WALLMOUNT = 0x4000000000000000L;
    public static final long RSBLOCK_CONFIG_LATERAL = Long.MIN_VALUE;
    public static final long RSBLOCK_CONFIG_FULLCUBE = 0L;
    public static final long RSBLOCK_CONFIG_OPOSITE_PLACEMENT = 0x800000000000000L;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    protected final VoxelShape[][] shapes_;
    private static final Direction[][] facing_transform_lut = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.UP, Direction.DOWN, Direction.WEST, Direction.EAST}, {Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}};

    public RsDirectedBlock(long config, AbstractBlock.Properties properties, @Nullable AxisAlignedBB aabb1, @Nullable AxisAlignedBB aabb2) {
        super(config | ((config & 0x3000000000000000L) == 0L && (aabb1.func_216364_b() < 0.99 || aabb1.func_216360_c() < 0.99 || aabb1.func_216364_b() < 0.99) ? 0x1000000000000000L : 0L), properties);
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.SOUTH));
        VoxelShape[][] shapes = new VoxelShape[Direction.values().length][2];
        if (aabb1 == null) {
            aabb1 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        if (aabb2 == null) {
            aabb2 = aabb1;
        }
        for (int i_dir = 0; i_dir < Direction.values().length; ++i_dir) {
            for (int i_pow = 0; i_pow < 2; ++i_pow) {
                AxisAlignedBB bb;
                AxisAlignedBB axisAlignedBB = bb = i_pow == 0 ? aabb1 : aabb2;
                if ((config & Long.MIN_VALUE) == 0L) {
                    switch (i_dir) {
                        case 0: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                            break;
                        }
                        case 1: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                            break;
                        }
                        case 2: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                            break;
                        }
                        case 3: {
                            bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                            break;
                        }
                        case 4: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                            break;
                        }
                        case 5: {
                            bb = new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                        }
                    }
                } else {
                    switch (i_dir) {
                        case 0: {
                            bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                            break;
                        }
                        case 1: {
                            bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                            break;
                        }
                        case 2: {
                            bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                            break;
                        }
                        case 3: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                            break;
                        }
                        case 4: {
                            bb = new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                            break;
                        }
                        case 5: {
                            bb = new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                        }
                    }
                }
                shapes[i_dir][i_pow] = VoxelShapes.func_197881_a((AxisAlignedBB)bb);
            }
        }
        this.shapes_ = shapes;
    }

    protected VoxelShape getShape(BlockState state) {
        return this.shapes_[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()][0];
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return this.getShape(state);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isValidPositionOnSide((IWorldReader)context.func_195991_k(), context.func_195995_a(), context.func_196000_l())) {
            return null;
        }
        BlockState state = super.func_196258_a(context);
        if (state == null) {
            return null;
        }
        Direction facing = this.isWallMount() && !this.isLateral() ? context.func_196000_l() : (this.isWallMount() && this.isLateral() ? context.func_196000_l().func_176734_d() : (!this.isWallMount() && this.isLateral() ? context.func_195992_f() : context.func_196010_d()));
        if (this.isOpositePlacement()) {
            facing = facing.func_176734_d();
        }
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing);
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (this.isCube() || !world.func_175623_d(facingPos) && !facingState.func_185904_a().func_76224_d()) {
            return state;
        }
        Direction blockfacing = (Direction)state.func_177229_b((Property)FACING);
        if (!this.isWallMount() && this.isLateral() && facing == Direction.DOWN) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.isWallMount() && !this.isLateral() && facing == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.isWallMount() && this.isLateral() && facing == state.func_177229_b((Property)FACING)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return state;
    }

    public boolean isWallMount() {
        return (this.config & 0x4000000000000000L) != 0L;
    }

    public boolean isLateral() {
        return (this.config & Long.MIN_VALUE) != 0L;
    }

    public boolean isCube() {
        return (this.config & 0xC000000000000000L) == 0L;
    }

    public boolean isOpositePlacement() {
        return (this.config & 0x800000000000000L) != 0L;
    }

    protected boolean isAffectedByNeigbour(BlockState state, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (this.isCube()) {
            return true;
        }
        if (!this.isWallMount() && !pos.func_177977_b().equals((Object)neighborPos)) {
            return false;
        }
        if (!this.isLateral() && !pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()).equals((Object)neighborPos)) {
            return false;
        }
        if (!pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()).equals((Object)neighborPos)) {
            return false;
        }
        BlockState neighborState = world.func_180495_p(neighborPos);
        if (neighborState == null) {
            return false;
        }
        return !world.func_175623_d(neighborPos) && !neighborState.func_185904_a().func_76224_d();
    }

    protected Direction getAbsoluteFacing(BlockState state, Direction relativeSide) {
        return state == null || relativeSide == null ? Direction.NORTH : facing_transform_lut[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()][relativeSide.func_176745_a()];
    }

    protected boolean isValidPositionOnSide(IWorldReader world, BlockPos pos, Direction side) {
        if (this.isCube()) {
            return true;
        }
        if (this.isLateral() && !this.isWallMount()) {
            if (side != Direction.UP) {
                return false;
            }
            return Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
        }
        if (this.isWallMount()) {
            if (this.isLateral() && (side == Direction.UP || side == Direction.DOWN)) {
                return false;
            }
            BlockPos blockpos = pos.func_177972_a(side.func_176734_d());
            BlockState blockState = world.func_180495_p(blockpos);
        }
        return true;
    }
}

