/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import wile.rsgauges.blocks.IntervalTimerSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.detail.SwitchLink;

public abstract class AutoSwitchBlock
extends SwitchBlock {
    public AutoSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public AutoSwitchBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered) {
        this(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
    }

    @Override
    public SwitchLink.RequestResult switchLinkTrigger(SwitchLink link) {
        if ((this.config & 0x200000000000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        if ((this.config & 0x200000000L) == 0L) {
            return SwitchLink.RequestResult.REJECTED;
        }
        BlockState state = link.world.func_180495_p(link.target_position);
        if (state == null || !(state.func_177230_c() instanceof AutoSwitchBlock)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        AutoSwitchTileEntity te = this.getTe((IWorldReader)link.world, link.target_position);
        if (te == null || !te.verifySwitchLinkTarget(link)) {
            return SwitchLink.RequestResult.REJECTED;
        }
        te.updateSwitchState(state, this, (Boolean)state.func_177229_b((Property)POWERED) == false, 0);
        return SwitchLink.RequestResult.OK;
    }

    @Override
    public AutoSwitchTileEntity getTe(IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof AutoSwitchTileEntity)) {
            return null;
        }
        return (AutoSwitchTileEntity)te;
    }

    public static abstract class AutoSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        public AutoSwitchTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        protected final void updateSwitchState(BlockState state, AutoSwitchBlock block, boolean active, int hold_time) {
            this.updateSwitchState(state, block, active, hold_time, true);
        }

        protected final void updateSwitchState(BlockState state, AutoSwitchBlock block, boolean active, int hold_time, boolean link_update) {
            if (active) {
                this.on_timer_reset(hold_time);
                if (!((Boolean)state.func_177229_b((Property)SwitchBlock.POWERED)).booleanValue()) {
                    if (this instanceof IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity) {
                        ((IntervalTimerSwitchBlock.IntervalTimerSwitchTileEntity)this).restart();
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SwitchBlock.POWERED, (Comparable)Boolean.valueOf(true)), 27);
                    block.power_on_sound.play(this.field_145850_b, this.field_174879_c);
                    this.field_145850_b.func_195593_d(this.field_174879_c, (Block)block);
                    BlockPos np = this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((Property)RsDirectedBlock.FACING)).func_176734_d());
                    Block nb = this.field_145850_b.func_180495_p(np).func_177230_c();
                    this.field_145850_b.func_195593_d(np, nb);
                    if (link_update && (block.config & 0x100000000000000L) != 0L && !this.activateSwitchLinks(this.on_power(), true)) {
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                    }
                }
            } else if (((Boolean)state.func_177229_b((Property)SwitchBlock.POWERED)).booleanValue() && (hold_time <= 0 || this.on_time_remaining() <= 0)) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SwitchBlock.POWERED, (Comparable)Boolean.valueOf(false)), 27);
                block.power_off_sound.play(this.field_145850_b, this.field_174879_c);
                this.field_145850_b.func_195593_d(this.field_174879_c, (Block)block);
                BlockPos np = this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((Property)RsDirectedBlock.FACING)).func_176734_d());
                Block nb = this.field_145850_b.func_180495_p(np).func_177230_c();
                this.field_145850_b.func_195593_d(np, nb);
                if (link_update && (block.config & 0x100000000000000L) != 0L && !this.activateSwitchLinks(0, true)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(this.field_145850_b, this.field_174879_c);
                }
            }
        }
    }
}

