/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class PropertyCountLootFunction
extends LootFunction {
    public static final ResourceLocation ID = new ResourceLocation("immersiveengineering", "property_count");
    private final String propertyName;

    protected PropertyCountLootFunction(ILootCondition[] conditionsIn, String propertyName) {
        super(conditionsIn);
        this.propertyName = propertyName;
    }

    @Nonnull
    protected ItemStack func_215859_a(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockState blockstate = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (blockstate != null) {
            stack.func_190920_e(this.getPropertyValue(blockstate));
        }
        return stack;
    }

    private int getPropertyValue(BlockState blockState) {
        for (Property prop : blockState.func_235904_r_()) {
            if (!(prop instanceof IntegerProperty) || !prop.func_177701_a().equals(this.propertyName)) continue;
            return (Integer)blockState.func_177229_b((Property)((IntegerProperty)prop));
        }
        return 1;
    }

    public LootFunctionType func_230425_b_() {
        return IELootFunctions.propertyCount;
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final String propertyName;

        public Builder(String propertyName) {
            this.propertyName = propertyName;
        }

        @Nonnull
        protected Builder doCast() {
            return this;
        }

        @Nonnull
        public ILootFunction func_216052_b() {
            return new PropertyCountLootFunction(this.func_216053_g(), this.propertyName);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<PropertyCountLootFunction> {
        private static final String JSON_KEY = "propery_name";

        public void serialize(JsonObject object, PropertyCountLootFunction function, JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)function, context);
            object.addProperty(JSON_KEY, function.propertyName);
        }

        @Nonnull
        public PropertyCountLootFunction deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull ILootCondition[] conditionsIn) {
            return new PropertyCountLootFunction(conditionsIn, JSONUtils.func_151200_h((JsonObject)object, (String)JSON_KEY));
        }
    }
}

