/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnInterdictionHandler {
    private static final Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set<IEBlockInterfaces.ISpawnInterdiction> dimSet = interdictionTiles.get(event.getEntity().field_70170_p.func_234923_W_());
                if (dimSet != null) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = dimSet.iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (interdictor instanceof TileEntity) {
                            if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                                it.remove();
                                continue;
                            }
                            if (!(Vector3d.func_237491_b_((Vector3i)((TileEntity)interdictor).func_174877_v()).func_72436_e(event.getEntity().func_213303_ch()) <= interdictor.getInterdictionRangeSquared())) continue;
                            event.setCanceled(true);
                            continue;
                        }
                        if (!(interdictor instanceof Entity)) continue;
                        if (!((Entity)interdictor).func_70089_S() || ((Entity)interdictor).field_70170_p == null) {
                            it.remove();
                            continue;
                        }
                        if (!(((Entity)interdictor).func_70068_e(event.getEntity()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setCanceled(true);
                    }
                }
            }
        }
        if (event.getEntityLiving().func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.isSpawner()) {
            return;
        }
        if (event.getEntityLiving().func_200600_R().func_220339_d() == EntityClassification.MONSTER) {
            Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                RegistryKey dimension = event.getEntity().field_70170_p.func_234923_W_();
                if (interdictionTiles.containsKey(dimension)) {
                    Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
                    while (it.hasNext()) {
                        IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                        if (!(interdictor instanceof TileEntity)) continue;
                        if (((TileEntity)interdictor).func_145837_r() || ((TileEntity)interdictor).func_145831_w() == null) {
                            it.remove();
                            continue;
                        }
                        if (!(Vector3d.func_237491_b_((Vector3i)((TileEntity)interdictor).func_174877_v()).func_72436_e(event.getEntity().func_213303_ch()) <= interdictor.getInterdictionRangeSquared())) continue;
                        event.setResult(Event.Result.DENY);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void removeFromInterdictionTiles(T tile) {
        Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            Set<IEBlockInterfaces.ISpawnInterdiction> inDimension = interdictionTiles.get(tile.func_145831_w().func_234923_W_());
            if (inDimension != null) {
                inDimension.remove(tile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void addInterdictionTile(T tile) {
        World world = tile.func_145831_w();
        if (world != null && ((Boolean)IEServerConfig.MACHINES.floodlight_spawnPrevent.get()).booleanValue()) {
            Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set forDim = interdictionTiles.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), x -> new HashSet());
                forDim.add(tile);
            }
        }
    }
}

