/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.entities.SawbladeEntity;
import blusunrize.immersiveengineering.common.items.IEItems;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class RailgunProjectiles {
    public static void register() {
        RailgunHandler.registerStandardProjectile(IETags.ironRod, 16.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.aluminumRod, 10.0, 1.05).setColorMap(new RailgunHandler.RailgunRenderColors(0xD8D8D8, 0xD8D8D8, 0xD8D8D8, 0xA8A8A8, 0x686868, 0x686868));
        RailgunHandler.registerStandardProjectile(IETags.steelRod, 24.0, 1.25).setColorMap(new RailgunHandler.RailgunRenderColors(0xB4B4B4, 0xB4B4B4, 0xB4B4B4, 0x7A7A7A, 0x555555, 0x555555));
        RailgunHandler.registerStandardProjectile(new ItemStack((IItemProvider)IEItems.Misc.graphiteElectrode), 30.0, 0.9).setColorMap(new RailgunHandler.RailgunRenderColors(0x242424, 0x242424, 0x242424, 0x171717, 0x171717, 657930));
        RailgunHandler.registerProjectile(() -> Ingredient.func_199805_a((ITag)Tags.Items.RODS_BLAZE), new RailgunHandler.StandardRailgunProjectile(10.0, 1.05){

            @Override
            public void onHitTarget(World world, RayTraceResult target, @Nullable UUID shooter, Entity projectile) {
                if (target instanceof EntityRayTraceResult) {
                    ((EntityRayTraceResult)target).func_216348_a().func_70015_d(5);
                }
            }

            @Override
            public double getBreakChance(@Nullable UUID shooter, ItemStack ammo) {
                return 1.0;
            }
        }.setColorMap(new RailgunHandler.RailgunRenderColors(16773933, 16761088, 11758361, 12540416, 12540416, 9777920)));
        RailgunHandler.registerProjectile(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{IEItems.Tools.sawblade}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack ammo, Entity defaultProjectile) {
                Vector3d look = shooter.func_70040_Z();
                return new SawbladeEntity(shooter.func_130014_f_(), (LivingEntity)shooter, look.field_72450_a * 20.0, look.field_72448_b * 20.0, look.field_72449_c * 20.0, ammo);
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_203184_eO}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    ammo.func_222118_a(1, (LivingEntity)shooter, p_220047_1_ -> p_220047_1_.func_213334_d(shooter.func_184600_cs()));
                    TridentEntity trident = new TridentEntity(shooter.field_70170_p, (LivingEntity)shooter, ammo);
                    trident.func_234612_a_((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 2.5f, 1.0f);
                    if (shooter.field_71075_bZ.field_75098_d) {
                        trident.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                    }
                    return trident;
                }
                return defaultProjectile;
            }
        });
        RailgunHandler.registerProjectile(() -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151079_bi}), new RailgunHandler.IRailgunProjectile(){

            @Override
            public boolean isValidForTurret() {
                return false;
            }

            @Override
            public Entity getProjectile(@Nullable PlayerEntity shooter, ItemStack ammo, Entity defaultProjectile) {
                if (shooter != null) {
                    EnderPearlEntity pearl = new EnderPearlEntity(shooter.field_70170_p, (LivingEntity)shooter);
                    pearl.func_213884_b(ammo);
                    pearl.func_234612_a_((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 2.5f, 1.0f);
                    return pearl;
                }
                return defaultProjectile;
            }
        });
    }
}

