/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.CapabilityReference;
import blusunrize.immersiveengineering.common.util.DirectionUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ThermoelectricGenTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxConnector {
    private int energyOutput = -1;
    private Map<Direction, CapabilityReference<IEnergyStorage>> energyWrappers = new EnumMap<Direction, CapabilityReference<IEnergyStorage>>(Direction.class);
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, null);

    public ThermoelectricGenTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.THERMOELECTRIC_GEN.get()));
        for (Direction d : DirectionUtils.VALUES) {
            this.energyWrappers.put(d, CapabilityReference.forNeighbor((TileEntity)this, CapabilityEnergy.ENERGY, d));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 1024L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x3FF)) {
                this.recalculateEnergyOutput();
            }
            if (this.energyOutput > 0) {
                this.outputEnergy(this.energyOutput);
            }
        }
    }

    public void outputEnergy(int amount) {
        for (Direction fd : DirectionUtils.VALUES) {
            IEnergyStorage forSide = this.energyWrappers.get(fd).getNullable();
            if (forSide == null) continue;
            amount -= forSide.receiveEnergy(amount, false);
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        super.onNeighborBlockChange(pos);
        this.recalculateEnergyOutput();
    }

    private void recalculateEnergyOutput() {
        int energy = 0;
        for (Direction fd : new Direction[]{Direction.DOWN, Direction.NORTH, Direction.WEST}) {
            if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd)) || this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(fd.func_176734_d()))) continue;
            int temp0 = this.getTemperature(this.func_174877_v().func_177972_a(fd));
            int temp1 = this.getTemperature(this.func_174877_v().func_177972_a(fd.func_176734_d()));
            if (temp0 <= -1 || temp1 <= -1) continue;
            int diff = Math.abs(temp0 - temp1);
            energy += (int)(Math.sqrt(diff) / 2.0 * (Double)IEServerConfig.MACHINES.thermoelectric_output.get());
        }
        this.energyOutput = energy == 0 ? -1 : energy;
    }

    private int getTemperature(BlockPos pos) {
        Fluid f = this.getFluid(pos);
        if (f != Fluids.field_204541_a) {
            return f.getAttributes().getTemperature((IBlockDisplayReader)this.field_145850_b, pos);
        }
        BlockState state = this.field_145850_b.func_180495_p(pos);
        return ThermoelectricHandler.getTemperature(state.func_177230_c());
    }

    @Nullable
    Fluid getFluid(BlockPos pos) {
        BlockState state = this.field_145850_b.func_180495_p(pos);
        FluidState fState = state.func_204520_s();
        return fState.func_206886_c();
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyOutput = nbt.func_74762_e("enegyOutput");
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("enegyOutput", this.energyOutput);
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(@Nullable Direction facing) {
        return IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public boolean canConnectEnergy(Direction from) {
        return true;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        return this.wrapper;
    }
}

