/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SampleDrillTileEntity
extends IEBaseTileEntity
implements ITickableTileEntity,
EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IModelOffsetProvider {
    public FluxStorage energyStorage = new FluxStorage(8000);
    public int dummy = 0;
    public int process = 0;
    public boolean active = false;
    @Nonnull
    public ItemStack sample = ItemStack.field_190927_a;
    @OnlyIn(value=Dist.CLIENT)
    private AxisAlignedBB renderAABB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = new EnergyHelper.IEForgeEnergyWrapper[]{new EnergyHelper.IEForgeEnergyWrapper(this, Direction.NORTH), new EnergyHelper.IEForgeEnergyWrapper(this, Direction.SOUTH), new EnergyHelper.IEForgeEnergyWrapper(this, Direction.WEST), new EnergyHelper.IEForgeEnergyWrapper(this, Direction.EAST)};

    public SampleDrillTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.SAMPLE_DRILL.get()));
    }

    public static boolean _Immovable() {
        return true;
    }

    public void func_73660_a() {
        this.checkForNeedlessTicking();
        if (this.dummy != 0 || this.field_145850_b.func_175623_d(this.func_174877_v().func_177982_a(0, -1, 0)) || !this.sample.func_190926_b()) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.active) {
            ++this.process;
            return;
        }
        boolean powered = this.isRSPowered();
        boolean hasEnergy = this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.coredrill_consumption.get();
        boolean prevActive = this.active;
        int totalTime = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        int consumption = (Integer)IEServerConfig.MACHINES.coredrill_consumption.get();
        if (!this.active && powered && hasEnergy) {
            this.active = true;
        } else if (this.active && !powered && this.process >= totalTime) {
            this.active = false;
        }
        if (this.active && this.process < totalTime && this.energyStorage.extractEnergy(consumption, false) == consumption) {
            ++this.process;
            if (this.process >= totalTime) {
                MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.field_145850_b, this.func_174877_v());
                this.sample = this.createCoreSample(info);
            }
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        if (prevActive != this.active) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)((Integer)IEServerConfig.MACHINES.coredrill_time.get()).intValue();
    }

    public boolean isSamplingFinished() {
        return this.process >= (Integer)IEServerConfig.MACHINES.coredrill_time.get();
    }

    @Nullable
    public MineralMix[] getVein() {
        if (this.sample.func_190926_b()) {
            return null;
        }
        return CoresampleItem.getMineralMixes(this.sample);
    }

    public int getExpectedVeinYield() {
        if (this.sample.func_190926_b()) {
            return -1;
        }
        return ExcavatorHandler.mineralVeinYield - this.sample.func_196082_o().func_74762_e("depletion");
    }

    @Nonnull
    public ItemStack createCoreSample(@Nullable MineralWorldInfo info) {
        ItemStack stack = new ItemStack((IItemProvider)IEItems.Misc.coresample);
        ItemNBTHelper.putLong(stack, "timestamp", this.field_145850_b.func_82737_E());
        CoresampleItem.setDimension(stack, (RegistryKey<World>)this.field_145850_b.func_234923_W_());
        CoresampleItem.setCoords(stack, this.func_174877_v());
        CoresampleItem.setMineralInfo(stack, info, this.func_174877_v());
        return stack;
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74768_a("process", this.process);
        nbt.func_74757_a("active", this.active);
        if (!this.sample.func_190926_b()) {
            nbt.func_218657_a("sample", (INBT)this.sample.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.dummy = nbt.func_74762_e("dummy");
        this.process = nbt.func_74762_e("process");
        this.active = nbt.func_74767_n("active");
        if (nbt.func_150297_b("sample", 10)) {
            this.sample = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("sample"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.dummy == 0 ? new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 3, 1)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy > 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof SampleDrillTileEntity) {
            return ((SampleDrillTileEntity)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.dummy == 0 && facing != null && facing.func_176740_k() != Direction.Axis.Y ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (this.dummy == 0 && facing != null && facing.func_176740_k() != Direction.Axis.Y) {
            return this.wrappers[facing.ordinal() - 2];
        }
        return null;
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.func_174877_v().func_177979_c(this.dummy);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, i, 0), state);
            ((SampleDrillTileEntity)this.field_145850_b.func_175625_s((BlockPos)this.field_174879_c.func_177982_a((int)0, (int)i, (int)0))).dummy = i;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0)) instanceof SampleDrillTileEntity)) continue;
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0), false);
        }
    }

    @Override
    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (this.dummy != 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof SampleDrillTileEntity) {
            return ((SampleDrillTileEntity)te).interact(side, player, hand, heldItem, hitX, hitY, hitZ);
        }
        if (!this.sample.func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_70099_a(this.sample.func_77946_l(), 0.5f);
            }
            this.sample = ItemStack.field_190927_a;
            this.active = false;
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (!this.active) {
            if (this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.coredrill_consumption.get()) {
                this.active = true;
                this.func_70296_d();
                this.markContainingBlockForUpdate(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

