/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBaseTileEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class BlastFurnacePreheaterTileEntity
extends IEBaseTileEntity
implements EnergyHelper.IIEInternalFluxHandler,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IModelOffsetProvider {
    public boolean active;
    public int dummy = 0;
    public FluxStorage energyStorage = new FluxStorage(8000);
    public float angle = 0.0f;
    public long lastRenderTick = -1L;
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper(this, Direction.UP);

    public BlastFurnacePreheaterTileEntity() {
        super((TileEntityType<? extends TileEntity>)((TileEntityType)IETileTypes.BLASTFURNACE_PREHEATER.get()));
    }

    public int doSpeedup() {
        int consumed = (Integer)IEServerConfig.MACHINES.preheater_consumption.get();
        if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
            if (!this.active) {
                this.active = true;
                this.markContainingBlockForUpdate(null);
            }
            this.energyStorage.extractEnergy(consumed, false);
            return 1;
        }
        if (this.active) {
            this.active = false;
            this.markContainingBlockForUpdate(null);
        }
        return 0;
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        BlockPos masterPos = this.func_174877_v().func_177979_c(this.dummy);
        TileEntity te = Utils.getExistingTileEntity(this.field_145850_b, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockItemUseContext ctx, BlockState state) {
        state = (BlockState)state.func_206870_a((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(0, i, 0), state);
            ((BlastFurnacePreheaterTileEntity)this.field_145850_b.func_175625_s((BlockPos)this.field_174879_c.func_177982_a((int)0, (int)i, (int)0))).dummy = i;
            ((BlastFurnacePreheaterTileEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, i, 0))).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0)) instanceof BlastFurnacePreheaterTileEntity)) continue;
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(0, -this.dummy, 0).func_177982_a(0, i, 0), false);
        }
    }

    @Override
    public void readCustomNBT(CompoundNBT nbt, boolean descPacket) {
        this.dummy = nbt.func_74762_e("dummy");
        this.energyStorage.readFromNBT(nbt);
        this.active = nbt.func_74767_n("active");
        if (descPacket) {
            this.markContainingBlockForUpdate(null);
        }
    }

    @Override
    public void writeCustomNBT(CompoundNBT nbt, boolean descPacket) {
        nbt.func_74768_a("dummy", this.dummy);
        nbt.func_74757_a("active", this.active);
        this.energyStorage.writeToNBT(nbt);
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy > 0 && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy, 0))) instanceof BlastFurnacePreheaterTileEntity) {
            return ((BlastFurnacePreheaterTileEntity)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return this.dummy == 2 && facing == Direction.UP ? IEEnums.IOSideConfig.INPUT : IEEnums.IOSideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (this.dummy == 2 && facing == Direction.UP) {
            return this.wrapper;
        }
        return null;
    }

    @Override
    public EnumProperty<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return true;
    }

    @Override
    public boolean canRotate(Direction axis) {
        return true;
    }

    @Override
    public void afterRotation(Direction oldDir, Direction newDir) {
        for (int i = 0; i <= 2; ++i) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(0, -this.dummy + i, 0));
            if (!(te instanceof BlastFurnacePreheaterTileEntity)) continue;
            ((BlastFurnacePreheaterTileEntity)te).setFacing(newDir);
            te.func_70296_d();
            ((BlastFurnacePreheaterTileEntity)te).markContainingBlockForUpdate(null);
        }
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vector3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

