/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheTileEntity;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ClocheRenderer
extends TileEntityRenderer<ClocheTileEntity> {
    private static HashMap<BlockState, List<BakedQuad>> plantQuads = new HashMap();

    public ClocheRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(ClocheTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tile.dummy != 0 || !tile.getWorldNonnull().func_175667_e(tile.func_174877_v())) {
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = tile.func_174877_v();
        matrixStack.func_227860_a_();
        ClocheRecipe recipe = tile.getRecipe();
        if (recipe != null) {
            IVertexBuilder baseBuilder = bufferIn.getBuffer(RenderType.func_228643_e_());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 1.0625, 0.0);
            NonNullList<ItemStack> inventory = tile.getInventory();
            ItemStack seed = (ItemStack)inventory.get(1);
            float growth = MathHelper.func_76131_a((float)(tile.renderGrowth / (float)recipe.time), (float)0.0f, (float)1.0f);
            float scale = recipe.renderFunction.getScale(seed, growth);
            matrixStack.func_227861_a_((double)((1.0f - scale) / 2.0f), 0.0, (double)((1.0f - scale) / 2.0f));
            matrixStack.func_227862_a_(scale, scale, scale);
            Collection<Pair<BlockState, TransformationMatrix>> blocks = recipe.renderFunction.getBlocks(seed, growth);
            for (Pair<BlockState, TransformationMatrix> block : blocks) {
                BlockState state = (BlockState)block.getLeft();
                List<BakedQuad> plantQuadList = plantQuads.get(state);
                if (plantQuadList == null) {
                    IBakedModel plantModel = blockRenderer.func_184389_a(state);
                    plantQuadList = new ArrayList<BakedQuad>(plantModel.getQuads(state, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
                    for (Direction f : Direction.values()) {
                        plantQuadList.addAll(plantModel.getQuads(state, f, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
                    }
                    plantQuads.put(state, plantQuadList);
                }
                int col = ClientUtils.mc().func_184125_al().func_228054_a_(state, null, blockPos, -1);
                ((TransformationMatrix)block.getRight()).push(matrixStack);
                ClientUtils.renderModelTESRFancy(plantQuadList, new TransformingVertexBuilder(baseBuilder, matrixStack), tile.getWorldNonnull(), blockPos, false, col, combinedLightIn);
                matrixStack.func_227865_b_();
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    public static void reset() {
        plantQuads.clear();
    }
}

