/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.mixin.accessors.client.RenderTypeAccess;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class RenderCacheKey {
    private final BlockState state;
    private final RenderType layer;
    private final Object[] additionalProperties;

    public RenderCacheKey(BlockState state, RenderType l, Object ... additional) {
        this.state = state;
        this.layer = l;
        this.additionalProperties = additional;
    }

    public RenderCacheKey(BlockState state, RenderType l, RenderCacheKey baseKey, IModelData data, ImmutableList<Object> additional, ModelProperty<?> ... toSave) {
        this(state, l, additional, RenderCacheKey.getAllProperties(baseKey, data, toSave));
    }

    public RenderCacheKey(BlockState state, RenderType l, IModelData data, ImmutableList<Object> additional, ModelProperty<?> ... toSave) {
        this(state, l, null, data, additional, toSave);
    }

    private static Object[] getAllProperties(RenderCacheKey base, IModelData data, ModelProperty<?>[] toSave) {
        Object[] ret = Arrays.copyOf(base.additionalProperties, toSave.length + base.additionalProperties.length);
        for (int i = 0; i < toSave.length; ++i) {
            ret[i + base.additionalProperties.length] = data.getData(toSave[i]);
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RenderCacheKey)) {
            return false;
        }
        RenderCacheKey o = (RenderCacheKey)obj;
        if (o.layer != this.layer) {
            return false;
        }
        if (!Utils.areArraysEqualIncludingBlockstates(this.additionalProperties, o.additionalProperties)) {
            return false;
        }
        return this.state.equals(o.state);
    }

    public int hashCode() {
        int val = this.layer == null ? 0 : ((RenderTypeAccess)this.layer).getName().hashCode();
        int prime = 31;
        val = 31 * val + Utils.hashBlockstate(this.state);
        val = 31 * val + Arrays.hashCode(this.additionalProperties);
        return val;
    }
}

