/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.models.connection.RenderCacheKey;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.mixin.accessors.client.RenderTypeAccess;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class BakedConnectionModel
extends BakedIEModel {
    Lazy<TextureAtlasSprite> textureAtlasSprite = Lazy.of(() -> Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(new ResourceLocation("immersiveengineering", "block/wire")));
    public static final Cache<ModelKey, SpecificConnectionModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    @Nullable
    private final IBakedModel base;
    private final ImmutableSet<String> layers;

    public BakedConnectionModel(@Nullable IBakedModel basic, Collection<String> layers) {
        this.base = basic;
        this.layers = ImmutableSet.copyOf(layers);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null && extraData.hasProperty(IEProperties.Model.CONNECTIONS)) {
            TileEntity te;
            Object[] additional = null;
            if (extraData.hasProperty(IEProperties.Model.TILEENTITY_PASSTHROUGH) && (te = (TileEntity)extraData.getData(IEProperties.Model.TILEENTITY_PASSTHROUGH)) instanceof IEBlockInterfaces.ICacheData) {
                additional = ((IEBlockInterfaces.ICacheData)te).getCacheData();
            }
            RenderCacheKey ad = new RenderCacheKey(state, null, additional);
            HashSet<Connection.RenderData> data = new HashSet<Connection.RenderData>();
            IEProperties.ConnectionModelData orig = (IEProperties.ConnectionModelData)extraData.getData(IEProperties.Model.CONNECTIONS);
            assert (orig != null);
            for (Connection c : orig.connections) {
                ConnectionPoint here = c.getEndFor(orig.here);
                data.add(new Connection.RenderData(c, c.getEndB().equals(here), ClientUtils.getSolidVertexCountForSide(here, c, 16)));
            }
            ModelKey key = new ModelKey(data, ad, orig.here);
            try {
                SpecificConnectionModel ret = (SpecificConnectionModel)cache.get((Object)key, () -> new SpecificConnectionModel(key, (TextureAtlasSprite)this.textureAtlasSprite.get()));
                RenderType current = MinecraftForgeClient.getRenderLayer();
                ArrayList<BakedQuad> connectionQuads = new ArrayList<BakedQuad>(ret.getQuads(current));
                connectionQuads.addAll(this.getBaseQuads(current, state, side, rand, extraData));
                return connectionQuads;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.getBaseQuads(MinecraftForgeClient.getRenderLayer(), state, side, rand, extraData);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        if (this.base != null) {
            return this.base.func_177554_e();
        }
        return ModelLoader.White.instance();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private List<BakedQuad> getBaseQuads(RenderType currentLayer, BlockState state, Direction side, Random rand, IModelData data) {
        if (this.base != null && (currentLayer == null || this.layers.contains((Object)((RenderTypeAccess)currentLayer).getName()))) {
            return this.base.getQuads(state, side, rand, data);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        if (this.base == null) {
            return EmptyModelData.INSTANCE;
        }
        return this.base.getModelData(world, pos, state, tileData);
    }

    public static List<BakedQuad> convertConnectionFromBlockstate(BlockPos here, Set<Connection.RenderData> data, TextureAtlasSprite t) {
        ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
        if (data == null) {
            return ret;
        }
        Vector3d dir = Vector3d.field_186680_a;
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        for (Connection.RenderData connData : data) {
            int color = connData.color;
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
            if (rgb[3] == 0.0f) {
                rgb[3] = 1.0f;
            }
            float radius = (float)(connData.type.getRenderDiameter() / 2.0);
            for (int segmentEndId = 1; segmentEndId <= connData.pointsToRenderSolid; ++segmentEndId) {
                Vector3d cross;
                boolean vertical;
                int segmentStartId = segmentEndId - 1;
                Vector3d segmentEnd = connData.getPoint(segmentEndId);
                Vector3d segmentStart = connData.getPoint(segmentStartId);
                boolean bl = vertical = segmentEnd.field_72450_a == segmentStart.field_72450_a && segmentEnd.field_72449_c == segmentStart.field_72449_c;
                if (!vertical) {
                    dir = segmentEnd.func_178788_d(segmentStart);
                    cross = up.func_72431_c(dir);
                    cross = cross.func_186678_a((double)radius / cross.func_72433_c());
                } else {
                    cross = new Vector3d((double)radius, 0.0, 0.0);
                }
                Vector3d[] vertices = new Vector3d[]{segmentEnd.func_178787_e(cross), segmentEnd.func_178788_d(cross), segmentStart.func_178788_d(cross), segmentStart.func_178787_e(cross)};
                ret.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.DOWN, t, rgb, false, here));
                ret.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.UP, t, rgb, true, here));
                if (!vertical) {
                    cross = dir.func_72431_c(cross);
                    cross = cross.func_186678_a((double)radius / cross.func_72433_c());
                } else {
                    cross = new Vector3d(0.0, 0.0, (double)radius);
                }
                vertices = new Vector3d[]{segmentEnd.func_178787_e(cross), segmentEnd.func_178788_d(cross), segmentStart.func_178788_d(cross), segmentStart.func_178787_e(cross)};
                ret.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.WEST, t, rgb, false, here));
                ret.add(ClientUtils.createSmartLightingBakedQuad(DefaultVertexFormats.field_176600_a, vertices, Direction.EAST, t, rgb, true, here));
            }
        }
        return ret;
    }

    private static class ModelKey {
        private final Set<Connection.RenderData> connections;
        private final RenderCacheKey state;
        private final BlockPos here;

        private ModelKey(Set<Connection.RenderData> connections, RenderCacheKey state, BlockPos here) {
            this.connections = connections;
            this.state = state;
            this.here = here;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelKey that = (ModelKey)o;
            if (!this.connections.equals(that.connections)) {
                return false;
            }
            return this.state.equals(that.state);
        }

        public int hashCode() {
            int result = this.connections.hashCode();
            result = 31 * result + this.state.hashCode();
            return result;
        }
    }

    public static class SpecificConnectionModel {
        private final Lazy<List<BakedQuad>> connectionQuads = Lazy.concurrentOf(() -> BakedConnectionModel.convertConnectionFromBlockstate(key.here, key.connections, texture));

        public SpecificConnectionModel(ModelKey key, TextureAtlasSprite texture) {
        }

        @Nonnull
        public List<BakedQuad> getQuads(RenderType layer) {
            if (layer != RenderType.func_228639_c_()) {
                return ImmutableList.of();
            }
            return (List)this.connectionQuads.get();
        }
    }
}

