/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ConnectorTileHelper {
    public static IEProperties.ConnectionModelData genConnBlockState(GlobalWireNetwork globalNet, IImmersiveConnectable iic, World world) {
        BlockPos pos = iic.getPosition();
        HashSet<Connection> ret = new HashSet<Connection>();
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            LocalWireNetwork local = globalNet.getLocalNet(cp);
            Collection<Connection> conns = local.getConnections(cp);
            if (conns == null) {
                WireLogger.logger.warn("Aborting and returning empty data: null connections at {}", (Object)cp);
                return new IEProperties.ConnectionModelData((Set<Connection>)ImmutableSet.of(), pos);
            }
            for (Connection c : conns) {
                IImmersiveConnectable otherConnector;
                ConnectionPoint other = c.getOtherEnd(cp);
                if (c.isInternal() || (otherConnector = globalNet.getLocalNet(other).getConnector(other)) == null || otherConnector.isProxy()) continue;
                c.generateCatenaryData(world);
                ret.add(c);
            }
        }
        return new IEProperties.ConnectionModelData(ret, pos);
    }

    public static void onChunkUnload(GlobalWireNetwork globalNet, IImmersiveConnectable iic) {
        globalNet.onConnectorUnload(iic);
    }

    public static void onChunkLoad(GlobalWireNetwork globalNet, IImmersiveConnectable iic, World world) {
        globalNet.onConnectorLoad(iic, world);
    }

    public static void remove(World world, IImmersiveConnectable iic) {
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        if (!world.field_72995_K) {
            BlockPos pos = iic.getPosition();
            Consumer<Connection> dropHandler = world.func_82736_K().func_223586_b(GameRules.field_223603_f) ? c -> {
                if (!c.isInternal()) {
                    BlockPos end = c.getOtherEnd(c.getEndFor(pos)).getPosition();
                    double dx = (double)pos.func_177958_n() + 0.5 + (double)Math.signum(end.func_177958_n() - pos.func_177958_n());
                    double dy = (double)pos.func_177956_o() + 0.5 + (double)Math.signum(end.func_177956_o() - pos.func_177956_o());
                    double dz = (double)pos.func_177952_p() + 0.5 + (double)Math.signum(end.func_177952_p() - pos.func_177952_p());
                    world.func_217376_c((Entity)new ItemEntity(world, dx, dy, dz, c.type.getWireCoil((Connection)c)));
                }
            } : c -> {};
            for (ConnectionPoint cp : iic.getConnectionPoints()) {
                globalNet.removeAllConnectionsAt(cp, dropHandler);
            }
        }
        globalNet.removeConnector(iic);
    }

    public static LocalWireNetwork getLocalNetWithCache(GlobalWireNetwork globalNet, BlockPos pos, int cpIndex, Int2ObjectMap<LocalWireNetwork> cachedLocalNets) {
        LocalWireNetwork ret = (LocalWireNetwork)cachedLocalNets.get(cpIndex);
        ConnectionPoint cp = new ConnectionPoint(pos, cpIndex);
        if (ret == null || !ret.isValid(cp)) {
            ret = globalNet.getLocalNet(cp);
            cachedLocalNets.put(cpIndex, (Object)ret);
        }
        return ret;
    }
}

