/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUtils {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static CompoundNBT parseNbtFromJson(JsonElement jsonElement) throws CommandSyntaxException {
        if (jsonElement.isJsonObject()) {
            return JsonToNBT.func_180713_a((String)GSON.toJson(jsonElement));
        }
        return JsonToNBT.func_180713_a((String)jsonElement.getAsString());
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ItemUtils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return ItemStack.func_179545_c((ItemStack)((ItemStack)o), (ItemStack)stack) && (!checkNBT || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!ItemUtils.stackMatchesObject(stack, io, checkNBT)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientWithSize) {
                return ((IngredientWithSize)o).test(stack);
            }
            if (o instanceof Ingredient) {
                return ((Ingredient)o).test(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!ItemStack.func_179545_c((ItemStack)io, (ItemStack)stack) || checkNBT && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    return FluidUtil.getFluidContained((ItemStack)stack).map(fs -> fs.containsFluid((FluidStack)o)).orElse(false);
                }
                if (o instanceof FluidTagInput) {
                    return ((FluidTagInput)o).test(FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY));
                }
                if (o instanceof ResourceLocation) {
                    return TagUtils.isInBlockOrItemTag(stack, (ResourceLocation)o);
                }
                throw new IllegalArgumentException("Comparison object " + o + " of class " + o.getClass() + " is invalid!");
            }
        }
        return false;
    }

    @Deprecated
    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
    }

    public static HandSide getLivingHand(LivingEntity living, Hand hand) {
        HandSide handside = living.func_184591_cq();
        if (hand != Hand.MAIN_HAND) {
            handside = handside == HandSide.LEFT ? HandSide.RIGHT : HandSide.LEFT;
        }
        return handside;
    }
}

