/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.fluid;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidUtils {
    public static Optional<FluidStack> getFluidContained(@Nonnull ItemStack container) {
        if (!container.func_190926_b()) {
            return FluidUtil.getFluidHandler((ItemStack)container).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        }
        return Optional.empty();
    }

    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, IFluidHandler.FluidAction doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return containerCopy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            FluidStack simulatedMoved = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)handler, (int)maxAmount, (boolean)false);
            if (simulatedMoved.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            handler.drain(simulatedMoved, IFluidHandler.FluidAction.EXECUTE);
            fluidDestination.fill(simulatedMoved, doDrain);
            return new FluidActionResult(handler.getContainer());
        }).orElse(FluidActionResult.FAILURE);
    }
}

