/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.excavator.MineralVein;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class MineralWorldInfo {
    private final List<Pair<MineralVein, Integer>> mineralVeins;
    private final int totalWeight;

    public MineralWorldInfo(List<Pair<MineralVein, Integer>> mineralVeins) {
        this.mineralVeins = mineralVeins;
        this.totalWeight = mineralVeins.stream().map(Pair::getRight).reduce(Integer::sum).orElse(0);
    }

    @Nullable
    public MineralVein getMineralVein(Random rand) {
        MineralVein vein = null;
        if (this.totalWeight == 0) {
            return null;
        }
        int weight = rand.nextInt(this.totalWeight);
        for (Pair<MineralVein, Integer> pair : this.mineralVeins) {
            if ((weight -= ((Integer)pair.getRight()).intValue()) >= 0) continue;
            vein = (MineralVein)pair.getLeft();
            break;
        }
        return vein;
    }

    public List<Pair<MineralVein, Integer>> getAllVeins() {
        return this.mineralVeins;
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }
}

