/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcRecyclingChecker;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.common.CommonProxy;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.config.IECommonConfig;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.IngredientSerializers;
import blusunrize.immersiveengineering.common.crafting.RecipeCachingReloadListener;
import blusunrize.immersiveengineering.common.crafting.RecipeReloadListener;
import blusunrize.immersiveengineering.common.items.DrillheadItem;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.items.ScrewdriverItem;
import blusunrize.immersiveengineering.common.items.WirecutterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.network.MessageClientCommand;
import blusunrize.immersiveengineering.common.network.MessageMagnetEquip;
import blusunrize.immersiveengineering.common.network.MessageMaintenanceKit;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageMultiblockSync;
import blusunrize.immersiveengineering.common.network.MessageNoSpamChatComponents;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.network.MessageRequestBlockUpdate;
import blusunrize.immersiveengineering.common.network.MessageRevolverRotate;
import blusunrize.immersiveengineering.common.network.MessageScrollwheelItem;
import blusunrize.immersiveengineering.common.network.MessageSetGhostSlots;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.network.MessageSkyhookSync;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.network.MessageTileSync;
import blusunrize.immersiveengineering.common.network.MessageWireSync;
import blusunrize.immersiveengineering.common.util.IEIMCHandler;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.commands.CommandHandler;
import blusunrize.immersiveengineering.common.util.commands.CommandMineral;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.world.IEWorldGen;
import blusunrize.immersiveengineering.common.world.Villages;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonStreamParser;
import com.mojang.brigadier.CommandDispatcher;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;

@Mod(value="immersiveengineering")
public class ImmersiveEngineering {
    public static final String MODID = "immersiveengineering";
    public static final String MODNAME = "Immersive Engineering";
    public static final String VERSION = "${version}";
    public static CommonProxy proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static final SimpleChannel packetHandler = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("immersiveengineering", "main")).networkProtocolVersion(() -> "${version}").serverAcceptedVersions("${version}"::equals).clientAcceptedVersions("${version}"::equals).simpleChannel();
    private int messageId = 0;
    private final Set<Class<?>> knownPacketTypes = new HashSet();
    public static ItemGroup itemGroup = new ItemGroup("immersiveengineering"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)IEItems.Misc.wireCoils.get(WireType.COPPER));
        }
    };

    public ImmersiveEngineering() {
        IELogger.logger = LogManager.getLogger((String)MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMCs);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListeners);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        RecipeSerializers.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.POINTS_OF_INTEREST.register(FMLJavaModLoadingContext.get().getModEventBus());
        Villages.Registers.PROFESSIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, IECommonConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, IEClientConfig.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, IEServerConfig.CONFIG_SPEC.getBaseSpec());
        IEContent.modConstruction();
        proxy.modConstruction();
        IngredientSerializers.init();
        IEWorldGen ieWorldGen = new IEWorldGen();
        MinecraftForge.EVENT_BUS.register((Object)ieWorldGen);
        IEWorldGen.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        ApiUtils.disableTicking.setValue(EventHandler.REMOVE_FROM_TICKING::add);
        proxy.preInit();
        IEAdvancements.preInit();
        IEApi.modPreference = (List)IECommonConfig.preferredOres.get();
        IEApi.prefixToIngotMap.put("ingots", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("nuggets", new Integer[]{1, 9});
        IEApi.prefixToIngotMap.put("storage_blocks", new Integer[]{9, 1});
        IEApi.prefixToIngotMap.put("plates", new Integer[]{1, 1});
        IEApi.prefixToIngotMap.put("wires", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("gears", new Integer[]{4, 1});
        IEApi.prefixToIngotMap.put("rods", new Integer[]{1, 2});
        IEApi.prefixToIngotMap.put("fences", new Integer[]{5, 3});
        IECompatModule.doModulesPreInit();
        ArcRecyclingChecker.allowRecipeTypeForRecycling(IRecipeType.field_222149_a);
        ArcRecyclingChecker.allowRecipeTypeForRecycling(MetalPressRecipe.TYPE);
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof ToolItem || stack instanceof ShearsItem || stack instanceof SwordItem || stack instanceof ArmorItem || stack instanceof HorseArmorItem || stack instanceof BucketItem);
        ArcRecyclingChecker.allowSimpleItemForRecycling(stack -> stack instanceof HammerItem || stack instanceof WirecutterItem || stack instanceof ScrewdriverItem || stack instanceof DrillheadItem);
        ArcRecyclingChecker.allowEnumeratedItemsForRecycling(() -> Stream.of(IEItems.Molds.moldPlate, IEItems.Molds.moldGear, IEItems.Molds.moldRod, IEItems.Molds.moldBulletCasing, IEItems.Molds.moldWire, IEItems.Molds.moldPacking4, IEItems.Molds.moldPacking9, IEItems.Molds.moldUnpacking));
        ArcRecyclingChecker.allowItemTagForRecycling(IETags.plates);
        ArcRecyclingChecker.allowPrefixedTagForRecycling("rods/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("wires/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("gears/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("scaffoldings/");
        ArcRecyclingChecker.allowPrefixedTagForRecycling("fences/");
        ArcRecyclingChecker.makeItemInvalidRecyclingOutput(stack -> stack.func_77973_b() instanceof HammerItem || stack.func_77973_b() instanceof WirecutterItem || stack.func_77973_b() instanceof ScrewdriverItem);
        ArcRecyclingChecker.makeItemInvalidRecyclingOutput(stack -> TagUtils.isIngot(stack) && Objects.requireNonNull(TagUtils.getMatchingPrefixAndRemaining(stack, "ingots"))[1].contains("brick"));
        new ThreadContributorSpecialsDownloader();
        proxy.preInitEnd();
        IEContent.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        proxy.init();
        IECompatModule.doModulesInit();
        proxy.initEnd();
        this.registerMessage(MessageTileSync.class, MessageTileSync::new);
        this.registerMessage(MessageSpeedloaderSync.class, MessageSpeedloaderSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageSkyhookSync.class, MessageSkyhookSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMinecartShaderSync.class, MessageMinecartShaderSync::new);
        this.registerMessage(MessageRequestBlockUpdate.class, MessageRequestBlockUpdate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageNoSpamChatComponents.class, MessageNoSpamChatComponents::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageShaderManual.class, MessageShaderManual::new);
        this.registerMessage(MessageBirthdayParty.class, MessageBirthdayParty::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMagnetEquip.class, MessageMagnetEquip::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageScrollwheelItem.class, MessageScrollwheelItem::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageObstructedConnection.class, MessageObstructedConnection::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageSetGhostSlots.class, MessageSetGhostSlots::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageWireSync.class, MessageWireSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageMaintenanceKit.class, MessageMaintenanceKit::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageRevolverRotate.class, MessageRevolverRotate::new, NetworkDirection.PLAY_TO_SERVER);
        this.registerMessage(MessageMultiblockSync.class, MessageMultiblockSync::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerMessage(MessageClientCommand.class, MessageClientCommand::new, NetworkDirection.PLAY_TO_CLIENT);
        IEIMCHandler.init();
        event.enqueueWork(Villages::init);
        proxy.postInit();
        IECompatModule.doModulesPostInit();
        proxy.postInitEnd();
        ShaderRegistry.compileWeight();
        CommandMineral.registerArguments();
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<PacketBuffer, T> decoder) {
        this.registerMessage(packetType, decoder, Optional.empty());
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<PacketBuffer, T> decoder, NetworkDirection direction) {
        this.registerMessage(packetType, decoder, Optional.of(direction));
    }

    private <T extends IMessage> void registerMessage(Class<T> packetType, Function<PacketBuffer, T> decoder, Optional<NetworkDirection> direction) {
        if (!this.knownPacketTypes.add(packetType)) {
            throw new IllegalStateException("Duplicate packet type: " + packetType.getName());
        }
        packetHandler.registerMessage(this.messageId++, packetType, IMessage::toBytes, decoder, (t, ctx) -> {
            t.process((Supplier<NetworkEvent.Context>)ctx);
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }, direction);
    }

    public void enqueueIMCs(InterModEnqueueEvent event) {
        IECompatModule.doModulesIMCs();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        IECompatModule.doModulesLoadComplete();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        proxy.serverStarting();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        CommandHandler.registerServer((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public void addReloadListeners(AddReloadListenerEvent event) {
        DataPackRegistries dataPackRegistries = event.getDataPackRegistries();
        event.addListener((IFutureReloadListener)new RecipeReloadListener(dataPackRegistries));
    }

    public void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new RecipeCachingReloadListener(event.getDataPackRegistries()));
    }

    public void serverStarted(FMLServerStartedEvent event) {
        ServerWorld world = event.getServer().func_71218_a(World.field_234918_g_);
        if (!world.field_72995_K) {
            IESaveData worldData = (IESaveData)world.func_217481_x().func_215752_a(IESaveData::new, "ImmersiveEngineering-SaveData");
            IESaveData.setInstance(worldData);
        }
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static class ThreadContributorSpecialsDownloader
    extends Thread {
        public static ThreadContributorSpecialsDownloader activeThread;

        public ThreadContributorSpecialsDownloader() {
            this.setName("Immersive Engineering Contributors Thread");
            this.setDaemon(true);
            this.start();
            activeThread = this;
        }

        @Override
        public void run() {
            Gson gson = new Gson();
            try {
                IELogger.info("Attempting to download special revolvers from GitHub");
                URL url = new URL("https://raw.githubusercontent.com/BluSunrize/ImmersiveEngineering/gh-pages/contributorRevolvers.json");
                JsonStreamParser parser = new JsonStreamParser((Reader)new InputStreamReader(url.openStream()));
                while (parser.hasNext()) {
                    try {
                        JsonElement je = parser.next();
                        RevolverItem.SpecialRevolver revolver = (RevolverItem.SpecialRevolver)gson.fromJson(je, RevolverItem.SpecialRevolver.class);
                        if (revolver == null) continue;
                        if (revolver.uuid != null) {
                            for (String uuid : revolver.uuid) {
                                RevolverItem.specialRevolvers.put((Object)uuid, (Object)revolver);
                            }
                        }
                        RevolverItem.specialRevolversByTag.put(!revolver.tag.isEmpty() ? revolver.tag : revolver.flavour, revolver);
                    }
                    catch (Exception excepParse) {
                        IELogger.warn("Error on parsing a SpecialRevolver");
                    }
                }
            }
            catch (Exception e) {
                IELogger.logger.info("Could not load contributor+special revolver list.", (Throwable)e);
            }
        }
    }
}

