/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.tileentity;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.api.tileentity.TANTileEntityTypes;
import toughasnails.block.WaterPurifierBlock;
import toughasnails.container.WaterPurifierContainer;
import toughasnails.crafting.WaterPurifierRecipe;

public class WaterPurifierTileEntity
extends LockableTileEntity
implements ISidedInventory,
ITickableTileEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int filterTimeRemaining;
    private int filterDuration;
    private int purifyProgress;
    private int purifyTotalTime;
    protected final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return WaterPurifierTileEntity.this.filterTimeRemaining;
                }
                case 1: {
                    return WaterPurifierTileEntity.this.filterDuration;
                }
                case 2: {
                    return WaterPurifierTileEntity.this.purifyProgress;
                }
                case 3: {
                    return WaterPurifierTileEntity.this.purifyTotalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    WaterPurifierTileEntity.this.filterTimeRemaining = value;
                    break;
                }
                case 1: {
                    WaterPurifierTileEntity.this.filterDuration = value;
                    break;
                }
                case 2: {
                    WaterPurifierTileEntity.this.purifyProgress = value;
                    break;
                }
                case 3: {
                    WaterPurifierTileEntity.this.purifyTotalTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public WaterPurifierTileEntity() {
        super(TANTileEntityTypes.WATER_PURIFIER);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.filterTimeRemaining = nbt.func_74762_e("FilterTimeRemaining");
        this.filterDuration = nbt.func_74762_e("FilterDuration");
        this.purifyProgress = nbt.func_74762_e("PurifyProgress");
        this.purifyTotalTime = nbt.func_74762_e("PurifyTotalTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FilterTimeRemaining", this.filterTimeRemaining);
        nbt.func_74768_a("FilterDuration", this.filterDuration);
        nbt.func_74768_a("PurifyProgress", this.purifyProgress);
        nbt.func_74768_a("PurifyTotalTime", this.purifyTotalTime);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        return nbt;
    }

    public void func_73660_a() {
        boolean previouslyFiltering = this.currentlyFiltering();
        boolean changed = false;
        if (this.currentlyFiltering() && this.purifyProgress > 0) {
            --this.filterTimeRemaining;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack filterStack = (ItemStack)this.items.get(1);
            if (this.currentlyFiltering() || !filterStack.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(TANRecipeTypes.WATER_PURIFYING, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.currentlyFiltering() && this.canFilter(irecipe)) {
                    this.filterDuration = this.filterTimeRemaining = WaterPurifierTileEntity.getFilterDuration(filterStack);
                    if (this.currentlyFiltering()) {
                        changed = true;
                        if (filterStack.hasContainerItem()) {
                            this.items.set(1, (Object)filterStack.getContainerItem());
                        } else if (!filterStack.func_190926_b()) {
                            filterStack.func_190918_g(1);
                            if (filterStack.func_190926_b()) {
                                this.items.set(1, (Object)filterStack.getContainerItem());
                            }
                        }
                    }
                }
                if (this.currentlyFiltering() && this.canFilter(irecipe)) {
                    ++this.purifyProgress;
                    if (this.purifyProgress == this.purifyTotalTime) {
                        this.purifyProgress = 0;
                        this.purifyTotalTime = this.getTotalPurifyTime();
                        this.filter(irecipe);
                        changed = true;
                    }
                } else {
                    this.purifyProgress = 0;
                }
            } else if (!this.currentlyFiltering() && this.purifyProgress > 0) {
                this.purifyProgress = MathHelper.func_76125_a((int)(this.purifyProgress - 2), (int)0, (int)this.purifyTotalTime);
            }
            if (previouslyFiltering != this.currentlyFiltering()) {
                changed = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)WaterPurifierBlock.PURIFYING, (Comparable)Boolean.valueOf(this.currentlyFiltering())), 3);
            }
        }
        if (changed) {
            this.func_70296_d();
        }
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new WaterPurifierContainer(id, player, (IInventory)this, this.dataAccess);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.toughasnails.water_purifier");
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case DOWN: {
                return SLOTS_FOR_DOWN;
            }
            case UP: {
                return SLOTS_FOR_UP;
            }
        }
        return SLOTS_FOR_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return direction != Direction.DOWN || index != 1;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack currentStack = (ItemStack)this.items.get(index);
        boolean sameItem = !stack.func_190926_b() && stack.func_77969_a(currentStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentStack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !sameItem) {
            this.purifyTotalTime = this.getTotalPurifyTime();
            this.purifyProgress = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public boolean currentlyFiltering() {
        return this.filterTimeRemaining > 0;
    }

    protected boolean canFilter(@Nullable IRecipe<?> recipe) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipe != null) {
            ItemStack recipeResult = recipe.func_77571_b();
            if (recipeResult.func_190926_b()) {
                return false;
            }
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.func_190926_b()) {
                return true;
            }
            if (!currentResult.func_77969_a(recipeResult)) {
                return false;
            }
            if (currentResult.func_190916_E() + recipeResult.func_190916_E() <= this.func_70297_j_() && currentResult.func_190916_E() + recipeResult.func_190916_E() <= currentResult.func_77976_d()) {
                return true;
            }
            return currentResult.func_190916_E() + recipeResult.func_190916_E() <= recipeResult.func_77976_d();
        }
        return false;
    }

    protected int getTotalPurifyTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(TANRecipeTypes.WATER_PURIFYING, (IInventory)this, this.field_145850_b).map(WaterPurifierRecipe::getPurifyTime).orElse(200);
    }

    private void filter(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canFilter(recipe)) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack recipeResult = recipe.func_77571_b();
            ItemStack currentResult = (ItemStack)this.items.get(2);
            if (currentResult.func_190926_b()) {
                this.items.set(2, (Object)recipeResult.func_77946_l());
            } else if (currentResult.func_77973_b() == recipeResult.func_77973_b()) {
                currentResult.func_190917_f(recipeResult.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    public static boolean isFilter(ItemStack stack) {
        return WaterPurifierTileEntity.getFilterDuration(stack) > 0;
    }

    public static int getFilterDuration(ItemStack filter) {
        if (filter == null || filter.func_190926_b()) {
            return 0;
        }
        return (Integer)WaterPurifierTileEntity.getFilterDurations().getOrDefault((Object)filter.func_77973_b(), (Object)0);
    }

    private static ImmutableMap<Item, Integer> getFilterDurations() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Items.field_196155_l, (Object)1200);
        return builder.build();
    }
}

