/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public class MessageUpdateThirst {
    public int thirstLevel;
    public float hydrationLevel;

    public MessageUpdateThirst(int thirstLevel, float hydrationLevel) {
        this.thirstLevel = thirstLevel;
        this.hydrationLevel = hydrationLevel;
    }

    public static void encode(MessageUpdateThirst packet, PacketBuffer buf) {
        buf.writeInt(packet.thirstLevel);
        buf.writeFloat(packet.hydrationLevel);
    }

    public static MessageUpdateThirst decode(PacketBuffer buf) {
        return new MessageUpdateThirst(buf.readInt(), buf.readFloat());
    }

    public static class Handler {
        public static void handle(MessageUpdateThirst packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (FMLEnvironment.dist != Dist.CLIENT) {
                    return;
                }
                Handler.updateThirst(packet.thirstLevel, packet.hydrationLevel);
            });
            context.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void updateThirst(int thirstLevel, float hydration) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            IThirst thirst = ThirstHelper.getThirst((PlayerEntity)player);
            thirst.setThirst(thirstLevel);
            thirst.setHydration(hydration);
        }
    }
}

