/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.fml.network.NetworkEvent;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.config.ThirstConfig;

public class MessageDrinkInWorld {
    public BlockPos pos;

    public MessageDrinkInWorld(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(MessageDrinkInWorld packet, PacketBuffer buf) {
        buf.func_179255_a(packet.pos);
    }

    public static MessageDrinkInWorld decode(PacketBuffer buf) {
        return new MessageDrinkInWorld(buf.func_179259_c());
    }

    public static class Handler {
        public static void handle(MessageDrinkInWorld packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
                World world = player.field_70170_p;
                IThirst thirst = ThirstHelper.getThirst((PlayerEntity)player);
                if (world.func_175660_a((PlayerEntity)player, packet.pos) && world.func_204610_c(packet.pos).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    thirst.addThirst((Integer)ThirstConfig.handDrinkingThirst.get());
                    thirst.addHydration(((Double)ThirstConfig.handDrinkingHydration.get()).floatValue());
                    RegistryKey biome = player.field_70170_p.func_242406_i(packet.pos).orElse(Biomes.field_76772_c);
                    if (player.field_70170_p.field_73012_v.nextFloat() < ThirstConfig.getBiomeWaterType((RegistryKey<Biome>)biome).getPoisonChance()) {
                        player.func_195064_c(new EffectInstance(TANEffects.THIRST, 600));
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

