/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import sereneseasons.handler.season.SeasonHandler;

public class MessageSyncSeasonCycle {
    public RegistryKey<World> dimension;
    public int seasonCycleTicks;

    public MessageSyncSeasonCycle() {
    }

    public MessageSyncSeasonCycle(RegistryKey<World> dimension, int seasonCycleTicks) {
        this.dimension = dimension;
        this.seasonCycleTicks = seasonCycleTicks;
    }

    public static void encode(MessageSyncSeasonCycle packet, PacketBuffer buf) {
        buf.func_180714_a(packet.dimension.func_240901_a_().toString());
        buf.writeInt(packet.seasonCycleTicks);
    }

    public static MessageSyncSeasonCycle decode(PacketBuffer buf) {
        return new MessageSyncSeasonCycle((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_218666_n())), buf.readInt());
    }

    public static class Handler {
        public static void handle(MessageSyncSeasonCycle packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (Minecraft.func_71410_x().field_71439_g == null) {
                    return;
                }
                RegistryKey playerDimension = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_234923_W_();
                if (playerDimension.equals(packet.dimension)) {
                    SeasonHandler.clientSeasonCycleTicks.replace((RegistryKey<World>)playerDimension, packet.seasonCycleTicks);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

