/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLEnvironment;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.handler.season.RandomUpdateHandler;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.handler.season.SeasonalCropGrowthHandler;
import sereneseasons.handler.season.TimeSkipHandler;
import sereneseasons.season.SeasonTime;
import sereneseasons.util.SeasonColorUtil;
import sereneseasons.util.biome.BiomeUtil;

public class ModHandlers {
    private static final SeasonHandler SEASON_HANDLER = new SeasonHandler();
    @OnlyIn(value=Dist.CLIENT)
    private static ColorResolver originalGrassColorResolver;
    @OnlyIn(value=Dist.CLIENT)
    private static ColorResolver originalFoliageColorResolver;

    public static void init() {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)SEASON_HANDLER);
        SeasonHelper.dataProvider = SEASON_HANDLER;
        MinecraftForge.EVENT_BUS.register((Object)new RandomUpdateHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeasonalCropGrowthHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TimeSkipHandler());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModHandlers.registerSeasonColourHandlers();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerSeasonColourHandlers() {
        originalGrassColorResolver = BiomeColors.field_180291_a;
        originalFoliageColorResolver = BiomeColors.field_180289_b;
        BiomeColors.field_180291_a = (biome, x, z) -> {
            RegistryKey<Biome> biomeKey = BiomeUtil.getBiomeKey(biome);
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biomeKey) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColorUtil.applySeasonalGrassColouring(colorProvider, biomeKey, originalGrassColorResolver.getColor(biome, x, z));
        };
        BiomeColors.field_180289_b = (biome, x, z) -> {
            RegistryKey<Biome> biomeKey = BiomeUtil.getBiomeKey(biome);
            SeasonTime calendar = SeasonHandler.getClientSeasonTime();
            Enum colorProvider = BiomeConfig.usesTropicalSeasons(biomeKey) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            return SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, biomeKey, originalFoliageColorResolver.getColor(biome, x, z));
        };
    }
}

