/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.utility;

import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class Color {
    public static final Color INVALID_COLOR = new Color(-1.0f, -1.0f, -1.0f, -1.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private static final String COLOR_TAG = "color";
    public final float a;
    public final float b;
    public final float g;
    public final float r;

    public Color(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    public Color(int color) {
        this(color, true);
    }

    public Color(int color, boolean ignoreAlpha) {
        if (ignoreAlpha) {
            this.a = 1.0f;
            this.r = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
        } else {
            this.a = (float)(color >> 24 & 0xFF) / 255.0f;
            this.r = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.b = (float)(color & 0xFF) / 255.0f;
        }
    }

    public Color(String hex) {
        this(Integer.parseInt(hex, 16));
    }

    public static Color average(Color colorA, Color colorB, float percentage) {
        float opposite = 1.0f - percentage;
        float averageR = (float)Math.sqrt(colorA.r * colorA.r * opposite + colorB.r * colorB.r * percentage);
        float averageG = (float)Math.sqrt(colorA.g * colorA.g * opposite + colorB.r * colorB.g * percentage);
        float averageB = (float)Math.sqrt(colorA.b * colorA.b * opposite + colorB.r * colorB.b * percentage);
        float averageA = colorA.a * opposite + colorB.a * percentage;
        return new Color(averageR, averageG, averageB, averageA);
    }

    public static Color fromNBT(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74764_b(COLOR_TAG)) {
            CompoundNBT colorTag = compoundNBT.func_74775_l(COLOR_TAG);
            float a = colorTag.func_74760_g("colorA");
            float r = colorTag.func_74760_g("colorR");
            float b = colorTag.func_74760_g("colorB");
            float g = colorTag.func_74760_g("colorG");
            return new Color(a, r, b, g);
        }
        return INVALID_COLOR;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Float.compare(color.r, this.r) == 0 && Float.compare(color.g, this.g) == 0 && Float.compare(color.b, this.b) == 0 && Float.compare(color.a, this.a) == 0;
    }

    public String getAsHexNoAlpha() {
        return Integer.toHexString(this.toIntNoAlpha());
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public void putIntoNBT(CompoundNBT compoundNBT) {
        CompoundNBT colorTag = new CompoundNBT();
        colorTag.func_74776_a("colorA", this.a);
        colorTag.func_74776_a("colorR", this.r);
        colorTag.func_74776_a("colorB", this.b);
        colorTag.func_74776_a("colorG", this.g);
        compoundNBT.func_218657_a(COLOR_TAG, (INBT)colorTag);
    }

    public int toInt() {
        int color = 0;
        color |= (int)(this.a * 255.0f) << 24;
        color |= (int)(this.r * 255.0f) << 16;
        color |= (int)(this.g * 255.0f) << 8;
        return color |= (int)(this.b * 255.0f);
    }

    public int toIntNoAlpha() {
        int color = 0;
        color |= (int)(this.r * 255.0f) << 16;
        color |= (int)(this.g * 255.0f) << 8;
        return color |= (int)(this.b * 255.0f);
    }

    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + '}';
    }
}

