/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.tileentity.barrel.mode;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.item.dolls.DollItem;
import novamachina.exnihilosequentia.common.item.dolls.EnumDoll;
import novamachina.exnihilosequentia.common.tileentity.barrel.AbstractBarrelTile;
import novamachina.exnihilosequentia.common.tileentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.StringUtils;

public class MobSpawnBarrelMode
extends AbstractBarrelMode {
    private static final String CURRENT_PROGRESS_TAG = "currentProgress";
    private static final String DOLL_TYPE_TAG = "dollType";
    private int currentProgress = 0;
    private DollItem doll = null;

    public MobSpawnBarrelMode(String name) {
        super(name);
    }

    public void setDoll(DollItem doll) {
        this.doll = doll;
    }

    @Override
    public void tick(AbstractBarrelTile barrelTile) {
        if (this.doll != null) {
            ++this.currentProgress;
            this.spawnParticle(barrelTile);
            if (this.currentProgress >= Config.getSecondsToSpawn() * 20 && this.doll.spawnMob(barrelTile.func_145831_w(), barrelTile.func_174877_v())) {
                barrelTile.getTank().setFluid(FluidStack.EMPTY);
                barrelTile.setMode("empty");
            }
        }
    }

    @Override
    public ActionResultType onBlockActivated(AbstractBarrelTile barrelTile, PlayerEntity player, Hand handIn, IFluidHandler fluidHandler, IItemHandler itemHandler) {
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean canFillWithFluid(AbstractBarrelTile barrel) {
        return false;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(ItemStack stack) {
        return false;
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.currentProgress = nbt.func_74764_b(CURRENT_PROGRESS_TAG) ? nbt.func_74762_e(CURRENT_PROGRESS_TAG) : 0;
        if (nbt.func_74764_b(DOLL_TYPE_TAG)) {
            this.setDoll((DollItem)EnumDoll.getDollFromString(nbt.func_74779_i(DOLL_TYPE_TAG)).getRegistryObject().get());
        } else {
            this.setDoll(null);
        }
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(CURRENT_PROGRESS_TAG, this.currentProgress);
        nbt.func_74778_a(DOLL_TYPE_TAG, this.doll.getDollType());
        return nbt;
    }

    @Override
    protected void spawnParticle(AbstractBarrelTile barrelTile) {
        ((ServerWorld)barrelTile.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)barrelTile.func_174877_v().func_177958_n() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177956_o() + barrelTile.func_145831_w().field_73012_v.nextDouble(), (double)barrelTile.func_174877_v().func_177952_p() + barrelTile.func_145831_w().field_73012_v.nextDouble(), 5, 0.0, 0.0, 0.0, 0.05);
    }

    @Override
    public List<ITextComponent> getWailaInfo(AbstractBarrelTile barrelTile) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        info.add((ITextComponent)new TranslationTextComponent("waila.progress", new Object[]{StringUtils.formatPercent(Float.valueOf((float)this.currentProgress / (float)(Config.getSecondsToSpawn() * 20)))}));
        return info;
    }

    @Override
    public ItemStack handleInsert(AbstractBarrelTile barrelTile, ItemStack stack, boolean simulate) {
        return stack;
    }
}

